

/*
 

*/


//  Rotary Encoder

#define CLK 10    // Rotary encoder1 clk pin = d10 
#define DT  11    // Rotary encoder1 dt pin  = d11 
#define SW  12    // Rotary encoder1 sw pin  = d12  

#define CLK2 19   // Rotary encoder2 clk pin = a5=d19 
#define DT2  18   // Rotary encoder2 dt pin  = a4=d18 
#define SW2  17   // Rotary encoder2 sw pin  = a3=d17 

#define CLK3 16   // Rotary encoder3 clk pin = a2=d16  
#define DT3  15   // Rotary encoder3 dt pin  = a1=d15 
#define SW3  14   // Rotary encoder3 sw pin  = a0=d14 

int btnState = 0;                   // used by read_encoder1 Routine
unsigned long lastButtonPress = 0;  // used by read_encoder1  Routine
int counter = 0;                    // used by read_rotary_encoder1 routine
int currentStateCLK;                // used by read_rotary_encoder1 routine
int lastStateCLK;                   // used by read_rotary_encoder1 routine
String currentDir = "";             // used by read_rotary_encoder1 routine

int btnState2 = 0;                  // used by read_encoder2 Routine
unsigned long lastButtonPress2 = 0; // used by read_encoder2 Routine
int counter2 = 0;                   // used by read_rotary_encoder2 routine
int currentStateCLK2;               // used by read_rotary_encoder2 routine
int lastStateCLK2;                  // used by read_rotary_encoder2 routine
String currentDir2 = "";            // used by read_rotary_encoder2 routine


int btnState3 = 0;                  // used by read_encoder3 Routine
unsigned long lastButtonPress3 = 0; // used by read_encoder3 Routine
int counter3 = 0;                   // used by read_rotary_encoder3 routine
int currentStateCLK3;               // used by read_rotary_encoder3 routine
int lastStateCLK3;                  // used by read_rotary_encoder3 routine
String currentDir3 = "";            // used by read_rotary_encoder3 routine




void setup() {

  // Setup  Rotary Encoder 1,2 and 3 pins

  pinMode(CLK, INPUT);
  pinMode(DT, INPUT);
  pinMode(SW, INPUT_PULLUP);

  pinMode(CLK2, INPUT);
  pinMode(DT2, INPUT);
  pinMode(SW2, INPUT_PULLUP);


  pinMode(CLK3, INPUT);
  pinMode(DT3, INPUT);
  pinMode(SW3, INPUT_PULLUP);
  
  // Read the initial state of CLK a0-d14
  // Read the initial state of CLK2 a5-d19
  // Read the initial state of CLK3 d10


  lastStateCLK  = digitalRead(CLK);
  lastStateCLK2 = digitalRead(CLK2);
  lastStateCLK3 = digitalRead(CLK3);


  Serial.begin(9600); // baud rate

}

void loop() {

   read_encoder1_switch() ;        // read rotary encoder1 switch routine
   read_encoder2_switch() ;        // read rotary encoder2 switch routine
   read_encoder3_switch() ;        // read rotary encoder3 switch routine
   read_rotary_encoder1() ;        // read rotary encoder1 potentiometer position routine
   read_rotary_encoder2() ;        // read rotary encoder2 potentiometer position routine
   read_rotary_encoder3() ;        // read rotary encoder3 potentiometer position routine
 

 } // main loop



void read_encoder1_switch()        // rotary encoder1 switch routine
{

  // Read the button state
  btnState = digitalRead(SW);     

  // If we detect LOW signal, button is pressed
  
  if (btnState == LOW)
  {
  //  if 50ms have passed since last LOW pulse, it means that the
  //  button has been pressed, released and pressed again

  if (millis() - lastButtonPress > 50)
  {
  Serial.println("encoder 1 pressed!");
  }
  // Remember last button press event
  lastButtonPress = millis();
  }

  // Put in a slight delay to help debounce the reading
  delay(1); //  1 = 1MS
} // main loop

void read_encoder2_switch()         // rotary encoder2 routine
{  


  // Read the button state
  btnState2 = digitalRead(SW2);    // PIN D16 = A2 INPUT

  // If we detect LOW signal, button is pressed
  if (btnState2 == LOW)
  {
  //  if 50ms have passed since last LOW pulse, it means that the
  //  button has been pressed, released and pressed again
  if (millis() - lastButtonPress2 > 50)
  {
  Serial.println("encoder 2 pressed!");
  }
  // Remember last button press event
  lastButtonPress2 = millis();
  }

  // Put in a slight delay to help debounce the reading
  delay(1); //  1 = 1MS for debouncing 
} // main loop

void read_encoder3_switch()        // rotary encoder3 switch routine
{

  // Read the button state
  btnState3 = digitalRead(SW3);     

  // If we detect LOW signal, button is pressed
  
  if (btnState3 == LOW)
  {
  //  if 50ms have passed since last LOW pulse, it means that the
  //  button has been pressed, released and pressed again

  if (millis() - lastButtonPress3 > 50)
  {
  Serial.println("encoder 3 pressed!");
  }
  // Remember last button press event
  lastButtonPress3 = millis();
  }

  // Put in a slight delay to help debounce the reading
  delay(1); //  1 = 1MS
} // main loop


void read_rotary_encoder1()    
{
  currentStateCLK = digitalRead(CLK);   // Read the current state of CLK
  // If last and current state of CLK are different, then pulse occurred
  // React to only 1 state change to avoid double count
  if (currentStateCLK != lastStateCLK  && currentStateCLK == 1)
  {
  if (digitalRead(DT) != currentStateCLK) // If DT state is different than CLK state then, encoder is rotating CW
  {
  counter ++;                         // Encoder is rotating CW so increment
  currentDir = "Encoder 1 CW";
  Serial.print(currentDir);           
  Serial.println("");
  }
  else
  {
  counter --;                      // Encoder is rotating CCW so decrement
  currentDir = "Encoder 1 CCW";
  Serial.print(currentDir);         
  Serial.println("");
  }
  
  }
  // Remember last CLK state
  lastStateCLK = currentStateCLK;

}

void read_rotary_encoder2()
{
  currentStateCLK2 = digitalRead(CLK2);   // Read the current state of CLK2
  // If last and current state of CLK2 are different, then pulse occurred
  // React to only 1 state change to avoid double count
  if (currentStateCLK2 != lastStateCLK2  && currentStateCLK2 == 1)
  {
  if (digitalRead(DT2) != currentStateCLK2) // If DT state is different than CLK2 state then, encoder is rotating CW
  {
  counter2 ++;                         // Encoder is rotating CW so increment
  currentDir2 = "Encoder 2 CW";
  Serial.print(currentDir2);           
  Serial.println("");
  }
  else
  {
  counter2 --;                      // Encoder is rotating CCW so decrement
  currentDir2 = "Encoder 2 CCW";
  Serial.print(currentDir2);         
  Serial.println("");
  }
  }
  // Remember last CLK2 state
  lastStateCLK2 = currentStateCLK2;
}

void read_rotary_encoder3()
{
  currentStateCLK3 = digitalRead(CLK3);   // Read the current state of CLK3
  // If last and current state of CLK3 are different, then pulse occurred
  // React to only 1 state change to avoid double count
  if (currentStateCLK3 != lastStateCLK3  && currentStateCLK3 == 1)
  {
  if (digitalRead(DT3) != currentStateCLK3) // If DT state is different than CLK3 state then, encoder is rotating CW 
  { 
  counter3 ++;                     // Encoder is rotating CW so increment
  currentDir3 = "Encoder 3 CW";
  Serial.print(currentDir3);
  Serial.println("");
  } 
  else
  { 
  counter3 --;                      // Encoder is rotating CCW so decrement
  currentDir3 = "Encoder 3 CCW";
  Serial.print(currentDir3);
  Serial.println("");
  }   
  }

  // Remember last CLK state
  lastStateCLK3 = currentStateCLK3;

} 
