
/*

   
*/


#include <Keypad.h>

//  Rotary Encoder

#define CLK 10    // Rotary encoder1 clk pin = d10 
#define DT  11    // Rotary encoder1 dt pin  = d11 
#define SW  12    // Rotary encoder1 sw pin  = d12  

#define CLK2 19   // Rotary encoder2 clk pin = a5=d19 
#define DT2  18   // Rotary encoder2 dt pin  = a4=d18 
#define SW2  17   // Rotary encoder2 sw pin  = a3=d17 

#define CLK3 16   // Rotary encoder3 clk pin = a2=d16  
#define DT3  15   // Rotary encoder3 dt pin  = a1=d15 
#define SW3  14   // Rotary encoder3 sw pin  = a0=d14 

#define SSB_L  '1'    // SSB lsb == MD01 
#define SSB_U  '2'    // SSB usb == MD02
#define AM     '5'    // AM = MD05 
#define FM     '4'    // FM = MD04


#define CW_L   '3'    // CW  lsb == MD03 
#define CW_U   '7'    // cw  usb == MD07

#define RTTY_L '6'    // RTTY  lsb == MD06 
#define RTTY_U '9'    // RTTY  usb == MD09

#define DATA_U '8'    // DATA   usb == MD08 
#define DATA_L 'C'    // DATA   lsb == MD0C

#define FM_N   'B'    // FM narrow = MD0B
 


#define NARROW false  // width_flag == false - narrow mode yes     
#define WIDE   true   // width_flag == true  - wide mode yes     


int btnState = 0;                   // used by read_encoder1_switch function
unsigned long lastButtonPress = 0;  // used by read_encoder1_switch function
int counter = 0;                    // used by read_rotary_encoder1_power function
int currentStateCLK;                // used by read_rotary_encoder1_power function
int lastStateCLK;                   // used by read_rotary_encoder1_power function
String currentDir = "";             // used by read_rotary_encoder1_power function

int btnState2 = 0;                  // used by read_encoder2_switch function
unsigned long lastButtonPress2 = 0; // used by read_encoder2_switch function
int counter2 = 0;                   // used by read_rotary_encoder2_dnr function
int currentStateCLK2;               // used by read_rotary_encoder2_dnr function
int lastStateCLK2;                  // used by read_rotary_encoder2_dnr function
String currentDir2 = "";            // used by read_rotary_encoder2_dnr function


int btnState3 = 0;                  // used by read_encoder3_switch function
unsigned long lastButtonPress3 = 0; // used by read_encoder3_switch function
int counter3 = 0;                   // used by read_rotary_encoder3_width function
int currentStateCLK3;               // used by read_rotary_encoder3_width function
int lastStateCLK3;                  // used by read_rotary_encoder3_width function
String currentDir3 = "";            // used by read_rotary_encoder3_width function

//  KeyPad

const byte nb_rows = 4;                 // four rows
const byte nb_cols = 4;                 // four columns
char key_chars[nb_rows][nb_cols] = {    // The symbols of the keys
  {'1', '2', '3', 'A'},
  {'4', '5', '6', 'B'},
  {'7', '8', '9', 'C'},
  {'*', '0', '#', 'D'}
};


byte rowPins[nb_rows] = {9, 8, 7, 6};   // row pins R1=9, R2=8, R3=7, R4=6
byte colPins[nb_cols] = {5, 4, 3, 2};   // columns pins C1=5,C2-4,C3=3,C4=2
char key_pressed ;                      // used by Keypad library to store the pressed key.

Keypad kp1((char*)key_chars, rowPins, colPins, nb_rows, nb_cols);   // New keypad calls kp1

// General

#define freq_upper_limit 54000    // FT891 upper freq limit in KC - used by send_to_FT891 function
#define freq_lower_limit 1800     // FT891 lower freq limit in KC - used by send_to_FT891 function

byte FT891_mode_select = 2 ;      // FT891 mode of aperation  at reset = 2 USB,: LSB =1,  3=CW, 4=FM, 5=AM
byte FT891_band_select = 1 ;      // FT891 band at reset 1 = 80m - 3,5mhz,

bool width_flag ;                 // used by read_rotary_encoder3_width()  will be true when in wide mode,
                                  // false when in narrow mode.
bool width_on  ;                  // true when if width is on - false when if width is off
                                  
char mode_setting ;               // used by read_rotary_encoder3_width() function to store the 
                                  // current mode setting 

byte digit1 = 0xff ;              // buffer where all ascii digits are saved
byte digit2 = 0xff ;              // used by main and convert_ascii_digits_to_bcd_format function
byte digit3 = 0xff ;              //
byte digit4 = 0xff ;              //
byte digit5 = 0xff ;              //

char ctrl_cmd_ft891_char2 ;       // used by          pc_power_level_settings3()
char ctrl_cmd_ft891_char3 ;       // used by: used by pc_power_level_settings3() and if_width_level_settings()
char ctrl_cmd_ft891_char4 ;       // used by: used by pc_power_level_settings3() and if_width_level_settings() 
char ctrl_cmd_ft891_char5 ;       // used by: used by pc_power_level_settings3() and if_width_level_settings()  

char cat_buffer[10] ;             // used to store the ft-891 response to a received control command (CAT) 

char noise_reduction_level_l  ;   // used by noise_reduction_level_settings and
char noise_reduction_level_2  ;   // by convert_reduction_level_bcd_format_to_decimal
bool noise_reduction_on = false ; // NR(DNR) is off at reset - used by read_rotary_encoder2_dnr1
                                  // and read_encoder2_switch function
byte digit_counter = 0 ;          // every time a valid key is entrered, this buffer is incremented
                                  // used by: main, detect_pound_key, detect_star_key, detect_C_key,
                                  // detect_B_key, detect_A_key and convert_freq_bcd_format_to_decimal_kc
                                  // char narrow_mode_settings  ;

byte freq1_bcd  = 0 ;             // valid digits are stored in bcd format in here prior to being coverted
byte freq2_bcd  = 0 ;             // to decimal
byte freq3_bcd  = 0 ;             // used by convert_ascii_bcd_format and by convert_freq_bcd_format_to_decimal_kc
byte freq4_bcd  = 0 ;             // function
byte freq5_bcd  = 0 ;

word decimal_conversion_result = 0 ; // digits are stored in BCD format then, they're converted again in decimal 



void setup() {

  // Setup  Rotary Encoder pins

  pinMode(CLK, INPUT);
  pinMode(DT,  INPUT);
  pinMode(SW,  INPUT_PULLUP);

  pinMode(CLK2,INPUT);
  pinMode(DT2, INPUT);
  pinMode(SW2, INPUT_PULLUP);

  pinMode(CLK3,INPUT);
  pinMode(DT3, INPUT);
  pinMode(SW3, INPUT_PULLUP);

  // Read the initial state of CLK a0-D14
  // Read the initial state of CLK2 a5-D19
  // Read the initial state of CLK3 D10

  lastStateCLK  = digitalRead(CLK);
  lastStateCLK2 = digitalRead(CLK2);
  lastStateCLK3 = digitalRead(CLK3);


  width_flag = true ;         // set current width setting to WIDE 
  width_on = false  ;         // set current width off 
  Serial.begin(9600);         // FT891 CAT baud rate
 
}

void loop() {

  read_encoder1_switch_pwr() ;          // read rotary encoder1 switch "POwER" function
  read_encoder2_switch_dnr() ;          // read rotary encoder2 switch "DNR"   function
  read_encoder3_switch_width() ;        // read rotary encoder3 switch "width" function
  read_rotary_encoder1_power();         // read rotary encoder1 "POWER" potentiometer position function
  read_rotary_encoder2_dnrl();          // read rotary encoder2 "DNR"   potentiometer position function
  read_rotary_encoder3_width() ;        // read rotary encoder3 "width" potentiometer position function


  key_pressed = kp1.getKey();           // getKey function scans the keypad every 10 ms. If the keypad is
  if (key_pressed) {                    // pressed, "getKey" returns a digit.

    digit_counter = digit_counter + 1 ; // buffer is incremented every time a key is pressed

    detect_pound_key();                 // '#' QMB recall handling function
    detect_star_key();                  // '*' Enter key  handling function
    detect_A_key();                     // 'A' Band+ key  handling function
    detect_B_key();                     // 'B' band- key  handling function
    detect_C_key();                     // 'C' Mode+ key  handling function
    detect_D_key();                     // 'D' Mode- key  handling function


    if (digit_counter == 1 ) digit1 = key_pressed ; // first digit entered is stored here
    if (digit_counter == 2 ) digit2 = key_pressed ; // second digit entered is stored here
    if (digit_counter == 3 ) digit3 = key_pressed ; // third digit entered is stored here
    if (digit_counter == 4 ) digit4 = key_pressed ; // fourth digit entered is stored here
    if (digit_counter == 5 ) digit5 = key_pressed ; // fifth digit entered (if any) is stored here

  } // if loop
}// main loop


void clear_digits()   // used to clear digit1- digit5 
{
  digit1 = 0xff;
  digit2 = 0xff;
  digit3 = 0xff;
  digit4 = 0xff;
  digit5 = 0xff;
}
void send_to_FT891()  // function used to send Control Commands to FT891 (through USB serial port)
                      // valid frequencies shall be between freq_lower_limit and freq_upper_limit
                      // frequencies are either 4 or 5 digit expressed in Kilo Hertz
                      // valid frequencies are stored in decimal format in "decimal_conversion_result"
                      // "Serial.print(decimal_conversion_result)" sends the conversion result to the RIG  
                      // frequecies below 10000Kc need a leading '0'
{

  if ((decimal_conversion_result >= freq_lower_limit  ) && (decimal_conversion_result <= freq_upper_limit ))
  {
    
      if (decimal_conversion_result >= 10000  ) 
      
      {                                                                         // above 10000 KC
        Serial.print("FA0");
        Serial.print(decimal_conversion_result);
        Serial.print("000;");
      }


      else
                                                                                // below 10000 KC

      {                                        
        Serial.print("FA00");
        Serial.print(decimal_conversion_result);
        Serial.print("000;");
      }
   }
}

void convert_ascii_digits_to_bcd_format() // function used to convert ascii digits to a bcd format
                                          // conversion is made by substracting 0x30 from the digit
{

  digit1 = digit1 - 0x30 ;   //   substract 0x30
  digit2 = digit2 - 0x30 ;   //   substract 0x30
  digit3 = digit3 - 0x30 ;   //   substract 0x30
  digit4 = digit4 - 0x30 ;   //   substract 0x30
  digit5 = digit5 - 0x30 ;   //   substract 0x30

  if ( digit5 == 0xcf ) digit5 = 0x00 ;   // empty buffer at reset = 0xff instead of a valid ascii number.
  if ( digit4 == 0xcf ) digit4 = 0x00 ;   // If subtracted by 0x30, 0xff becomes 0xcf
  if ( digit3 == 0xcf ) digit3 = 0x00 ;   // alls buffer containing 0xcf are converted to 0x00 then, buffers are sent to 
  if ( digit2 == 0xcf ) digit2 = 0x00 ;   // convert_freq_bcd_format_to_decimal_kc(), where conversion to decimal takes place
  if ( digit1 == 0xcf ) digit1 = 0x00 ;   // if a 1 digit, 2 digit or a 3 digit numer is entered, some buffers will equal 0
                                          // -last function e.g. send_to_FT891() validates if freq entered is a valid one or not 

  freq1_bcd = digit1 ;                    // when digit1 through digit5 are converted to bcd, the result of
  freq2_bcd = digit2 ;                    // conversion is placed in coresponding freqx_bcd buffers
  freq3_bcd = digit3 ;
  freq4_bcd = digit4 ;
  freq5_bcd = digit5 ;

}



void convert_freq_bcd_format_to_decimal_kc()  // function used to convert bcd digits to a decimal format
                                              // 4 digit frequency needs to be shifted/rotated 1 position 
                                              // to the right. prior to beeing converted,
                                              // 5 digit frequency dont need a rotation
{
  word buffer1 = 0;

  decimal_conversion_result = 0 ;

  if (digit_counter == 4 )                    // check if this is a 4 digit frequency 
  {
    freq5_bcd = freq4_bcd ;                   // if so, shift 1 x all digits to the right 
    freq4_bcd = freq3_bcd ;
    freq3_bcd = freq2_bcd ;
    freq2_bcd = freq1_bcd ;
    freq1_bcd = 0x00;
  }

if (digit_counter == 3 )                      // check if this is a 3 digit frequency 
  {
    freq5_bcd = freq3_bcd ;                   // if so, shift 2x all digits to the right 
    freq4_bcd = freq2_bcd ;
    freq3_bcd = freq1_bcd ;
    freq2_bcd = 0x00;
    freq1_bcd = 0x00;
  }

if (digit_counter == 2 )                      // check if this is a 2 digit frequency 
  {
    freq5_bcd = freq2_bcd ;                   // if so, shift 3x all digits to the right 
    freq4_bcd = freq1_bcd ;
    freq3_bcd = 0x00;
    freq2_bcd = 0x00;
    freq1_bcd = 0x00;
  }

if (digit_counter == 1 )                      // check if this is a 1 digit frequency 
  {
    freq5_bcd = freq1_bcd ;                   // if so, shift 4x all digits to the right 
    freq4_bcd = 0x00;
    freq3_bcd = 0x00;
    freq2_bcd = 0x00;
    freq1_bcd = 0x00;
  }

  // the conversion to decimal starts here

  if (freq1_bcd != 0 ) {
    buffer1 = freq1_bcd * 10000 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (freq2_bcd != 0 ) {
    buffer1 = freq2_bcd * 1000 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (freq3_bcd != 0 ) {
    buffer1 = freq3_bcd * 100 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (freq4_bcd != 0 ) {
    buffer1 = freq4_bcd * 10 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (freq5_bcd != 0 ) {
    buffer1 = freq5_bcd * 1 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  // at this point, the conversion is complete. decimal_conversion_result stores the freq in decimal 

}



void read_encoder1_switch_pwr()     // rotary encoder1 power-switch function
{

  // Read the button state
     btnState = digitalRead(SW);    

  // If we detect LOW signal, button is pressed
     if (btnState == LOW)
  {

    //  if 50ms have passed since last LOW pulse, it means that the
    //  button has been pressed, released and pressed again

    if (millis() - lastButtonPress > 50)
    {
      
 //------------------------User Program-------------------------
 
    qmb_save();   // save current VFOa to Quick memory bank 
    
 //------------------------User end-----------------------------
    
    }
 // Remember last button press event
    lastButtonPress = millis();
    }

 // Put in a slight delay to help debounce the reading
    delay(1); //  1 = 1MS
}  // main loop

void read_encoder2_switch_dnr()         // rotary encoder2 dnr-switch function
{

// Read the button state
   btnState2 = digitalRead(SW2);        

// If we detect LOW signal, button is pressed
   if (btnState2 == LOW)
   {

//  if 50ms have passed since last LOW pulse, it means that the
//  button has been pressed, released and pressed again

    if (millis() - lastButtonPress2 > 50)
    {

//---------------------------------------user Program--------------------------
      
   if ( noise_reduction_on == true )
   {
   Serial.print("NR00;");  // Turn Off noise reduction 
   noise_reduction_on = !noise_reduction_on ;  // invert noise_reduction_on state
   }
   else
   {
   Serial.print("NR01;");  // Turn On noise reduction
   noise_reduction_on = !noise_reduction_on ;  // invert noise_reduction_on state
   }
      
//---------------------------------------Use End-------------------------------

    }
// Remember last button press event
   lastButtonPress2 = millis();
   }

// Put in a slight delay to help debounce the reading
   delay(1); //  1 = 1MS for debouncing
} // main loop

void read_encoder3_switch_width()           // rotary encoder3 width switch function
{

  btnState3 = digitalRead(SW3);
  if (btnState3 == LOW)
  {
  if (millis() - lastButtonPress3 > 50)
  {
     
//---------------------------------------user Program----------------------
    
  if_width_level_settings();              // read width level and status 
                              
  if ( width_on == true )
  
   {
      
   Serial.print("SH0000;");               // Turn Off width - go back to default value which is '00' 
   width_on = !width_on ;                 // invert width_on state for next time around
   empty_serial_buffer();       
   }
   else 
   {
   
   Serial.print("SH01");                  // Turn On width   
   width_on = !width_on ;                 // invert width_on state for next time around
   Serial.print(ctrl_cmd_ft891_char4);    // retreive width level msd and send it back 
   Serial.print(ctrl_cmd_ft891_char5);    // retreive width level lsd and send it back 
   Serial.print(";");                     // control command terminator 
   empty_serial_buffer();    
   
   }

//---------------------------------------user End--------------------------
  }
  lastButtonPress3 = millis();
  }

  delay(1);     // Put in a slight delay to help debounce the reading
} // main loop


void read_rotary_encoder1_power()
{
  currentStateCLK = digitalRead(CLK);     // Read the current state of CLK

  if (currentStateCLK != lastStateCLK  && currentStateCLK == 1)

  {
  if (digitalRead(DT) != currentStateCLK) // If DT state is different than CLK state then, encoder is rotating CW
  {

  counter ++;                             // Encoder is rotating CW so increment
  currentDir = "CW";
  
//---------------------------------------user Program----------------------

  pc_power_level_settings3();             // Read FT-891 power level settings

  convert_power_bcd_format_to_decimal();  // convert ft891 power string to decimal

  decimal_conversion_result = decimal_conversion_result + 1 ;  // inc level by 1 

  if (decimal_conversion_result < 10 ) Serial.print("PC00");
  if ((decimal_conversion_result >= 10 ) && (decimal_conversion_result != 100 )) Serial.print("PC0");
  if (decimal_conversion_result >= 100 ) Serial.print("PC");

  Serial.print(decimal_conversion_result);
  Serial.print(";");
  //delay(5);  // no delay necessary with Hub4COM or with VSPE
  
//---------------------------------------user End--------------------------

  }

  else

  {
    
  counter --;                             // Encoder is rotating CCW so decrement
  currentDir = "CCW";
  
//---------------------------------------user Program----------------------

  pc_power_level_settings3();             // Read FT-891 power level settings

  convert_power_bcd_format_to_decimal();  // convert ft891 power string to decimal

  decimal_conversion_result = decimal_conversion_result - 1 ;  // dec level by 1 

  if (decimal_conversion_result < 10  ) Serial.print("PC00");
  if ((decimal_conversion_result >= 10 ) && (decimal_conversion_result != 100 )) Serial.print("PC0");
  if (decimal_conversion_result >= 100  ) Serial.print("PC");

  Serial.print(decimal_conversion_result);
  Serial.print(";");
  

  }

//---------------------------------------user End--------------------------

  }

//  Remember last CLK state
    lastStateCLK = currentStateCLK;
  
}

void read_rotary_encoder2_dnrl()
{

   currentStateCLK2 = digitalRead(CLK2);     // Read the current state of CLK2

// If last and current state of CLK are different, then pulse occurred
// React to only 1 state change to avoid double count

  if (currentStateCLK2 != lastStateCLK2  && currentStateCLK2 == 1)

  {
  if (digitalRead(DT2) != currentStateCLK2) // If DT state is different than CLK state then, encoder is rotating CW
  {

  counter2 ++;                              // Encoder is rotating CW so increment
  currentDir2 = "CW-2";

//---------------------------------------user Program----------------------

  noise_reduction_level_settings(); // read noise reduction level settings with "RL0"
  convert_reduction_level_bcd_format_to_decimal(); // convert settings to decimal

  decimal_conversion_result = decimal_conversion_result + 1 ;     // increase level by 1 

  if (decimal_conversion_result < 1 ) decimal_conversion_result = 1 ;    // anything below 1 is not allowed 
  if (decimal_conversion_result > 15 ) decimal_conversion_result = 15 ;  // anything above 15 is not allowed

  Serial.print("NR01;");  // turn on noise reduction  - while turning pot
  noise_reduction_on = true ;
  
  if (decimal_conversion_result <= 9  ) Serial.print("RL00");
  if (decimal_conversion_result >= 10 ) Serial.print("RL0");
  Serial.print(decimal_conversion_result);
  Serial.print(";");
  delay(15);     // delay 15 is ok with Hub4COM - delay 45 is ok with VSPE

//---------------------------------------user End--------------------------

  }

  else

  {
  
  counter2 --;                      // Encoder is rotating CCW so decrement
  currentDir2 = "CCW-2";
  
//---------------------------------------user Program----------------------


  noise_reduction_level_settings(); // read noise reduction level settings with "RL0"
  convert_reduction_level_bcd_format_to_decimal(); // convert settings to decimal

  decimal_conversion_result = decimal_conversion_result + 50  ;  // to avoid substracting 1 from zero, add 50

  decimal_conversion_result = decimal_conversion_result - 1 ;    // decrease noise level by 1 step

  if (decimal_conversion_result < 51 ) decimal_conversion_result = 51 ;  // allowed range is 01-15 e.g. 51-65
  if (decimal_conversion_result > 65 ) decimal_conversion_result = 65 ;  // anything below 51 or above 65 is not allowed

  decimal_conversion_result = decimal_conversion_result - 50  ;          // remove the extra 50 that was added

  Serial.print("NR01;");  // turn on noise reduction  - while turning pot
  noise_reduction_on = true ;
  if (decimal_conversion_result <= 9  ) Serial.print("RL00");
  if (decimal_conversion_result >= 10 ) Serial.print("RL0");
  Serial.print(decimal_conversion_result);
  Serial.print(";");
  delay(15);         //   delay(15);     // delay 15 is ok with Hub4COM - delay 45 is ok with VSPE

//---------------------------------------user End--------------------------

  }
  }

// Remember last CLK state
  lastStateCLK2 = currentStateCLK2;

}




void read_rotary_encoder3_width()
{
  currentStateCLK3 = digitalRead(CLK3);   // Read the current state of CLK3
  if (currentStateCLK3 != lastStateCLK3  && currentStateCLK3 == 1)
  {
  if (digitalRead(DT3) != currentStateCLK3) // If DT state is different than CLK3 state then, encoder is rotating CW
  {
 
  counter3 ++;                     // Encoder is rotating CW so increment
  currentDir3 = "Encoder 3 CW";

//---------------------------------------user Program----------------------

  read_narrow_wide_settings();
  read_mode_settings();
  if_width_level_settings();
  convert_width_bcd_format_to_decimal();

      if (( width_flag == WIDE   ) && (( mode_setting == SSB_U  ) || ( mode_setting == SSB_L ))) // ssb-usb or ssb-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 21 ) decimal_conversion_result = 21;
        if (decimal_conversion_result < 9 ) decimal_conversion_result = 9;
        if (decimal_conversion_result == 9 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == SSB_U ) || ( mode_setting == SSB_L )))   // ssb-usb or ssb-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 9 ) decimal_conversion_result = 9;
        Serial.print("SH010");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == WIDE   ) && (( mode_setting == CW_U  ) || ( mode_setting == CW_L ))) // cw-usb or cw-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 17 ) decimal_conversion_result = 17;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == CW_U ) || ( mode_setting == CW_L )))   // CW-usb or cw-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 10 ) decimal_conversion_result = 10;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

   
      if (( width_flag == WIDE   ) && (( mode_setting == RTTY_U  ) || ( mode_setting == RTTY_L ))) // rtty-usb or rtty-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 17 ) decimal_conversion_result = 17;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == RTTY_U ) || ( mode_setting == RTTY_L )))   // rtty-usb or rtty-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 10 ) decimal_conversion_result = 10;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == WIDE   ) && (( mode_setting == DATA_U  ) || ( mode_setting == DATA_L ))) // data-usb or data-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 17 ) decimal_conversion_result = 17;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == DATA_U ) || ( mode_setting == DATA_L )))   // data-usb or data-lsb
      {
        decimal_conversion_result = decimal_conversion_result + 1 ;
        if (decimal_conversion_result > 10 ) decimal_conversion_result = 10;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }
      
//---------------------------------------user End--------------------------

    }
    else
    {
      counter3 --;                      // Encoder is rotating CCW so decrement
      currentDir3 = "Encoder 3 CCW";
      
//---------------------------------------user Program----------------------

      read_narrow_wide_settings();
      read_mode_settings();
      if_width_level_settings();
      convert_width_bcd_format_to_decimal();

      
      if (( width_flag == WIDE  ) && (( mode_setting == SSB_U ) || ( mode_setting == SSB_L ))) // ssb-usb or ssb-lsb
      {

        decimal_conversion_result = decimal_conversion_result - 1 ;

        if (decimal_conversion_result > 21 ) decimal_conversion_result = 21;
        if (decimal_conversion_result < 9 ) decimal_conversion_result = 9;
        if (decimal_conversion_result == 9 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == SSB_U ) || ( mode_setting == SSB_L ))) // ssb-usb or ssb-lsb
      {
        if ( decimal_conversion_result == 1 ) decimal_conversion_result = 2 ;
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result > 9 ) decimal_conversion_result = 9;
        Serial.print("SH010");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == WIDE   ) && (( mode_setting == CW_U  ) || ( mode_setting == CW_L ))) // cw-usb or cw-lsb
      {
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == CW_U ) || ( mode_setting == CW_L )))   // CW-usb or cw-lsb
      {
        if (decimal_conversion_result == 1 ) decimal_conversion_result = 2;
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == WIDE   ) && (( mode_setting == RTTY_U  ) || ( mode_setting == RTTY_L ))) // rtty-usb or rtty-lsb
      {
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == RTTY_U ) || ( mode_setting == RTTY_L )))   // rtty-usb or rtty-lsb
      {
        if (decimal_conversion_result == 1 ) decimal_conversion_result = 2;
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == WIDE   ) && (( mode_setting == DATA_U  ) || ( mode_setting == DATA_L ))) // data-usb or data-lsb
      {
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
      }

      if (( width_flag == NARROW  ) && (( mode_setting == DATA_U ) || ( mode_setting == DATA_L )))   // data-usb or data-lsb
      {
        if (decimal_conversion_result == 1 ) decimal_conversion_result = 2;
        decimal_conversion_result = decimal_conversion_result - 1 ;
        if (decimal_conversion_result < 10 )  Serial.print("SH010");
        if (decimal_conversion_result >= 10 ) Serial.print("SH01");
        Serial.print(decimal_conversion_result);
        Serial.print(";");
        delay(5);  // delay 5 is ok with Hub4COM 
     }
     
//---------------------------------------user end----------------------
    }
    
  }

// Remember last CLK state
     lastStateCLK3 = currentStateCLK3;

}

void detect_star_key()                      // QMB recall
{
  
  if ( key_pressed == '*'  )                    
  {
 Serial.print("QR;");  // QMB recall 
 digit_counter = digit_counter - 1 ;
 empty_serial_buffer();        // empty serial buffer 
 
  }
}

void detect_pound_key()    //  Enter Key !! 
{
  if ( key_pressed == '#' ) 
  {
    digit_counter = digit_counter - 1 ;

    convert_ascii_digits_to_bcd_format();  // buffers digit1 to digit5 in ASCII format are converted to BCD format

    convert_freq_bcd_format_to_decimal_kc(); // the freq stored in BCD format is converted to decimal format

    send_to_FT891() ;       // the frequency stored in decimal format is sent to FT891 through the arduino serial com port 

    clear_digits();         // buffer digit1 to digit5 are cleared
    digit_counter = 0 ;     // digit counter is reset
  }
}



void convert_power_bcd_format_to_decimal()
{
  word buffer1 = 0;
  decimal_conversion_result = 0 ;

  ctrl_cmd_ft891_char2 = ctrl_cmd_ft891_char2 - 0x30 ; // to convert ascii to bin substract 0x30
  ctrl_cmd_ft891_char3 = ctrl_cmd_ft891_char3 - 0x30 ; // to convert ascii to bin substract 0x30
  ctrl_cmd_ft891_char4 = ctrl_cmd_ft891_char4 - 0x30 ; // to convert ascii to bin substract 0x30

  if (ctrl_cmd_ft891_char2 != 0 ) {
    buffer1 = ctrl_cmd_ft891_char2 * 100 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (ctrl_cmd_ft891_char3 != 0 ) {
    buffer1 = ctrl_cmd_ft891_char3 * 10 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (ctrl_cmd_ft891_char4 != 0 ) {
    buffer1 = ctrl_cmd_ft891_char4 * 1 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

}


void detect_A_key()     // Band+ Key !!
{

  if ( key_pressed == 'A'  )
  {

    FT891_band_select = FT891_band_select + 1 ;

    if ( FT891_band_select ==  10 ) FT891_band_select = 0 ; // default band0  = 1.8 mhz


     if (( FT891_band_select == 0 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS00;");                      // 160m band   1,8
    }
    if (( FT891_band_select == 1 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS01;");  // select 80m band  // 80m band   3,5
    }
    if (( FT891_band_select == 2 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS03;");  // select 40m band  //  40m band   7
    }
    if (( FT891_band_select == 3 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS04;");  // select 30m band  // 30m band 10,1
    }
    if (( FT891_band_select == 4 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS05;");  // select 20m band  // 20m band   14
    }
    if (( FT891_band_select == 5 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS06;");  // select 17m band  // 17m band  18,068
    }
    if (( FT891_band_select == 6 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS07;");  // select 15m band  // 15m band 21
    }
    if (( FT891_band_select == 7 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS08;");  // select 12m band  // 12m band   24,890
    }
    if (( FT891_band_select == 8 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS09;");  // select 10m band   10m band  28
    }
    if (( FT891_band_select == 9 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS10;");  // select 6m band   // 6m band  50
    }
    digit_counter = digit_counter - 1 ;

  }

}

void detect_B_key()          // Band- Key 
{

  if ( key_pressed == 'B'  )
  {

    FT891_band_select = FT891_band_select - 1 ;

    if ( FT891_band_select ==  255 ) FT891_band_select = 9 ; //


    if (( FT891_band_select == 0 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS00;");                      // 160m band   1,8
    }

    if (( FT891_band_select == 1 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS01;");  // select 80m band  // 80m band   3,5
    }
    if (( FT891_band_select == 2 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS03;");  // select 40m band  //  40m band   7
    }
    if (( FT891_band_select == 3 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS04;");  // select 30m band  // 30m band 10,1
    }
    if (( FT891_band_select == 4 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS05;");  // select 20m band  // 20m band   14
    }
    if (( FT891_band_select == 5 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS06;");  // select 17m band  // 17m band  18,068
    }
    if (( FT891_band_select == 6 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS07;");  // select 15m band  // 15m band 21
    }
    if (( FT891_band_select == 7 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS08;");  // select 12m band  // 12m band   24,890
    }
    if (( FT891_band_select == 8 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS09;");  // select 10m band   10m band  28
    }
    if (( FT891_band_select == 9 ) && ( digit_counter == 1 ))
    {
      Serial.print("BS10;");  // select 6m band   // 6m band  50
    }
    digit_counter = digit_counter - 1 ;
  }

}

void detect_C_key()         //  MODE+ Key !! 
{
  if ( key_pressed == 'C'  )                    //
  {
 
   
 FT891_mode_select = FT891_mode_select + 1 ;  // forward
 if ( FT891_mode_select ==  12) FT891_mode_select = 1 ; // default mode = lsb

 
    if (( FT891_mode_select == 1 ) && ( digit_counter == 1 )) Serial.print("MD01;EX11071;");  // SSB L
    if (( FT891_mode_select == 2 ) && ( digit_counter == 1 )) Serial.print("MD02;EX11070;");  // SSB U
    if (( FT891_mode_select == 3 ) && ( digit_counter == 1 )) Serial.print("MD05;");          // AM
    if (( FT891_mode_select == 4 ) && ( digit_counter == 1 )) Serial.print("MD04;");          // FM
    if (( FT891_mode_select == 5 ) && ( digit_counter == 1 )) Serial.print("MD03;EX07071;");  // CW L
    if (( FT891_mode_select == 6 ) && ( digit_counter == 1 )) Serial.print("MD07;EX07070;");  // CW U
    if (( FT891_mode_select == 7 ) && ( digit_counter == 1 )) Serial.print("MD06;EX10111;");  // RTTY L
    if (( FT891_mode_select == 8 ) && ( digit_counter == 1 )) Serial.print("MD09;EX10110;");  // RTTY U
    if (( FT891_mode_select == 9 ) && ( digit_counter == 1 )) Serial.print("MD08;EX08120;");  // DATA U
    if (( FT891_mode_select == 10) && ( digit_counter == 1 )) Serial.print("MD0C;EX08121;");  // DATA L
    if (( FT891_mode_select == 11) && ( digit_counter == 1 )) Serial.print("MD0B;");          // FM-N
    
    digit_counter = digit_counter - 1 ;
 
    
  }

}

void detect_D_key()           //  MODE- Key !! 
{
  if ( key_pressed == 'D'  )                    //
  {


 FT891_mode_select = FT891_mode_select - 1 ;  // backward
 if ( FT891_mode_select ==  0) FT891_mode_select = 11 ; // default mode = lsb


    if (( FT891_mode_select == 1 ) && ( digit_counter == 1 )) Serial.print("MD01;EX11071;");  // SSB L
    if (( FT891_mode_select == 2 ) && ( digit_counter == 1 )) Serial.print("MD02;EX11070;");  // SSB U
    if (( FT891_mode_select == 3 ) && ( digit_counter == 1 )) Serial.print("MD05;");          // AM
    if (( FT891_mode_select == 4 ) && ( digit_counter == 1 )) Serial.print("MD04;");          // FM
    if (( FT891_mode_select == 5 ) && ( digit_counter == 1 )) Serial.print("MD03;EX07071;");  // CW L
    if (( FT891_mode_select == 6 ) && ( digit_counter == 1 )) Serial.print("MD07;EX07070;");  // CW U
    if (( FT891_mode_select == 7 ) && ( digit_counter == 1 )) Serial.print("MD06;EX10111;");  // RTTY L
    if (( FT891_mode_select == 8 ) && ( digit_counter == 1 )) Serial.print("MD09;EX10110;");  // RTTY U
    if (( FT891_mode_select == 9 ) && ( digit_counter == 1 )) Serial.print("MD08;EX08120;");  // DATA U
    if (( FT891_mode_select == 10) && ( digit_counter == 1 )) Serial.print("MD0C;EX08121;");  // DATA L
    if (( FT891_mode_select == 11) && ( digit_counter == 1 )) Serial.print("MD0B;");          // FM-N
    

    digit_counter = digit_counter - 1 ;
   
  }

}



 void pc_power_level_settings3()   
 {
  byte i = 0 ; // local counter

  Serial.print("PC;");            // Read FT891 current power level
  i = 0 ;
  read_status_settings_n_save_to_cat_buffer();
  ctrl_cmd_ft891_char2 = cat_buffer[2];  // 
  ctrl_cmd_ft891_char3 = cat_buffer[3];  // 
  ctrl_cmd_ft891_char4 = cat_buffer[4];  // 
  ctrl_cmd_ft891_char5 = cat_buffer[5];  // 
  empty_serial_buffer();        // empty serial buffer
 }




void read_status_settings_n_save_to_cat_buffer()
{

  byte inchar ;
   
  word i = 0 ;
  char buffer1;
  
  while ( Serial.available() < 1  )  // stay here untill there is at 1 char in Arduino serial buffer
  {
  }
  while ( Serial.available() > 0 )  // loop until arduino serial buffer is empty

  {
    inchar = Serial.read();    // get char from Arduino serial buffer
    cat_buffer[i]= inchar ;    // store it in cat_eprom starting at location pointed by i 
    i++;                       // increase pointer by 1
    delay(5);                  // do no remove delay - it takes time to retreive a char from buffer 
                               // at 4800 a min delay is 3 ms needed. 
                               // at 9600 a min delay is 2 ms needed.    
                               // put 5 ms to be on the safe side 
  }




}

void noise_reduction_level_settings()
{
  byte i = 0;

  Serial.print("RL0;");  // read NR level control command
  i = 0 ;
  read_status_settings_n_save_to_cat_buffer();
  noise_reduction_level_l  = cat_buffer[3] - 0x30 ; // RL msd
  noise_reduction_level_2  = cat_buffer[4] - 0x30 ; // RL lsd
  empty_serial_buffer(); // empty serial buffer
}






void convert_reduction_level_bcd_format_to_decimal()   // convert noise reduction (NR) level to decimal

{
  word buffer1 = 0;
  decimal_conversion_result = 0 ;

  if (noise_reduction_level_l  != 0 ) {
    buffer1 = noise_reduction_level_l * 10 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (noise_reduction_level_2 != 0 ) {
    buffer1 = noise_reduction_level_2  * 1 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

}

void convert_width_bcd_format_to_decimal()
{
  word buffer1 = 0;
  decimal_conversion_result = 0 ;

  ctrl_cmd_ft891_char4 = ctrl_cmd_ft891_char4 - 0x30 ; // to convert ascii to bin substract 0x30
  ctrl_cmd_ft891_char5 = ctrl_cmd_ft891_char5 - 0x30 ; // to convert ascii to bin substract 0x30

  if (ctrl_cmd_ft891_char4 != 0 ) {
    buffer1 = ctrl_cmd_ft891_char4 * 10 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

  if (ctrl_cmd_ft891_char5 != 0 ) {
    buffer1 = ctrl_cmd_ft891_char5 * 1 ;
    decimal_conversion_result = decimal_conversion_result + buffer1 ;
    buffer1 = 0 ;
  }

}

void empty_serial_buffer()
{
  while (Serial.available() > 0); // empty buffer before leaving
  {
    char t = Serial.read();      // dummy read
  }
}


void read_narrow_wide_settings()
{
  word i = 0 ;
  char  buffer1 ;
  Serial.print("NA0;");  // read narrow control command
  i = 0 ;
  read_status_settings_n_save_to_cat_buffer();
  buffer1  = cat_buffer[3];  //
  if ( buffer1  == '1' ) width_flag = false ;
  if ( buffer1  == '0' ) width_flag = true ;
  empty_serial_buffer(); // empty serial buffer
}





void read_mode_settings()
{
  word i = 0 ;
  Serial.print("MD0;");  // read mode control command
  i = 0 ;
  read_status_settings_n_save_to_cat_buffer();
  mode_setting  = cat_buffer[3];  //
  empty_serial_buffer(); // empty serial buffer

}


void qmb_save()                              // QMB save
{
  Serial.print("QI;");                      
  empty_serial_buffer();        // empty serial buffer 
}

void if_width_level_settings()
{
  byte i = 0;
  char  buffer1 ; 
  
  Serial.print("SH0;");         // Read FT891 current if width level

  i = 0 ;
  read_status_settings_n_save_to_cat_buffer();
  ctrl_cmd_ft891_char3  = cat_buffer[3];   // if = '1' then width is on - if = '0' width is off 
  ctrl_cmd_ft891_char4  = cat_buffer[4];   // level msd 
  ctrl_cmd_ft891_char5  = cat_buffer[5];   // level lsd 
  buffer1 = ctrl_cmd_ft891_char3 ;          // check if if width is on or off
  if ( buffer1  == '0' ) width_on = false ;
  if ( buffer1  == '1' ) width_on = true ;
  empty_serial_buffer(); // empty serial buffer
}
