#!/bin/bash
echo "Running Installation Script"
echo "Installing Mosquitto Server"
echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

sudo apt-get update && apt-get upgrade
sudo apt install -y mosquitto mosquitto-clients
sudo systemctl enable mosquitto.service
mosquitto -v

fi

echo "Installing Java 17"
echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

sudo apt install openjdk-17-jdk -y
sudo export JAVA_HOME=/usr/lib/jvm/java-17-openjdk-arm64
sudo export PATH=$PATH:$JAVA_HOME/bin

fi


echo "Installing OpenHAB Repository Key"

echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

curl -fsSL "https://openhab.jfrog.io/artifactory/api/gpg/key/public" | gpg --dearmor > openhab.gpg

sudo mkdir /usr/share/keyrings

sudo mv openhab.gpg /usr/share/keyrings

sudo chmod u=rw,g=r,o=r /usr/share/keyrings/openhab.gpg

echo 'deb [signed-by=/usr/share/keyrings/openhab.gpg] https://openhab.jfrog.io/artifactory/openhab-linuxpkg stable main' | sudo tee /etc/apt/sources.list.d/openhab.list

echo "Updating system repository"

sudo apt-get update

fi

echo "installing OpenHAB"

echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

sudo apt-get install openhab

sudo apt-mark hold openhab
sudo apt-mark hold openhab-addons

echo "Starting OpenHAB services"

sudo systemctl start openhab.service
sudo systemctl status openhab.service

sudo systemctl daemon-reload
sudo systemctl enable openhab.service

echo "Openhab could take 15 minutes to start the first time..."

fi

cd ~
cd Install

echo "Moving configuration files to their proper location"
echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

sudo mv repeater.things /etc/openhab/things
sudo mv repeater.sitemap /etc/openhab/sitemaps
sudo mv repeater.items /etc/openhab/items
sudo mv repeater.rules /etc/openhab/rules
sudo mv addons.cfg /etc/openhab/services
sudo mv ntp.cfg /etc/openhab/services
sudo mv rrd4j.cfg /etc/openhab/persistence
sudo mv blinkatest.py ~
sudo mv MCNsensor.service /usr/lib/systemd/system
sudo mv sensorscript.py ~

fi

 
echo "Installing Paho MQTT Client"

echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

python3 -m venv ~/venv
source ~/venv/bin/activate 
pip3 install paho-mqtt

fi


echo "Installing PiGPIO DHT Interface"

echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

pip install pigpio-dht
sudo apt-get install pigpiod
sudo systemctl enable pigpiod
sudo systemctl start pigpiod

fi

echo "Installing CircuitPython"
echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

cd ~
pip3 install --upgrade adafruit-python-shell
wget https://raw.githubusercontent.com/adafruit/Raspberry-Pi-Installer-Scripts/master/raspi-blinka.py
sudo -E env PATH=$PATH python3 raspi-blinka.py

fi

echo "Testing...  You should see /dev/i2c-1 /dev/spidev0.0 /dev/spidev0.1"
ls /dev/i2c* /dev/spi*

python blinkatest.py

echo "Installing ADC Library"
echo "Continue [Y] or skip [N]?"
read string
if [ "$string" = "Y" ]; then

pip3 install adafruit-circuitpython-ads1x15

fi

cd ~
sudo chmod +x sensorscript.py

echo "Starting sensor polling service..."
sudo systemctl daemon-reload
sudo systemctl enable MCNsensor.service
sudo systemctl start MCNsensor.service

echo "Script completed.  Exiting now..."
