
#!/usr/bin/python

import paho.mqtt.client as mqtt
import math
import time
import board
import busio
import adafruit_ads1x15.ads1115 as ADS
from adafruit_ads1x15.analog_in import AnalogIn
from pigpio_dht import DHT11, DHT22

# Calibration curve slope and intercept values
v1_slope = 4.763
v1_intercept = -0.006
v2_slope = 4.792
v2_intercept = -0.014
v3_slope = 4.786
v3_intercept = 0.005
v4_slope = 4.649
v4_intercept = 0.027
tempprior = 70
humprior = 25
tempprior2 = 70
humprior2 = 25


# Create the I2C bus
i2c = busio.I2C(board.SCL, board.SDA)

# Create the ADC object using the I2C bus
ads = ADS.ADS1115(i2c)

# List the gpio pins for the DHT modules

gpio1 = 4
gpio2 = 23

sensor1 = DHT11(gpio1)
sensor2 = DHT11(gpio2)

try:

    mqttc = mqtt.Client(mqtt.CallbackAPIVersion.VERSION1)
    mqttc.connect("localhost",1883)

# Create differential input between channel 0 and 1
# chan = AnalogIn(ads, ADS.P0, ADS.P1)

# print("{:>5}\t{:>5}".format('raw', 'v'))

    while True :
#    print("{:>5}\t{:>5.3f}".format(vol1.value, vol1.voltage))
# Create single-ended input on channel 0
        v1 = AnalogIn(ads, ADS.P0)
        v2 = AnalogIn(ads, ADS.P1)
        v3 = AnalogIn(ads, ADS.P2)
        v4 = AnalogIn(ads, ADS.P3)
        vol1 = v1.voltage * v1_slope + v1_intercept
        vol2 = v2.voltage * v2_slope + v2_intercept
        vol3 = v3.voltage * v3_slope + v3_intercept
        vol4 = v4.voltage * v4_slope + v4_intercept
        mqttc.publish("voltage1", '{:4.2f}'.format(vol1), qos=0, retain=True )
        time.sleep(2)
        mqttc.publish("voltage2", '{:4.2f}'.format(vol2), qos=0, retain=True )
        time.sleep(2)
        mqttc.publish("voltage3", '{:4.2f}'.format(vol3), qos=0, retain=True )
        time.sleep(2)
        mqttc.publish("voltage4", '{:4.2f}'.format(vol4), qos=0, retain=True )
        time.sleep(2)
        result = sensor1.read()
        temp = result['temp_f']
        hum = result['humidity']
        if temp == 0 and hum == 0:
            temp = tempprior
            hum = humprior
        else:
            tempprior = temp
            humprior = hum
        mqttc.publish("maintemp", temp, qos=0, retain=True )
        mqttc.publish("mainhumidity", hum, qos=0, retain=True )
        result = sensor2.read()
        temp2 = result['temp_f']
        hum2 = result['humidity']
        if temp2 == 0 and hum2 == 0:
            temp2 = tempprior2
            hum2 = humprior2
        else:
            tempprior2 = temp2
            humprior2 = hum2
        mqttc.publish("subtemp", temp2, qos=0, retain=True )
        mqttc.publish("subhumidity", hum2, qos=0, retain=True )
        mqttc.loop()

except KeyboardInterrupt:
    mqttc.disconnect()
    s.cancel()

