/*  WB3JOB's Signal Generator    Audio to 40MHz
 *  Frequency generator using AD9851 DDS Module
 *  The following pins are used on the Arduino Nano
 *  Nano Pin    Description     IDE Pin     Use
 *  4           GND
 *  5           D2              2           
 *  6           D3              3           Amplifier Low Frequency Disable
 *  7           D4              4           AD9851 DATA Input
 *  8           D5              5           AD9851 W_CLK
 *  9           D6              6           AD9851 FQup Frequency Update
 *  10          D7              7           AD9851 RESET Input
 *  11          D8              8           Display D4
 *  12          D9              9           Display D5
 *  13          D10             10          Display D6
 *  14          D11             11          Display D7
 *  15          D12             12          Display Enable
 *  16          D13             13          Display Register Select
 *  17          3,3V                        Not Used
 *  18          A Ref                       Not Used
 *  19          A0              14          PB Tuning Step Increase
 *  20          A1              15          PB Tuning Step Decrease
 *  21          A3              16          PB Freqeuncy Increase
 *  22          A4              17          PB Frequency Decrease
 *  21-26       A5-A7                       Analog Inputs (not Used)
 *  27          +5V                         +5V I/O (Not Used)
 *  28          CPU Reset                   Not Used
 *  29          Gnd                         Ground
 *  30          Vin                         Power Input (11.1- 12V)
 */
 
//Declare the Variables
const int DATA = (4);           //DDS Pin for data
const int W_CLK = (5);          //DDS Word Clocking
const int FQ_UD = (6);          //DDS Frequency Update Pin
const int RESET = (7);          //DDS Reset
int Fup = (2);                  //Increase Frequency
int Fdwn = (3);                 //Decrease Frequency
const int en = (13);            //LCD Enable Pin
const int rs = (12);            //Register Select on LCD
#include <LiquidCrystal.h>      //Library for LCD Display
LiquidCrystal lcd(13,12,8,9,10,11);   //Setup LCD pins in lcd(en,rs,D4,D5,D6,D7) format
const long unsigned Fclk = 179995284;   //DDS Osc Freq (trim for accuracy)
int Units = (0);                //Units Counter
int Tens = (0);                 //Tens Counter
int Hund = (0);                 //Hundreds Counter
int Thou = (0);                 //Thousands Counter
int TenThou = (0);              //Ten Thousnad Counter
int HunThou = (0);              //Hundred Thousand Counter
int Mill = (0);                 //Millions Counter
int Tenmil = (1);               //Ten Million Counter
int PB;                         //Push Button Depressed
int Stepsz = (7);               //Counter for tuning step size
volatile byte dirRot = (0);
long unsigned F1 = (10000000);  //Starting Frequency
long unsigned int Temp1 = (1);  //Temporary registers used in sketch
long unsigned int F2 = (0);     //Temporary registers used in sketch
int Temp3 = (0);      //Temporary registers used in sketch
long unsigned Val1 = (1);
long unsigned x = (1);
volatile int y = (1);
volatile int z = (1);
const byte Control = (1);       //Control word for DDS
int DELAY=(150);

void setup() {
  lcd.begin(16,2);
  delay (10);
  pinMode (4, OUTPUT);          // DDS Data output
  pinMode (5, OUTPUT);          // DDS W_CLK
  pinMode (6, OUTPUT);          // DDS FQup
  pinMode (7, OUTPUT);          // DDS RESET
  pinMode (8, OUTPUT);          // Display DB4
  pinMode (9, OUTPUT);          // Display DB5
  pinMode (10, OUTPUT);         // Display DB6
  pinMode (11, OUTPUT);         // Display DB7
  pinMode (12, OUTPUT);         // Display Enable
  pinMode (13, OUTPUT);         // Display Register Select
  pinMode (19, INPUT);
  pinMode (20, INPUT);
  pinMode (21, INPUT);
  pinMode (22, INPUT);
  pinMode (2,INPUT); 
digitalWrite (2, HIGH);  
  pinMode (3, OUTPUT);          //Pin 3 Output to Amplifier (HIGH if under 1MHz)
  digitalWrite (6, LOW);
  pinMode (DATA, OUTPUT);             //Data pin on DDS
  pinMode (W_CLK, OUTPUT);            //W_CLK pin on DDS
  pinMode (FQ_UD, OUTPUT);            //Update pin on DDS
  pinMode (RESET, OUTPUT);            //RESET pin on DDS
  digitalWrite (RESET, LOW);          //Make sure DDS isn't reset
  delay (100);                        //Time to allow DDS and display to initialize
  //Reset the DDS first
  digitalWrite (RESET, HIGH);
  delay(20);
  digitalWrite(RESET, LOW);
  delay(10);
  //set-up the DDS before use with internal multiplier set to X6 and clock to 180000000 mHz
  F1= (((long unsigned)Units)+((long unsigned)10*(long unsigned)Tens)+((long unsigned)100*(long unsigned)Hund)+((long unsigned)1000*(long unsigned)Thou)+((long unsigned)10000*(long unsigned)TenThou)+(100000*HunThou)+((long unsigned)1000000*(long unsigned)Mill)+((long unsigned)10000000*(long unsigned)Tenmil));
  Temp1 = F1;
  Temp1 = (Temp1*4294967295/Fclk);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  Temp1 = (Temp1>>8);
  shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
  shiftOut(DATA, W_CLK, LSBFIRST, Control);
  digitalWrite (RESET, HIGH);
  delay(5);
  digitalWrite(RESET, LOW);
  digitalWrite(FQ_UD, HIGH);
  delay(2);
  digitalWrite(FQ_UD, LOW);
  delay(5);
}

void loop() {
  F1= (((long unsigned)Units)+((long unsigned)10*(long unsigned)Tens)+((long unsigned)100*(long unsigned)Hund)+((long unsigned)1000*(long unsigned)Thou)+((long unsigned)10000*(long unsigned)TenThou)+(100000*HunThou)+((long unsigned)1000000*(long unsigned)Mill)+((long unsigned)10000000*(long unsigned)Tenmil));
  if(F2 !=F1)
  {
    y=0;
    // Update the DDS First
    Temp1=(F1*4294967295/Fclk);
    shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
    Temp1=(Temp1>>8);
    shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
    Temp1=(Temp1>>8);
    shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
    Temp1=(Temp1>>8);
    shiftOut(DATA, W_CLK, LSBFIRST, Temp1);
    shiftOut(DATA, W_CLK, LSBFIRST, Control);
    digitalWrite (FQ_UD, HIGH);
    delay(5);
    digitalWrite (FQ_UD, LOW);
    F2=F1;
    // Now update the LCD display
    lcd.setCursor(0,0);
    lcd.print("Freq=");
    lcd.print(Tenmil);
    lcd.print(Mill);
    lcd.print(",");
    lcd.print(HunThou);
    lcd.print(TenThou);
    lcd.print(Thou);
    lcd.print(",");
    lcd.print(Hund);
    lcd.print(Tens);
    lcd.print(Units);
    lcd.setCursor(0,1);
    lcd.print("Step=");
    if (Stepsz== 8)
    {lcd.print("10,000,000");
    }
    if (Stepsz== 7)
    {lcd.print(" 1,000,000");
    }
    if (Stepsz==6)
    {lcd.print("   100,000");
    }
    if (Stepsz==5)
    {lcd.print("    10,000");
    }
    if (Stepsz==4)
    {lcd.print("     1,000");
    }
    if (Stepsz==3)
    {lcd.print("       100");
    }
    if (Stepsz==2)
    {lcd.print("        10");
    }
    if (Stepsz==1)
    {lcd.print("         1");
    }
  }
  //Check for a change in step size
  PB=(analogRead(14));
  if(PB<256)
    {Stepsz= (Stepsz+1);
    delay(DELAY);
    if(Stepsz>8)
      Stepsz=1;
      F2=1;
    }
  PB=(analogRead(15));
  if(PB<256)
    {Stepsz=(Stepsz-1);
    delay(DELAY);
    if(Stepsz<1)
      {Stepsz=8;
      }
    F2=1;
    }
  // Check for a change in the frequency
  Fup=(analogRead(16));
  if(Fup < 256)
  {
    if(Stepsz==(8))
   {
    Tenmil=(Tenmil+1);
   if(Tenmil>3)
      Tenmil=0;
   }
  if(Stepsz==(7))
    {
      Mill=(Mill+1);
    if(Mill>9)
     {
      Mill=0;
     Tenmil=(Tenmil+1);
     if(Tenmil>3)
     {
      Tenmil =0;
        }
      }  
    }
  if(Stepsz==(6))
    {
      HunThou =(HunThou+1);
      if(HunThou>9)
      {
        HunThou =0;
        Mill=(Mill+1);
        if(Mill>9)
        {
          Mill=0;
          Tenmil=(Tenmil+1);
          if(Tenmil>3)
          {
            Tenmil=0;
            }
         }
      }
    }
   if(Stepsz==(5))
   {TenThou=(TenThou+1);
   if(TenThou>9)
      {
        TenThou=0;
        HunThou=(HunThou+1);
        if(HunThou >9)
        {
          HunThou=0;
          Mill=(Mill+1);
          if(Mill>9)
            {
              Mill=0;
              Tenmil=(Tenmil+1);
              if(Tenmil>3)
              Tenmil=0;
            }
         }
      }
    }
    if(Stepsz==(4))
    {
      Thou=(Thou+1);
      if(Thou>9)
      {
       Thou=0;
       TenThou=(TenThou+1);
       if(TenThou>9)
       {
        TenThou=0;
        HunThou=(HunThou+1);
        if(HunThou>9)
        {
          HunThou=0;
          Mill=(Mill+1);
          if(Mill>9)
            {
              Mill=0;
              Tenmil=(Tenmil+1);
              if(Tenmil>3)
              {
                Tenmil=0;
              }
            }
          }
        }
      }
   }
   if(Stepsz==(3))
   {
    Hund=(Hund+1);
    if(Hund>9)
    {
      Hund=0;
      Thou=(Thou+1);
      if(Thou>9)
      {
        Thou=0;
        TenThou=(TenThou+1);
        if(TenThou>9)
        {
          TenThou=0;
          HunThou=(HunThou+1);
          if(HunThou>9)
          {
            HunThou=0;
            Mill=(Mill+1);
            if(Mill>9)
            {
              Mill=0;
              Tenmil=(Tenmil+1);
              if(Tenmil>3)
              {
                Tenmil=0;
              }
            }
          }
        }
      }
    }
   }
   if(Stepsz==(2))
   {
    Tens=(Tens+1);
    if(Tens>9)
    {
      Tens=0;       
      Hund=(Hund+1);
      if(Hund>9)
      {
        Hund=0;
        Thou=(Thou+1);
        if(Thou>9)
        {
         Thou=0; 
         TenThou=(TenThou+1);
         if(TenThou>9)
         {
          TenThou=0;
          HunThou=(HunThou+1);
          if(HunThou>9)
          {
            HunThou=0;
            Mill=(Mill+1);
            if(Mill>9);
            {
              Mill=0;
              Tenmil=(Tenmil+1);
              if(Tenmil>3)
              {
                Tenmil=0;
              }
            }
          }
         }
        }
      }
    }       
    }
    if(Stepsz==1)
    {
      Units=(Units+1);
      if(Units>9)
      {
        Units=0;
        Tens=(Tens+1);
        if(Tens>9)
        {
          Tens=0;
          Hund=(Hund+1);
          if(Hund>9)
          {
            Hund=0;
            Thou=(Thou+1);
            if(Thou>9)
            {
              Thou=0;
              TenThou=(TenThou+1);
                if(TenThou>9)
                {
                  TenThou=0;
                  HunThou=(HunThou+1);
                  if(HunThou>9)
                  {
                    HunThou=0;
                    Mill=(Mill+1);
                    if(Mill>9)
                    {
                      Mill=0;
                      Tenmil=(Tenmil+1);
                      if(Tenmil>3)
                      {
                        Tenmil=0;
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    F2=1;
    y=1;
    delay(DELAY);
  }

Fdwn=(analogRead(17));
if(Fdwn<256)
{
  if(Stepsz==(8))
  {
    Tenmil=(Tenmil-1);
    if(Tenmil<0)
    {
      Tenmil=3;
    }
  }
  if(Stepsz==(7))
  {
    Mill=(Mill-1);
    if(Mill<0)
    {
      Mill=9;
      Tenmil=(Tenmil-1);
      if(Tenmil<0)
      {
        Tenmil=3;
      }
    }
  }
  if(Stepsz==(6))
  {
    HunThou=(HunThou-1);
    if(HunThou<0)
    {
      HunThou=9;
      Mill=(Mill-1);
      if(Mill<0)
      {
        Mill=9;
        Tenmil=(Tenmil-1);
        if(Tenmil<0)
        {
          Tenmil=3;
        }
      }
    }
    }
    if(Stepsz==(5))
    {
      TenThou=(TenThou-1);
      if(TenThou<0)
      {
        TenThou=9;
        HunThou=(HunThou-1);
        if(HunThou<0)
        {
          HunThou=9;
          Mill=(Mill-1);
          {
            if(Mill<0)
            {
              Mill=9;
              Tenmil=(Tenmil-1);
              if(Tenmil<0)
              {
                Tenmil=3;
                
              }
            }
          }
        }
      }
    }
    if(Stepsz==(4))
    {
      Thou=(Thou-1);
      if(Thou<0)
      {
        Thou=9;
        TenThou=(TenThou-1);
        if(TenThou<0)
        {
          TenThou=9;
          HunThou=(HunThou-1);
          if(HunThou<0)
          {
            HunThou=9;
            Mill=(Mill-1);
            if(Mill<0)
            {
              Mill=9;
              Tenmil=(Tenmil-1);
              if(Tenmil<0)
              {
                Tenmil=3;
              }
            }
          }
         }
      }
    }
    if(Stepsz==(3))
    {
      Hund=(Hund-1);
      if(Hund<0)
      {
        Hund=9;
        Thou=(Thou-1);
        if(Thou<0)
        {
          Thou=9;
          TenThou=(TenThou-1);
          if(TenThou<0)
          {
            TenThou=9;
            HunThou=(HunThou-1);
            if(HunThou<0)
            {
              HunThou=9;
              Mill=(Mill-1);
              if(Mill<0)
              {
                Mill=9;
                Tenmil=(Tenmil-1);
                if(Tenmil<0)
                {
                  Tenmil=3;
                  
                }
              }
            }
          }
        }
      }
    }
  
  if(Stepsz==(2))
  {
    Tens=(Tens-1);
    if(Tens<0)
    {
      Tens=9;
      Hund=(Hund-1);
      if(Hund<0)
      {
        Hund=9;
        Thou=(Thou-1);
        if(Thou<0)
        {
          Thou=9;
          TenThou=(TenThou-1);
          if(TenThou<0)
          {
            TenThou=9;
            HunThou=(HunThou-1);
            if(HunThou<0)
            {
              HunThou=9;
              Mill=(Mill-1);
              if(Mill<0)
              {
                Mill=9;
                Tenmil=(Tenmil-1);
                if(Tenmil<0)
                {
                  Tenmil=3;
                }
              }
            }
          }
        }
      }
    }
  }
  if(Stepsz==(1))
  {
  Units=(Units-1);
  if(Units<0)
  {
    Units=9;
    Tens=(Tens-1);
    if(Tens<0)
    {
      Tens=9;
      Hund=(Hund-1);
      if(Hund<0)
      {
        Hund=9;
        Thou=(Thou-1);
        if(Thou<0)
        {
          Thou=9;
          TenThou=(TenThou-1);
          if(TenThou<0)
          {
            TenThou=9;
            HunThou=(HunThou-1);
            if(HunThou<0)
            {
              HunThou=9;
              Mill=(Mill-1);
              if(Mill<0)
              {
                Mill=9;
                Tenmil=(Tenmil-1);
                if(Tenmil<0)
                {
                  Tenmil=3 ;                 
                }
              }
            }
          }
        }
      }
    }
  }
}
delay(DELAY);
F2=1;
y=1;
}
Temp3 = (Mill + (10 * Tenmil));
if (Temp3 !=0)                   //If over 5MHz, turn on amplifier
{
  digitalWrite(3, LOW);
}
else (digitalWrite(3,HIGH));
}

  
  
