;----- QEX_LCD_PORT_2 ----------------------------------------------------------
; To be used with Texas Instruments MSP430G2553 microcontroller (MCU).
; To be used with the Newhaven NHD-0216K1Z 16x2 LCD Display.
; Can also use other displays that use the HD44780 or ST7066U driver chips.
; Texas Instruments Code Composer IDE used to program microcontroller.
; Pin connections for the LCD display and the microcontroller in QEX article.
;
; This program will provide the basic code for displaying characters on a LCD
; display. It is set up to display the letters "QEX" and the ASCII numbers for
; "QEX" are sent to the LCD display.

; 1 March 2021
; James Kretzschmar AE7AX

;-------------------------------------------------------------------------------
;----- STANDARD SET UP INFORMATION PROVIDED BY CODE COMPOSER TEMPLATE ----------
;-------------------------------------------------------------------------------
            .cdecls C,LIST,"msp430.h"       ; Include device header file
;-------------------------------------------------------------------------------
            .def    RESET                   ; Export program entry-point to
                                            ; make it known to linker.
;-------------------------------------------------------------------------------
            .text                           ; Assemble into program memory.
            .retain                         ; Override ELF conditional linking
                                            ; and retain current section.
            .retainrefs                     ; And retain any sections that have
                                            ; references to current section.
;-------------------------------------------------------------------------------
RESET       mov.w   #__STACK_END,SP         ; Initialize stackpointer
StopWDT     mov.w   #WDTPW|WDTHOLD,&WDTCTL  ; Stop watchdog timer

;-------------------------------------------------------------------------------
;----- SETS CPU CLOCK SPEED, SETS UP I/O PINS, ---------------------------------
;-------------------------------------------------------------------------------

START_HERE:
    mov.b   &CALBC1_16MHZ,&BCSCTL1  ; Setting CPU clock speed at 16 MHz
    mov.b   &CALDCO_16MHZ,&DCOCTL   ; Setting CPU clock speed at 16 MHz

	mov.b   #00000000b, &P1SEL      ; Port 1 pins selected as I/O pins
	mov.b   #00000000b, &P2SEL      ; Port 2 pins selected as I/O pins
	mov.b   #00110000b, &P1DIR      ; Pins P1.4 and P1.5 are OUTPUT pins
    mov.b   #11111111b, &P2DIR      ; Pins P2.0 - P2.7 are OUTPUT pins
	mov.b   #00000000b, &P1OUT      ; Pins P1.4 and P1.5 are initially LOW
	mov.b   #00000000b, &P2OUT      ; Pins P2.0 - P2.7 are initially LOW

;--------------------------------------------------------------------------------
;----- END OF SETTING UP CLOCK, I/O PINS, ---------------------------------------
;--------------------------------------------------------------------------------
;----- INITIALIZATION OF LCD     AFTER POWER ON ... A 50 MILLISECOND DELAY ------
;--------------------------------------------------------------------------------

    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_0:
	dec     R12
    jnz     DELAY_0
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_00:
	dec     R12
    jnz     DELAY_00
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_000:
	dec     R12
    jnz     DELAY_000
    mov     #65535, R12             ; 12.5 Millisecond Delay
DELAY_0000:
	dec     R12
    jnz     DELAY_0000

;--------------------------------------------------------------------------------
;----- END OF 50 MILLISECOND DELAY ----------------------------------------------
;--------------------------------------------------------------------------------
;
;----- (COMMAND: FIRST INITIALIZATION --- THEN 5 MILLISECOND DELAY) -------------
    mov.b	#00111000b, R13    ; 8-Bit, 2 Line mode
    call    #SETUP             ; Goto Routine To Load SETUP
    mov     #26215, R12        ; 5 Millisecond Delay
DELAY_1:
	dec     R12
	jnz     DELAY_1

;----- (COMMAND: SECOND INITIALIZATION --- THEN 100 MICROSECOND DELAY) ---------
    mov.b   #00111000b, R13    ; 8-Bit, 2 Line mode
	call    #SETUP             ; Goto Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_2:
	dec     R12
    jnz     DELAY_2
;
;----- (COMMAND: THIRD INITIALIZATION --- THEN 100 MICROSECOND DELAY) ----------
	mov.b   #00111000b, R13    ; 8-Bit, 2 Line mode
	call    #SETUP             ; Goto Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_3:
	dec     R12
    jnz     DELAY_3

;--------------------------------------------------------------------------------
;----- END OF INITIALIZATION OF LCD ---------------------------------------------
;--------------------------------------------------------------------------------
;----- SETUP OF LCD -------------------------------------------------------------
;--------------------------------------------------------------------------------

;----- (COMMAND: SELECTS 8-BIT, 2 LINE) -----------------------------------------
    mov.b   #00111000b, R13    ; 8-Bit, 2 Line
    call    #SETUP             ; Goto Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_4:
    dec     R12
    jnz     DELAY_4

;----- (COMMAND: CLEAR DISPLAY) -------------------------------------------------
    mov.b   #00000001b, R13    ; Clear Display (Clearing DDRAM takes long time)
    call    #SETUP             ; Goto Routine To Load SETUP
    mov     #26215, R12        ; 5 Millisecond Delay
DELAY_5:
    dec     R12
    jnz     DELAY_5

;----- (COMMAND: SETS DDRAM ADDRESS) --------------------------------------------
    mov.b   #10000111b, R13    ; DDRAM Address 07 selected. This can be changed
    call    #SETUP             ; Goto Routine to Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_6:
    dec     R12
    jnz     DELAY_6

;----- (COMMAND: DISPLAY CONTROL) -----------------------------------------------
    mov.b   #00001100b, R13    ; Display ON, Cursor OFF, Cursor Blinking OFF
    call    #SETUP             ; Goto Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_7:
    dec     R12
    jnz     DELAY_7

;----- (COMMAND: DISPLAY SHIFT/CURSOR MOVE (RIGHT OR LEFT) ----------------------
    mov.b   #00000110b, R13    ; Display Shift OFF, Next character to the Right
    call    #SETUP             ; Goto Routine To Load SETUP
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_8:
    dec     R12
    jnz     DELAY_8

;----- (COMMAND: CURSOR/DISPLAY SHIFT)(NOT IMPLEMENTED) -------------------------
    ;mov.b   #00010000b, R13   ; Cursor/Display Shift OFF, Shift Left
    ;call    #SETUP            ; Goto Routine To Load SETUP
    ;mov     #525, R12         ; 100 Microsecond Delay
;DELAY_9:
    ;dec     R12
    ;jnz     DELAY_9

;----- (COMMAND: CURSOR HOME)(NOT IMPLEMENTED) ----------------------------------
    ;mov.b   #00000010b, R13   ; Cursor Home (DDRAM address 00)
    ;call    #SETUP            ; Goto Routine To Load SETUP
    ;mov     #525, R12         ; 100 Microsecond Delay
;DELAY_10:
    ;dec     R12
    ;jnz     DELAY_10

    jmp     INPUT_DATA_FOR_LABEL ; Done with SETUP, goto INPUT_DATA_FOR LABEL

;--------------------------------------------------------------------------------
;----- SUBROUTINE THAT LOADS SETUP INFORMATION INTO LCD -------------------------
;--------------------------------------------------------------------------------

SETUP:
    mov.b   #00000000b, &P1OUT ; P1.4 (R/S) goes LOW (selects COMMAND MODE)
    mov     R13, R15           ; Loads contents of R13 into R15

    bis.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes HIGH
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_11:
    dec     R12
    jnz     DELAY_11

    mov.b   R15, &P2OUT        ; Data goes out on Port 2 D0-D7 lines

	bic.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes LOW
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_12:
    dec     R12
    jnz     DELAY_12

    ret                        ; Returns program to where it came from

;--------------------------------------------------------------------------------
;----- END OF SUBROUTINE THAT LOADS SETUP INFORMATION INTO LCD ------------------
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;----------------------- END OF SETUP OF LCD ------------------------------------
;--------------------------------------------------------------------------------

;--------------------------------------------------------------------------------
;----- THIS SECTION INPUTS DATA FOR LABEL ---------------------------------------
;--------------------------------------------------------------------------------

INPUT_DATA_FOR_LABEL:
    mov     #81, R4            ; Loads ASCII number for "Q"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #69, R4            ; Loads ASCII number for "E"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    mov     #88, R4            ; Loads ASCII number for "X"
    call    #SEND_ASCII_NUMBER_TO_LCD_DISPLAY

    jmp     END                ; Program ends

;------------------------------------------------------------------------------
;------- SUBROUTINE THAT SENDS ASCII NUMBER TO LCD DISPLAY --------------------
;------------------------------------------------------------------------------

SEND_ASCII_NUMBER_TO_LCD_DISPLAY:
    mov.b   #00010000b, &P1OUT ; P1.4 (R/S) goes HIGH = DATA MODE
    mov     R4, R15            ; Loads contents of R4 into R15

    bis.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes HIGH
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_13:
    dec     R12
    jnz     DELAY_13

    mov.b   R15, &P2OUT        ; Data goes out on Port 2 D0-D7

	bic.b   #00100000b, &P1OUT ; P1.5 (ENABLE) goes LOW
    mov     #525, R12          ; 100 Microsecond Delay
DELAY_14:
    dec     R12
    jnz     DELAY_14

    ret                        ; Returns program to where it came from

;-------------------------------------------------------------------------------
;----- END OF SUBROUTINE THAT SENDS ASCII NUMBER TO LCD DISPLAY ----------------
;-------------------------------------------------------------------------------

;-------------------------------------------------------------------------------
;----- AFTER ALL DATA HAS BEEN SENT TO THE LCD DISPLAY THE PROGRAM ENDS --------
;-------------------------------------------------------------------------------

END:
    jmp     END

;-------------------------------------------------------------------------------
; Stack Pointer definition
;-------------------------------------------------------------------------------
            .global __STACK_END
            .sect   .stack
;-------------------------------------------------------------------------------
; Interrupt Vectors
;-------------------------------------------------------------------------------
            .sect   ".reset"                ; MSP430 RESET Vector
            .short  RESET

            
