// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


//THIS IS THE ARDUINO SETUP ROUTINE

//===================================================================================================================

// START OF SETUP ===================================================================================================

//===================================================================================================================


void setup()
{
	//add or delete this line if audio hangs - it doesn't do anything because Serial hasn't been started yet
	//SerialOut("This is junk", true);
	//SerialOut("This is junk", true);
	//SerialOut("This is junk", true);

	sgtl5000_1.enable();
	sgtl5000_1.volume(0.0);
	sgtl5000_1.inputSelect(AUDIO_INPUT_LINEIN); //use left chan for radio line-out and right for mic line-out
	sgtl5000_1.lineOutLevel(29); //default output range is 29 - 1.29v
	sgtl5000_1.lineInLevel(5); //input range for left (linein) is 5, 1.33 v
	sgtl5000_1.audioPreProcessorEnable();
	//sgtl5000_1.audioPostProcessorEnable();
	//sgtl5000_1.audioProcessorDisable();

	sgtl5000_1.eqSelect(0); //disable tx equalizer to start


	sgtl5000_1.adcHighPassFilterDisable();
	//sgtl5000_1.adcHighPassFilterEnable();

	sgtl5000_1.dacVolume(0.0, 0.9); //default is 1.0 (no digital attenuation) - reducing this decreases the puttering noise that's present on low input levels - see Design Notes
							   //NOTE: Setting this below .9 adversely affects the USB Rx Level that can be sent to the radio

	Amp_Rec.gain(LEV_OFF); //amp for recording - gain set on Audio page

	//setting for audio stream through Teensy Audio board
	Sidetone.frequency(gFFTFreq);
	Sidetone.amplitude(LEV_OFF);

	RTTY_KEY.amplitude(LEV_OFF); //used to control rtty osc freq

	RTTY.frequency(2125.0); //mark freq
	RTTY.amplitude(LEV_OFF);

	Mixer_Rx.gain(0, LEV_MIXER_RX0); //Line-In from radio spkr
	Mixer_Rx.gain(1, LEV_MIXER_RX1); //sidetone input - KEY_OUT changes sidetone gain to turn tone on/of
	Mixer_Rx.gain(2, LEV_OFF); //future
	Mixer_Rx.gain(3, LEV_OFF); //future

	Mixer_Tx.gain(0, LEV_OFF); //mic input (from Line-In_right channel)	
	Mixer_Tx.gain(1, LEV_OFF); //USB Rx audio from PC
	Mixer_Tx.gain(2, LEV_OFF); //RTTY oscillator input
	Mixer_Tx.gain(3, LEV_OFF); //SD file output

	Filter_Rx.setBandpass(0, gFFTFreq, .7); //best attempt to try to bring lower freq back up after rolloff through transformers	
	Filter_Rx.setLowpass(1, float(gLPFltr * 100), .7); //adjusts with filter sliders on mode pages
	Filter_Rx.setNotch(2, float(gNFltr * 100), 2); //use two notch
	Filter_Rx.setNotch(3, float(gNFltr * 100), 2);
	Filter_Rx.update();

	//this isn't used to filter tx audio, the sgtl5000's parametric equalizer is used instead
	//this is just here to keep high freqs out of tx path
	Filter_Tx.setLowpass(0, 3200.0, .5);
	Filter_Tx.setLowpass(1, 3200.0, .5);
	Filter_Tx.update();
	//other filters for future

	Tone1.frequency(gFFTFreq, 8); //11 mS detect time @ 700 hz - switch to 2125 for RTTY Mark
	Tone2.frequency(2295.0, 10); //Default space tone for RTTY - >>> using LSB <<<

	//amps can be adjusted in the Levels page
	Amp_In.gain(LEV_UNITY);
	Amp_In.update();

	Amp_Mic_In.gain(LEV_UNITY);
	Amp_Mic_In.update();

	Amp_Out.gain(LEV_OFF); //Use gVolGain for headphone, gTxGain for line-out
	Amp_Out.update();

	Amp_USB_In.gain(LEV_UNITY);
	Amp_USB_In.update();

	Amp_USB_Out.gain(LEV_UNITY);
	Amp_USB_Out.update();

	//if - set to 0. - gain just inverts phase
	float g = gFFTGain + (gFFTLv - 50.0);
	if (g < 0)
	{
		g = LEV_OFF;
	}
	Amp_FFT.gain(g);
	Amp_FFT.update();

	//config pins
	//configure outputs first to minimize any key up during boot
	pinMode(PTT_OUT, OUTPUT);
	digitalWrite(PTT_OUT, HIGH);
	pinMode(KEY_OUT, OUTPUT);
	digitalWrite(KEY_OUT, HIGH);

	pinMode(PDL_RIGHT, INPUT_PULLUP);
	pinMode(PDL_LEFT, INPUT_PULLUP);

	pinMode(ROTARY_SW, INPUT_PULLUP);
	pinMode(ROTARY_A, INPUT_PULLUP);
	pinMode(ROTARY_B, INPUT_PULLUP);

	//set up RJ45 switch and radio ant switch i/o - these are set when we load the radio db then checked periodically for change with gRJ45_adrs
	//Set data lines for weak pullups  so we can read 2k2 to ground on pin if card is installed
	//we'll setup the data i/o pins when we check the boards or set the adrs
	pinMode(RJ_SW_STROBE, OUTPUT); //pull low to latch data values to decoder
	digitalWrite(RJ_SW_STROBE, LOW);
	pinMode(RJ_SW_INHIBIT, OUTPUT); //pull low to enable decoder output to drive select relay group
	digitalWrite(RJ_SW_INHIBIT, HIGH);

	//setup strobe for ant sw
	pinMode(ANT_SW_STROBE, OUTPUT); //pull low to latch adrs on ant relays
	digitalWrite(ANT_SW_STROBE, HIGH); //leave high after last write otherwise the last relay selected will remain active

	SetAntSwitch(true); //reset ant switch on startup

	Serial.begin(9600); //serial monitor - set to 9600 because this port is used by USB serial connections to other programs
	while (!Serial &&  millis() < 5000);
		
	HMI.begin(115200); //hmi
	HMIR.begin(115200); //remote display port - check it first to see if it's alive

	RADIO.begin(19200); //radio
		
	//wait for start msg and size from hmi			
	hmiPage = HMI_HOME; //so decoder works
	int i = 0;
	int ctr = 0; //try HMIR for 4 seconds then try HMI
	hmiRmt = true; //start with remote hmi - if it's there use it, otherwise try local. If it's not there, fail.

	i = 0;
	while (hmiInitialized == false)
	{
		if (i == 0)
		{
			hmiWait4Reply = false;
			Tx2HMI("sleep=0"); //make sure it's awake
			while (ISRActive)
			{
				//wait for ISR to clear
			}
			delay(100);
			hmiWait4Reply = HMI_RESET;
			Tx2HMI("rest"); //reset display until it replies			
		}
		i++;
		if (i > 500)
		{
			i = 0; //poll again if no reply in 1/2 seconds
			ctr++;
			if (ctr > 1)
			{
				hmiRmt = !hmiRmt; //try the other one for 4 seconds
				ctr = 0;
				SerialOut("hmiRmt= " + String(hmiRmt) + " - trying the other display", true);
			}
		}
		delay(1);
	}

	delay(1500); //let screen boot
	while (gSize == 0)
	{
		//gSize and gRadioSel are sent from S page every 500 mSec until we update gWDog=1
		delay(400);
		ChkHmiRx();
		if (gSize == 35 || gSize == 50)
		{
			break;
		}
	}
	Tx2HMI("gWDog=1"); //this will switch us to Home page and start normal processing
	Tx2HMI("gWDog=1");
	
	if (gSize == 50)
	{
		fftID = String(HMI_FFT50);
		hmi_rxM_len = 47; //change to more chars for larger display
		hmi_bRx_max = 47;
	}
	else
	{
		fftID = String(HMI_FFT35);
	}
		
	delay(500);

	Tx2HMI("page Home"); //send to home page
	Tx2HMI("page Home");

	ShowInitializing();

	delay(500);

	SPI.setMOSI(SPI_MOSI_PIN);
	SPI.setMISO(SPI_MISO_PIN);
	SPI.setSCK(SPI_SCK_PIN);
	//Use this for Teensy 4.0 with the SD card on the audio board
	
	//SD_CS is determined from processor used
	//Old SD code: if (!SD.begin(SD_CS)) 
	//7/13/21
	if (!SD.sdfs.begin(SdioConfig(DMA_SDIO))) //new SDFat code - this should allow SD card to run faster
	{
		while (1) {
			//SerialOut("SD card failed", true);
			delay(500);

			hmiPage = HMI_HOME;//so Tx2HMI works
			delay(100);
			hmiWait4Reply = 0;
			Tx2HMI("bTx.txt=`   !!! SD CARD FAILURE !!!`");
			delay(100);
			Tx2HMI("bRx.txt=`Replace SD card with a good card  `");
			delay(1000);
		}
	}

	//SerialOut("SD card initialized", true);

	//read value from vox detector to clear it otherwise first call to ChkVox() will key tx
	if (Vox_Det.available())
	{
		Vox_Det.read(); // just burn it, was *10000;		
	}

	//download gRadioSel from HMI EEProm to get gRadioSel then load radio from SD card

	hmiPage = HMI_HOME; //so we can rx this reply

	//initialize ESP at start - if we don't do this we get digital noise in the Line-In circuits
	Tx2HMI("Home.bRx.txt=`Initializing ESP8266  `");
	ESP.begin(115200);	
	WiFi.init(ESP);
	if (WiFi.status() == WL_NO_MODULE)
	{
		Tx2HMI("Home.bRx.txt=`ESP8266 not installed  `");
	}
	else
	{
		WiFi.disconnect();
		WiFi.setPersistent();
		WiFi.endAP();
	}	

	Chk4Folders(); //chk for folders before getting files, if they don't exist, create them
	LoadRadioTags(); //fill radioTag[] array to start
	
	if (gRadioSel > 0x0f)
	{
		gRadioSel = 0; //start with radio 1 in case we didn't get it from the HMI
	}
	sgtl5000_1.volume(0.8);
	LoadRadio();	
	Chk4LogFiles();	
	LoadTxtLog(); //get current list

	//IRQ SETTINGS ====================================================================

	//start decoder timer inturrupt and set priority
	//NOTE: Timer prioirties are on 16 count boundry
	decoderUpdateTmr.begin(ISR_ChkDecoder, ISR_Interval); //call ISR_ChkDecoder every 3 mSec, 1 mSec was causing audio lockups??
	decoderUpdateTmr.priority(160);

	recordUpdateTmr.begin(ISR_ChkRecord, 200); //update recorder every .2 mS if AUDIO_RECORD
	recordUpdateTmr.priority(144);

	//set up keyboard
	myUsb.begin();
	keyboard1.attachPress(KeyboardPress_ISR); //normal keyboard keys
	keyboard2.attachPress(KeyboardPress_ISR);

	//IRQ SETTINGS END ================================================================	
		
	Chk4DisclaimerFile();
	if (hmiReadDisclaimer == false)
	{
		Tx2HMI("Help.pg.val=" + String(HELP_DISCLAIMERPG - 1)); //show first page of disclaimer in help
		Tx2HMI("Help.pg.val=" + String(HELP_DISCLAIMERPG - 1));
		Tx2HMI("page Help");
		Tx2HMI("page Help");
		Tx2HMI("vis b0,0"); //hide back & dec buttons until second page is read
		Tx2HMI("vis b0,0");
		Tx2HMI("vis bDec,0");
		Tx2HMI("vis bDec,0");				
	}

	//Setup memory for SGTL5000 - AudioMemoryUsageMax() shows 22 max connections
	AudioMemory(uint(50));
	
	SerialOut("Setup completed", true);	
	hmiPagePrev = hmiPage;
	blockHMI = millis() + 1000; //allow hmi to process changes before allowing TxInfo poll processing otherwise we get a race condition
}

// END OF SETUP =============================================================================================================

