// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================



//========================================================================================================
//
// WiFi Server Code
//
//========================================================================================================


void BuildSvrReply(int msgNum, String & txt)
{
	//create message # for server and return with it in txt
	switch (msgNum)
	{
	case 0: //basic server reply
		//txt = "HTTP/1.1 200 OK\r\n";
		//txt += "Content-Type: text/html\r\n";
		//txt += "Connection: close\r\n";  // the connection will be closed after completion of the response					
		//txt += "Refresh: 10\r\n";  // refresh the page automatically every 10 sec					
		//txt += "\r\n";
		//txt += "<!DOCTYPE HTML>\r\n";
		//txt += "<meta charset=\"UTF-8\">\r\n";			
		//txt += "<html>\r\n"; //page info here					
		//txt += "<body>\r\n";

		HTML_Head(1, txt);
		txt += "<p><br>Click the [Download Log] to save the CTR2_LOG.ADI file to your Download folder.</p>";
		txt += "<p>Once downloaded, delete everything except the text between the lines and save it again to produce ";
		txt += "an ADIF encoded file that can be imported into your logging program or submitted online.</p>";
		//txt += "<a href=\"/LOG/CTR2_LOG.ADI\" download>Download Log</a>"; 
		txt += "</p><br></body><br>";
		txt += "</html>\r\n";
		break;
	case 1:
		//download log ADI file
		txt = DownloadADILog();
		break;
	}

}

void HTML_Head(int mode, String & txt)
{
	txt += "<!DOCTYPE html>";
	txt += "<html lang = \"en\">";
	txt += "  <head>";
	txt += "    <meta charset=\"UTF - 8\" />";
	txt += "    <meta name=\"viewport\" content=\"width = device - width, initial - scale = 1.0\" />";
	txt += "    <meta http-equiv=\"X - UA - Compatible\" content=\"ie = edge\" />";
	txt += "    <title>CTR2 Radio Server</title>";
	txt += "    <style>";
	txt += "      html {";
	txt += "        font-family: Helvetica;";
	txt += "        display: inline-block;";
	txt += "        margin: 0px auto;";
	txt += "        text-align: left;";
	txt += "      }";
	txt += "      body {";
	txt += "        margin-top: 50px;";
	txt += "        background: #f3f3f3;";
	txt += "      }";
	txt += "      h1 {";
	txt += "        color: #444444;";
	txt += "        margin: 10px auto 10px;";
	txt += "      }";
	txt += "      h2 {";
	txt += "        font-size: 24px; ";
	txt += "        color: #444444;";
	txt += "        margin: 10px auto 10px;";
	txt += "      }";
	txt += "      h3 {";
	txt += "        color: #444444;";
	txt += "        margin-bottom: 50px;";
	txt += "      }";
	txt += "      h3.help {";
	txt += "        margin-bottom: 8px;";
	txt += "      }";
	txt += "      h4 {";
	txt += "        font-size: 16px;";
	txt += "        margin: 10px 0 10px 0;";
	txt += "      }";
	txt += "      span.red {";
	txt += "        color: red;";
	txt += "        font-variant-caps: small-caps;";
	txt += "        }";
	txt += "      span.orange{";
	txt += "        color: orange;";
	txt += "        font-variant-caps: small-caps;";
	txt += "        }";
	txt += "      span.capsred {";
	txt += "        font-variant-caps: small-caps;";
	txt += "        font-size: 16px;";
	txt += "        color: red;";
	txt += "      }";
	txt += "      .button {";
	txt += "        display: inline-block;";
	txt += "        width: 200px;";
	txt += "        text-align: center;";
	txt += "        background-color: #3498db;";
	txt += "        border: none;";
	txt += "        color: white;";
	txt += "        padding: 10px 4px;";
	txt += "        text-decoration: none;";
	txt += "        font-size: 18px;";
	txt += "        margin: 0px auto 35px;";
	txt += "        cursor: pointer;";
	txt += "        border-radius: 4px;";
	txt += "      }";
	txt += "      .button.currentpage {";
	txt += "        background-color: #165f91;";
	txt += "      }";
	txt += "      .button.button-on.warn {";
	txt += "        background-color: rgba(245, 127, 127, 1);";
	txt += "      }";
	txt += "      .button-on:active {";
	txt += "        background-color: #f88e03;";
	txt += "      }";
	txt += "      p {";
	txt += "        font-family: 'Courier New', Courier, monospace;";
	txt += "        font-size: 16px;";
	txt += "        color: #444444;";
	txt += "        margin-bottom: 10px;";
	txt += "      }";
	txt += "      p.help {";
	txt += "        font-family: Arial, Helvetica, sans-serif;";
	txt += "      }";
	txt += "      div#footer {";
	txt += "        text-align: center;";
	txt += "        font-size: 14px;";
	txt += "      }";
	txt += "    </style>";
	txt += "  </head>";
	txt += "  <body>";

	switch (mode)
	{
	case 1:
		txt += "<h1>CTR2 Radio Server</h1>";
		txt += "    <a class=\"button button-on\" href=\"/\">Refresh</a>";
		txt += "    <a class=\"button button-on\"<a href=\"/LOG/CTR2_LOG.ADI\" download>Download Log</a>";
		//txt += "    <a class=\"button button-on  currentpage\" href=\"/listLog\">Event Log</a><br>";   // use currentpage to change button to dark blue if needed
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		//txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		//txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		//txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		txt += "<pre>"; //so we maintain white space
		txt += "<p><h2> Radio Name: " + radioTag[gRadioSel].trim() + "</h2></p>";
		txt += "<p><h2> Radio Port: " + String(gRadioSel + 1) + "</h2></p>";
		txt += "<p><h2>  Frequency: " + String(gFreqRadio) + "</h2></p>";
		txt += "<p><h2> Radio Mode: " + Dec_gRMode() + "</h2></p>";
		txt += "<p><h2>    Op Mode: " + Dec_gOMode() + "</h2></p>";
		txt += "</pre>";
		break;
	case 2:
		txt += "<h1> Alarms Report</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on currentpage\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	case 3:
		txt += "<h1> Event Log Report</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on currentpage \" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	case 4:
		txt += "<h1> Help</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on currentpage\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	case 5:
		txt += "<h1> Create New Map?</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on currentpage\" href=\"/verifyMap\">Verify<br>New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	case 7:
		txt += "<h1> Erase Log?</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on currentpage\" href=\"/verifyErase\">Verify<br>Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	case 9:
		txt += "<h1>Disable Access Point?</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on currentpage\" href=\"/verifyAPOff\">Verify<br>Disable AP</a>";
		break;
	default:
		txt += "<h1> Network Reports</h1>";
		txt += "    <a class=\"button button-on\" href=\"/systemReport\">System</a>";
		txt += "    <a class=\"button button-on\" href=\"/listAlarms\">Alarms</a>";
		txt += "    <a class=\"button button-on\" href=\"/listLog\">Event Log</a><br>";
		txt += "    <a class=\"button button-on\" href=\"/help\">Help</a>";
		txt += "    <a class=\"button button-on\" href=\"/newMap\">New Map</a>";
		txt += "    <a class=\"button button-on\" href=\"/eraseLog\">Erase Log</a>";
		txt += "    <a class=\"button button-on\" href=\"/apOff\">Disable AP</a>";
		break;
	}
	txt += "<br>";
}

void html_Home(String & ptr)
{
	ptr += "<strong>Select an option from the menu</strong><br><br>";
	ptr += "<strong>System</strong> displays a System Report of the network<br>";
	ptr += "<strong>*Note: </strong>The System Report may take some time to create<br><br>";
	ptr += "<strong>Alarms</strong> displays the active alarms on the system<br><br>";
	ptr += "<strong>Event Log</strong> displays the historical Event Log<br><br>";
	ptr += "<strong>Help</strong> displays helpful information about HL-HMI<br><br>";
	ptr += "<strong>New Map</strong> creates a new map of the network and runs the System Report<br><br>";
	ptr += "<strong>Erase Log</strong> erases the current Event Log entries<br><br>";
	ptr += "<strong>Disable AP</strong> disables the HL-HMI access point and closes this session<br>";
}


