// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


//===================================================================================================================
// PCR1000 routines
//===================================================================================================================


uint8_t PCR_Ping()
{
	//request pcr status - if power button is on, return true
	String reply = "";
	reply = Tx2PCR1000("H1?");	
	if (reply == "H100")
	{
		gPCRInit = false; //start over
		Tx2HMI("PCR.gPwrSw.val=1"); //allow btTxMode to show color
		Tx2HMI("PCR.gPwrBtn.val=0");
		return 1;
	}
	else if (reply == "H101")
	{
		Tx2HMI("PCR.gPwrSw.val=1"); //allow btTxMode to show color
		Tx2HMI("PCR.gPwrBtn.val=1");
		return 2;
	}
	Tx2HMI("PCR.gPwrSw.val=0"); //show btTxMode as gray
	Tx2HMI("PCR.gPwrBtn.val=0");
	return 0;
}

void PCR_Initialize()
{
	//initialize PCR1000
	//we just turned on PCR1000, intialize it as described in http://www.thornett.net/Rosliston_Archive_2009-11/ICOM_PCR-1000_Command_Protocol_accessed_July_2011.pdf
	String reply = "";

	//SerialOut("Initalizing PCR1000", true);
	PCR_Update(2); //set squelch
	reply = Tx2PCR1000("G300"); //autoupdate off
	reply = Tx2PCR1000("J5100");//disable tone sq
	reply = Tx2PCR1000("J5000"); //disable VSC	
	reply = Tx2PCR1000("GD?"); //chk to see if DSP board is installed
	if (reply == "GD01")
	{
		//DSP, turn on those controls
		Tx2HMI("PCR.gHasDSP.val=1");
		Tx2HMI("PCR.gHasDSP.val=1");
	}
	PCR_Update(3); //set IF shift
	PCR_Update(0xff); //set on/off controls
	PCR_Update(4); //set DSP
	PCR_Update(1); //set volume	
	gPCRInit = true;
	TxFreq2Radio(gFreqRadio);
	delay(50);
}

void Dec_gPCRStat()
{
	//decode the PCR status
	gPRCPwrBtn = gPCRStat & 0x01;
	gPCRAGC = (gPCRStat & 0x02) >> 1;
	gPCRAtten = (gPCRStat & 0x04) >> 2;
	gPCRNBlank = (gPCRStat & 0x08) >> 3;
	gPCRDSP = (gPCRStat & 0x10) >> 4;
	gPCRANch = (gPCRStat & 0x20) >> 5;
	gPCRBW = (gPCRStat & 0x0f00) >> 8;
}

void Dec_gPCRCtrl()
{
	//break out PCR ctrl values in gPCRCtrl if we don't have a pending encoder action
	if (gPCREncoderChng == 0)
	{
		gPCRVol = gPCRCtrl & 0xff;
		gPCRSq = (gPCRCtrl & 0xff00) >> 8;
		gPCRIF = (gPCRCtrl & 0xff0000) >> 16;
		gPCRDSPNR = (gPCRCtrl & 0xff000000) >> 24;
	}
}

void PCR_Update(uint8_t type)
{
	//send new values to the PCR1000 rx based on type	
	String cmd = "";
	String temp = "";
	String reply = "";

	switch (type)
	{
	case 0: //power update
		//chk power first. If it changes, just change it and return
		if (gPRCPwrBtn == false)
		{
			//turn it off
			reply = Tx2PCR1000("H100");
			if (reply != "G000")
			{
				//	gPRCPwrBtn = true; //reset so next update from hmi sends this command again
			}
			//SerialOut("Turning PCR1000 OFF", true);
		}
		else
		{
			//power now on, initialize radio
			reply = Tx2PCR1000("H101");
			if (reply != "G000")
			{
				//	gPRCPwrBtn = false; 
			}
		}
		return;
		break;
	case 1: //update volume				
		cmd = String(gPCRVol, HEX);

		if (cmd.length() == 1)
		{
			cmd = "0" + cmd; //add a leading 0
		}
		cmd = "J40" + cmd;
		//SerialOut("PCR Vol cmd= " + cmd, true);
		reply = Tx2PCR1000(cmd);
		gPCRVolPrev = gPCRVol;
		break;
	case 2: //update squelch
		cmd = String(gPCRSq, HEX);
		cmd = String(gPCRSq, HEX);
		if (cmd.length() == 1)
		{
			cmd = "0" + cmd; //add a leading 0
		}
		cmd = "J41" + cmd;
		//SerialOut("PCR Sq cmd= " + cmd, true);
		reply = Tx2PCR1000(cmd);
		gPCRSqPrev = gPCRSq;
		break;
	case 3: //update IF shift
		cmd = String(gPCRIF, HEX);
		if (cmd.length() == 1)
		{
			cmd = "0" + cmd; //add a leading 0
		}
		cmd = "J43" + cmd;
		//SerialOut("PCR IF cmd= " + cmd, true);
		reply = Tx2PCR1000(cmd);
		gPCRIFPrev = gPCRIF;
		break;
	case 4: //update DSP noise reduction level		
		if (gPCRDSP == 0)
		{
			temp = "0"; //turn off noise reduction
		}
		else
		{
			//valid level 1 to 15
			temp = String(gPCRDSPNR, HEX);
			temp.toUpperCase();
		}

		reply = Tx2PCR1000("J8001");
		reply = Tx2PCR1000("J810" + String(gPCRDSP));
		reply = Tx2PCR1000("J820" + temp);
		reply = Tx2PCR1000("J830" + String(gPCRANch));
		gPCRDSPNRPrev = gPCRDSPNR;
		break;
	default:
		//something else changed beside power, updated all of the boolean controls
		//SerialOut("Updating ctrls - gPCRStat=" + String(gPCRStat, HEX), true);
		reply = Tx2PCR1000("J450" + String(gPCRAGC));
		reply = Tx2PCR1000("J470" + String(gPCRAtten));
		reply = Tx2PCR1000("J460" + String(gPCRNBlank));
		break;
	}
}

String Tx2PCR1000(String cmd)
{
	//add cr + lf to cmd, convert string to msg[] and tx it to PCR1000
	//return with reply 	
	bool autoMode = false;

	if ((cmd.charAt(0) == 'J' && cmd.charAt(1) == '8' && cmd.charAt(2) == '0') || (cmd == "G301"))
	{
		//SerialOut("Auto update on", true);
		autoMode = true; //don't append lf/cr or wait for reply
	}

	//clear rx buffer before tx
	int ctr = 0;
	String chr = "";
	while (RADIO.available())
	{
		//SerialOut("Clearing PCR junk", true);
		chr += char(RADIO.read());
		ctr++;
		//SerialOut(String(chr), false); //do something with it for compiler
	}
	if (ctr > 0)
	{
		//SerialOut("Junk= " + chr, true);
	}

	byte msg[25];

	//don't add cr/lf for auto mode turn on - it won't reply
	//if (autoMode == false)
	{
		cmd = cmd + char(13) + char(10);
	}
	cmd.toUpperCase();

	uint8_t num = cmd.length();
	//SerialOut("-->Tx: " + cmd, false);
	for (int i = 0; i < num; i++)
	{
		msg[i] = cmd.charAt(i);
	}
	RADIO.write(msg, num);
	RADIO.flush();
	if (autoMode == false)
	{
		return ChkPCR1000Rx(0);
	}
	else
	{
		return " "; //must return with something or audio locks up
	}

}

String ChkPCR1000Rx(uint8_t numChr)
{
	//wait for PCR1000 to reply, return with reply
	//if numChr > 0, return when that # has been rx
	//if numChr = 0, return when LF has been rx
	uint32_t startTime = millis();
	uint32_t waitTime = 750; //wait up to 3/4 second for reply to start
	char chr = 0;
	String msg = "";
	int ctr = 0;

	while (millis() - startTime < waitTime)
	{
		if (RADIO.available())
		{
			chr = RADIO.read();
			if (chr != 13 && chr != 10)
			{
				//ignore lf & cr
				msg += char(chr);
			}
			ctr++;
			startTime = millis(); //reset timer
			if ((numChr != 0 && ctr == numChr) || (numChr == 0 && chr == 10 && ctr > 4))
			{
				if (RADIO.available())
				{
					//more coming, restart
					msg = "";
					ctr = 0;
				}
				else
				{
					//SerialOut("-->Rx: " + msg, true);
					return msg;
				}
			}
		}
	}
	//SerialOut("PCR rx timeout - msg=" + msg,true);
	return " "; //must return with something or audio locks up
}

