// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================

// THIS FILE CONTAINS ALL THE FILE I/O CODE

void Chk4DisclaimerFile()
{
	//if this file exists, user has viewed pg2 of disclaimer, don't show it again
	String fileName = "/DISCLAIM.TXT" + char(0);
	char fName[15];
	fileName.toCharArray(fName, fileName.length() + 1);
	if (!SD.exists(fName))
	{
		if (hmiReadDisclaimer == true)
		{
			//SerialOut("Creating disclaimer file", true);
			myFile = SD.open(fName, FILE_WRITE);
			myFile.println("User has read disclaimer.");
			myFile.close();
		}
	}
	else
	{
		//SerialOut("User has read disclaimer.", true);
		hmiReadDisclaimer = true;
	}

}

void Chk4TxMem()
{
	//chk for existing TXMEM file, if none, create it
	String temp = "";
	if (gShareDB == false)
	{
		temp = String(gRadioSel + 1, HEX);
	}
	String fileName = "/TXMEM/TXMEM" + temp + ".TXT";

	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Checking for " + String(fName), true);
	if (!SD.exists(fName))
	{
		SerialOut("Saving " + String(fName), true);
		Tx2HMI("Home.bRx.txt=`Creating " + String(fName) + "  `");
		myFile = SD.open(fName, FILE_WRITE);
		myFile.println("### Text based Transmit Buffer file for CTR2");
		myFile.println("### You can edit this file in a text editor");
		myFile.println("### CTR2 supports 10 entries for each mode with a maximum length of 75 chrs");
		myFile.println("### ..................Entries start below this line .....................");
		myFile.close();
		delay(2000);
		//clear tx buffers
		for (int i = 0; i < hmiTxMemMax; i++)
		{
			hmiTxMem[i] = " ";
		}
	}
	else
	{
		LoadTxMem();
	}
}

void LoadTxMem()
{
	String temp = "";
	if (gShareDB == false)
	{
		temp = String(gRadioSel + 1, HEX);
	}
	String fileName = "/TXMEM/TXMEM" + temp + ".TXT";

	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	SerialOut("Loading " + String(fName), true);
	String txt;
	char chr = 0;
	uint8_t rowCtr = 0;
	bool commentLn = false; //goes true if line starts with #

	int oldHMIPage = hmiPage;
	String oldHMIbRx = hmi_bRx;
	hmiPage = HMI_HOME;
	hmiWait4Reply = 0;
	Tx2HMI("Home.bRx.txt=`Loading " + String(fName) + "  `");
	hmiPage = oldHMIPage;
	delay(500);

	myFile = SD.open(fName);
	if (myFile)
	{
		while (myFile.available() && rowCtr < hmiTxMemMax)
		{
			chr = (myFile.read());
			if (chr == '#' && txt.length() == 0)
			{
				commentLn = true;
			}
			if (commentLn == true)
			{
				//read until we hit the end of this line
				if (chr == 13)
				{
					//reached the linefeed, start new line
					commentLn = false;
					txt = "";
				}
			}
			else
			{
				if (chr == 10)
				{
					//just ignore lf, use cr to inc 
					//txt = "";					
				}
				else if (chr == 13)
				{
					//save to hmiTxMem array
					hmiTxMem[rowCtr] = txt.trim();
					//SerialOut(String(rowCtr) + ": " + txt, true);
					//new line
					txt = "";
					rowCtr++;
				}
				else
				{
					txt += char(chr);
				}
			}
		}
		//myFile.close();
		Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
	}
	else
	{
		//failed to open
		hmiPage = HMI_HOME;
		hmiWait4Reply = 0;
		Tx2HMI("Home.bRx.txt=`Failed to open " + String(fName) + "  `");
		hmiPage = oldHMIPage;
		delay(2000);
		Tx2HMI("page " + String(oldHMIPage));
	}
	myFile.close();

	//send new strings to hmi
	UpdateTxMem(gOMode);
}



void UpdateTxMemSave()
{
	SaveTxMem(gRadioSel + 1);
	hmiWait4Reply = 0;
	Tx2HMI("TxMem.ctr.val=0"); //reset counter	
	Tx2HMI("TxMem.ctr.val=0"); //twice to make sure it takes	
}


void SaveTxMem(uint8_t radioNum)
{
	//save TxMem strings to TXMEM.TXT	
	String temp = "";
	if (gShareDB == false)
	{
		temp = String(radioNum, HEX);
	}

	String fileName = "/TXMEM/TXMEM" + temp + ".TXT";	
	
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	if (SD.exists(fName));
	{
		SerialOut("Removing " + String(fName), true);
		SD.remove(fName);
		delay(1000);
	}
	SerialOut("Saving " + String(fName), true);
	myFile = SD.open(fName, FILE_WRITE);

	if (myFile)
	{
		//write header first
		myFile.println("### Transmit Memory TXT file for CTR2 Radio " + String(radioNum));
		myFile.println("### You can edit this file in a text editor");
		myFile.println("### Maximum length for each entry is 75 characters");
		myFile.println("###");
		String txt = "";
		for (int i = 0; i < hmiTxMemMax; i++)
		{
			txt = hmiTxMem[i];
			if (txt.length() == 0)
			{
				txt = " ";
			}
			myFile.println(txt);
			myFile.flush();
			SerialOut(String(i) + ": " + txt, true);
		}		
		myFile.close();
	}	
}


void Chk4FreqListFile()
{
	//chk if freq list file exists
	String fileName = "FRQMEM.CSV"; //if using a common db
	if (gShareDB == false)
	{
		fileName = "FRQMEM_" + String(gRadioSel + 1, HEX) + ".CSV";
	}
	fileName = "/FREQ/" + fileName;
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Checking for " + String(fName), true);

	if (!SD.exists(fName))
	{
		//move the default values from the first 5 locations to the last 5
		Tx2HMI("Home.bRx.txt=`Creating " + String(fName) + "  `");
		//clear freqMem arrays
		for (int i = 0; i < freqMemMax; i++)
		{
			freqMemLabel[i] = " ";
			freqMemFreqA[i] = 0;
			freqMemFreqB[i] = 0;
			freqMemRMode[i] = 0;
			freqMemOMode[i] = 0;
			freqMemSplit[i] = RADIO_VFO_A; //turns off split mode
		}
		for (int i = 0; i < 5; i++)
		{
			//save beacon freqs in last 5 slots
			freqMemLabel[95 + i] = defaultFreqMemLabel[i];
			freqMemFreqA[95 + i] = defaultFreqMemFreq[i];
			freqMemOMode[95 + i] = defaultFreqMemOMode[i];
			freqMemRMode[95 + i] = defaultFreqMemRMode[i];
			freqMemTxLev[95 + i] = 50; //set these to defaults for first use
			freqMemLPFltr[95 + i] = 32;
			freqMemNFltr[95 + i] = 32;
		}
		//now save the correct data to the new file
		SaveFreqList(gRadioSel + 1); //save new default file
	}
	else
	{
		LoadFreqList();
	}
}

void LoadFreqList()
{
	String txt = "";
	String temp = "";
	char chr = 0;
	int rowCtr = 0;
	int colCtr = 0;
	int i = 0;
	bool commentLn = false; //goes true if line starts with #

	int oldHMIPage = hmiPage;
	String fileName = "FRQMEM.CSV"; //if using a common db
	if (gShareDB == false)
	{
		fileName = "FRQMEM_" + String(gRadioSel + 1, HEX) + ".CSV";
	}
	fileName = "/FREQ/" + fileName;
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Loading " + String(fName), true);
	String oldHMIbRx = hmi_bRx;
	hmiPage = HMI_HOME;
	hmiWait4Reply = 0;
	Tx2HMI("Home.bRx.txt=`Loading " + String(fName) + "  `");
	hmiPage = oldHMIPage;
	delay(500);

	//clear freqMem arrays
	for (int i = 0; i < freqMemMax; i++)
	{
		freqMemLabel[i] = " ";
		freqMemFreqA[i] = 0;
		freqMemFreqB[i] = 0;
		freqMemRMode[i] = 0;
		freqMemOMode[i] = 0;
		freqMemTxLev[i] = 50;
		freqMemLPFltr[i] = 32;
		freqMemNFltr[i] = 32;
		freqMemSplit[i] = RADIO_VFO_A;
	}

	int loc = 0;

	myFile = SD.open(fName);
	if (myFile)
	{
		while (myFile.available())
		{
			chr = (myFile.read());
			if (chr == '#' && txt.length() == 0)
			{
				commentLn = true;
			}
			if (commentLn == true)
			{
				//read until we hit the end of this line
				if (chr == 13)
				{
					//reached the linefeed, start new line
					commentLn = false;
					colCtr = 0;
					txt = "";
				}
			}
			else
			{
				//look for column terminator
				if (chr == ',')
				{
					//SerialOut("Loading", true);					
					//end of field, save value
					switch (colCtr)
					{
					case 0:
						//ignore the record #, just inc column
						colCtr++;
						break;
					case 1:
						if (txt.length() == 0)
						{
							txt = " ";
						}
						freqMemLabel[rowCtr] = txt;
						colCtr++;
						break;
					case 2:
						//if freq contains ' ' this is a split channel
						loc = txt.indexOf("+");
						if (loc > 0)
						{
							//this is a split, load A and B VFOs and set split flag
							temp = txt.substring(0, txt.indexOf("+"));
							freqMemFreqA[rowCtr] = temp.toInt();
							temp = txt.substring(txt.indexOf("+") + 1); //get vfo b freq
							freqMemFreqB[rowCtr] = temp.toInt();
							freqMemSplit[rowCtr] = RADIO_VFO_SPLIT;
						}
						else
						{
							freqMemFreqA[rowCtr] = txt.toInt();
							freqMemFreqB[rowCtr] = 0;
						}
						//SerialOut(String(rowCtr) + ": Freq=" + String(freqMemFreqA[rowCtr]), false);
						colCtr++;
						break;
					case 3:
						i = txt.toInt();
						if (i >= 0 && i < 9)
						{
							freqMemRMode[rowCtr] = i;
						}
						//SerialOut(", RMode=" + String(freqMemRMode[rowCtr]), false);
						colCtr++;
						break;
					case 4:
						i = txt.toInt();
						if (i >= 0 && i < 5)
						{
							freqMemOMode[rowCtr] = i;
						}
						//SerialOut(", OMode=" + String(freqMemRMode[rowCtr]), false);
						colCtr++;
						break;
					case 5:
						i = txt.toInt();
						if (i >= 0 && i <= 100)
						{
							freqMemTxLev[rowCtr] = i;
						}
						//SerialOut(", TxLev=" + String(freqMemTxLev[rowCtr]), false);
						colCtr++;
						break;
					case 6:
						i = txt.toInt();
						if (i >= 0 && i <= 32)
						{
							freqMemLPFltr[rowCtr] = i;
						}
						//SerialOut(", LPFltr=" + String(freqMemLPFltr[rowCtr]), false);
						colCtr++;
						break;
					case 7:
						i = txt.toInt();
						if (i >= 0 && i <= 32)
						{
							freqMemNFltr[rowCtr] = i;
						}
						//SerialOut(", NFltr=" + String(freqMemNFltr[rowCtr]), true);
						colCtr++;
						break;
					}
					txt = "";
				}
				else if (chr == 13)
				{
					//new line					
					txt = "";
					colCtr = 0;
					rowCtr++;
					if (rowCtr == freqMemMax)
					{
						goto ExitHr;
					}
				}
				else if (chr == 10)
				{
					//just ignore lf, use cr to inc 
					txt = "";
				}
				else
				{
					if (colCtr < 2 && txt.length() < 16)
					{
						txt += char(chr);
					}
					else if (isDigit(chr) || chr == '+')
					{
						//allow '+' on split freq
						txt += char(chr);
					}
				}
			}
		}

ExitHr:	
		myFile.close();
		hmi_bRx = oldHMIbRx;
		hmiPage = HMI_HOME;
		hmiWait4Reply = 0;
		Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
		hmiPage = oldHMIPage;
		hmiFreqMemStartAtPrev = 0xff; //reset so we upload new freqs 		
		return;
	}
	else
	{
		//failed to open
		hmiPage = HMI_HOME;
		hmiWait4Reply = 0;
		Tx2HMI("Home.bRx.txt=`Failed to open " + String(fName) + "    `");
		SerialOut("Failed to open " + String(fName), true);
		hmiPage = oldHMIPage;
		delay(2000);
		Tx2HMI("page " + String(oldHMIPage));
		myFile.close();
	}
	
}


void SaveFreqList(uint8_t radioNum)
{
	//save freqMem to FREQMEM_[radio#].CSV file on SD card	
	String fileName = "FRQMEM.CSV"; //if using a common db
	if (gShareDB == false)
	{
		fileName = "FRQMEM_" + String(radioNum, HEX) + ".CSV";
	}
	fileName = "/FREQ/" + fileName;
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	SerialOut("Saving " + String(fName), true);
	if (SD.exists(fName))
	{
		SD.remove(fName);
		delay(1000);
	}

	myFile = SD.open(fName, FILE_WRITE);

	if (myFile)
	{
		//write header first		
		myFile.println("### CSV Frequency & mode file for CTR2 Radio " + String(radioNum));
		myFile.println("### Enter the Label - Frequency (in hz) - radio mode - operation mode in the columns below");
		myFile.println("###");
		myFile.println("### Radio Mode: 0=CW 1=CWr 2=LSB 3=USB 4=FMn 5=FMw 6=AM 7=DigL 8=DigH");
		myFile.println("### Op Mode: 0=CW 1=Voice 2=RTTY 3=Digital 4=Beacon (see www.ncdxf.org/beacon/)");
		myFile.println("###");
		myFile.println("###Record#,Label,Freq(hz),Radio Mode, Op Mode,Tx Level,LP Filter,N Filter");

		String temp = "";
		for (int i = 0; i < freqMemMax; i++)
		{
			String txt = freqMemLabel[i];
			if (txt.length() == 0)
			{
				txt = " ";
			}
			if (freqMemSplit[i] == RADIO_VFO_SPLIT)
			{
				//save A and B freq with '+' divider
				temp = String(freqMemFreqA[i]) + "+" + String(freqMemFreqB[i]);
				//SerialOut("i= " + String(i) + ", temp= " + String(temp), true);
			}
			else
			{
				temp = String(freqMemFreqA[i]);
			}
			txt = String(i + 1) + "," + txt + "," + temp + "," + String(freqMemRMode[i]) + "," + String(freqMemOMode[i]) + "," + String(freqMemTxLev[i]) + "," + String(freqMemLPFltr[i]) + "," + String(freqMemNFltr[i]) + ", "; //terminate with a blank 				
			myFile.println(txt);
			//SerialOut(txt, true);
		}
	}
	myFile.close();
}


void Chk4LogFiles()
{
	//called on start up to make sure these files exist for logging
	//save two files - one a formatted .adi file for log reporting and one txt file to use with the Log page
	String txt = "";
	//Appends each log entry to CTR2_LOG.ADI
	if (!SD.exists("/LOG/CTR2_LOG.ADI"))
	{
		Tx2HMI("Home.bRx.txt=`Creating /LOG/CTR2_LOG.ADI and .TXT  `");
		//if file doesn't exist, open it and write header to it

		myFile = SD.open("/LOG/CTR2_LOG.ADI", FILE_WRITE);
		myFile.println("-----------------------------------------------------------------------------------------------");
		myFile.println("NOTE:");
		myFile.println("To convert this file to an ADIF formatted log file to import into your logging program ");
		myFile.println("copy everything between the lines below and save it to a .ADI file.");
		myFile.println("-----------------------------------------------------------------------------------------------");
		myFile.println(" ");
		myFile.println(" ");
		myFile.println("ADI [Control The Radio 2] Log file");
		myFile.println(" ");
		myFile.println("<adif_ver:5>3.1.0");
		myFile.println("<programid:4>CTR2");
		myFile.println("<EOH>");
		myFile.println(" ");
		myFile.close();
		delay(2000);
	}


	//chk if txt file exists
	if (!SD.exists("/LOG/CTR2_LOG.TXT"))
	{
		//if file doesn't exist, open it and write header to it
		myFile = SD.open("/LOG/CTR2_LOG.TXT", FILE_WRITE);
		myFile.println("### This is an unformatted text version of the ADI log file.");
		myFile.println("### It is used with the Log page in CTR2.");
		myFile.println("###");
		myFile.println("Date     Time Station Freq Mode Pwr RSTs RSTr Ctr Ex Notes");
		myFile.close();
	}
}


void SaveLog()
{
	//save the log entry to both the ADI file and the unformatted text file

	//format ADI file as date - time - station - freq - mode - power - rsts - rstr - notes
	//SerialOut("Saving CTR2_LOG.ADI", true);
	//Saved as Date - Time - Station -Freq -  Mode - Pwr - RSTs - RSTr - Cntr - Exch - Comments
	String txt = logADI[1] + logADI[6] + logADI[0] + logADI[2] + logADI[3] + logADI[7] + logADI[4] + logADI[8] + logADI[9] + logADI[10] + logADI[5];

	if (SD.exists("/LOG/CTR2_LOG.ADI") && txt.length() > 20)
	{
		myFile = SD.open("/LOG/CTR2_LOG.ADI", FILE_WRITE);
		myFile.println(txt); //fully formatted entry		
		myFile.close();
		delay(1000);

		txt = "";

		//save for the Log page to use
		//build string of just log txt - date/time/call/freq/mode/pwr/rsts/rstr/notes
		if (SD.exists("/LOG/CTR2_LOG.TXT"))
		{
			//SerialOut("Saving CTR2_LOG.TXT", true);
			//Saved as Date - Time - Station -Freq -  Mode - Pwr - RSTs - RSTr - Cntr - Exch - Comments			
			txt = logTxt[1] + " " + logTxt[6] + " " + logTxt[0] + " " + logTxt[2] + " " + logTxt[3] + " " + logTxt[7] + " " + logTxt[4] + " " + logTxt[8] + " " + logTxt[9] + " " + logTxt[10] + " " + logTxt[5];
			myFile = SD.open("/LOG/CTR2_LOG.TXT", FILE_WRITE);
			myFile.println(txt);
			myFile.close();
			delay(10);
			blockISR = true;
			LoadTxtLog(); //now reload the logList[] array to include the new entry
			blockISR = false;
		}
	}
}

void ListLog()
{
	//tab pressed while in Terminal mode - send log to SerialOut()
	//
	if (SD.exists("/LOG/CTR2_LOG.ADI"))
	{
		Serial.println(" ");
		Serial.println("Start CTR2 log from /LOG/CTR2_LOG.ADI");
		Serial.println("-------------------------------------------------------------------------------------");
		Serial.println(" ");
		myFile = SD.open("/LOG/CTR2_LOG.ADI", FILE_READ);
		while (myFile.available())
		{
			String temp = myFile.readStringUntil('\n');
			Serial.println(temp);
		}
		myFile.close();
		Serial.println(" ");
		Serial.println("-------------------------------------------------------------------------------------");
		Serial.println("End of log file");
		Serial.println(" ");

	}
}

String DownloadADILog()
{
	//return with ADI log for web server
	//replace < or > with &lt; and &gt;	
	String txt = "";
	if (SD.exists("/LOG/CTR2_LOG.ADI"))
	{
		myFile = SD.open("/LOG/CTR2_LOG.ADI");
		txt = "POST / HTTP/1.1\r\n";
		//txt += "Host: localhost:8000\r\n";
		txt += "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\n";
		txt += "Accept-Language:  en-US,en;g=0.5\r\n";
		txt += "Accept-Encoding: gqzip, deflate\r\n";
		txt += "Connection: close\r\n";
		txt += "Upgrade-Insecure-Requests: 1\r\n";
		txt += "Content-Type: text/plain\r\n";
		int temp = myFile.size();
		txt += "Content-Length:  " + String(temp) + "\r\n";

		while (myFile.available())
		{
			String temp = myFile.readStringUntil('\n');
			txt += temp;
			/* not required for sending file, only if sending to web page
			for (unsigned int i = 0; i < temp.length(); i++)
			{
				//replace < and > with html entities
				if (temp.charAt(i) == '<')
				{
					temp += "&#60;";
				}
				else if (temp.charAt(i) == '>')
				{
					temp += "&#62;";
				}
				else
				{
					temp += String(temp.charAt(i));
				}
			}
			txt += "<br>";
			*/
		}
		myFile.close();
		txt += ("-----------------------------------------------------------------------------------------------");
	}
	return txt;

}

void LoadTxtLog()
{
	//load log array with last 200 log entries
	if (SD.exists("/LOG/CTR2_LOG.TXT"))
	{
		char chr = 0;
		int rowCtr = 0;
		int colCtr = 0;
		int numEntries = 0;
		//clear logList array
		for (int i = 0; i < logListMax; i++)
		{
			logList[i][0] = 0;
		}
		//SerialOut("Loading CTR2_LOG.TXT", true);
		myFile = SD.open("/LOG/CTR2_LOG.TXT");
		//find # of entries in log - limit to last 200
		while (myFile.available())
		{
			chr = myFile.read();
			if (chr == 13)
			{
				numEntries++;
			}
		}
		myFile.close();
		delay(100);
		myFile = SD.open("/LOG/CTR2_LOG.TXT");
		int burnNum = numEntries - logListMax;
		if (burnNum > 0)
		{
			//more entries than we have room for, burn off the oldest ones
			int burnCtr = 0;
			while (myFile.available())
			{
				chr = myFile.read();
				//SerialOut(String(chr), false);
				if (chr == 13)
				{
					burnCtr++;
					if (burnCtr == burnNum)
					{
						//we're done burning old entries
						goto GetEntries;
					}
				}
			}
		}
	GetEntries:
		bool ignoreComment = false;
		int entryPtr = 0; //where we save entries in logList
		while (myFile.available())
		{
			chr = myFile.read();
			//SerialOut(String(chr), false);
			if (chr == 10)
			{
				//ignore lf, use cr as end of string
			}
			else if (chr == '#' && colCtr == 0)
			{
				//ignore comment lines
				ignoreComment = true;
			}
			else if (chr != 13 && ignoreComment == false)
			{
				if (colCtr == 4 || colCtr == 7)
				{
					//add hyphens to date
					logList[entryPtr][colCtr] = '-';
					colCtr++;
				}
				else if (colCtr == 13)
				{
					//add colon to time
					logList[entryPtr][colCtr] = ':';
					colCtr++;
				}
				logList[entryPtr][colCtr] = chr;
				colCtr++;
				if (colCtr == logListMaxLen - 1)
				{
					colCtr--; //don't inc
					logList[entryPtr][colCtr] = '~';//mark last chr to indicate more
				}
			}
			else if (chr == 13)
			{
				if (ignoreComment == true)
				{
					ignoreComment = false;
					goto SkipComment;
				}
				logList[rowCtr][colCtr] = 0; //null terminator
				colCtr = 0;
				entryPtr++;
			SkipComment:	rowCtr++;
				if (entryPtr > logListMax)
				{
					goto ExitHr;
				}
			}
		}
	ExitHr:
		if (rowCtr > 1)
		{
			gLogNumEntries = entryPtr; //total # of entries in log file
			//SerialOut("Number of log entries=" + String(gLogNumEntries), true);
		}
		else
		{
			gLogNumEntries = 0;
		}
		myFile.close();
	}
}


//FILE ROUTINES ********************************************************************************************

void Chk4Folders()
{
	//chk to make sure the required folders exist. If not, create them
	char dirName[15];
	String name = "/MISC"; //band registers and radio labels go here
	name.toCharArray(dirName, name.length() + 1); //add 1 to length for terminator
	if (!SD.exists(dirName))
	{
		SerialOut("Createing " + name, true);
		SD.mkdir(dirName);
	}
	name = "/RADIO";
	name.toCharArray(dirName, name.length() + 1);
	if (!SD.exists(dirName))
	{
		SerialOut("Createing " + name, true);
		SD.mkdir(dirName);
	}
	name = "/FREQ"; //freqmem goes here
	name.toCharArray(dirName, name.length() + 1);
	if (!SD.exists(dirName))
	{
		SerialOut("Createing " + name, true);
		SD.mkdir(dirName);
	}
	name = "/TXMEM"; //tx memeory files go here
	name.toCharArray(dirName, name.length() + 1);
	if (!SD.exists(dirName))
	{
		SerialOut("Createing " + name, true);
		SD.mkdir(dirName);
	}
	name = "/LOG"; //log files go here
	name.toCharArray(dirName, name.length() + 1);
	if (!SD.exists(dirName))
	{
		SerialOut("Createing " + name, true);
		SD.mkdir(dirName);
	}
}

void Chk4BandListFile(bool resetFile)
{
	//chk if freq list file exists - if it does, load it, if not, create it
	String fileName = "BNDLST.CSV"; //if using a common db
	if (gShareDB == false || resetFile == true)
	{
		fileName = "BNDLST_" + String(gRadioSel + 1, HEX) + ".CSV";
	}
	fileName = "/MISC/" + fileName; //add dir

	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Checking for " + String(fName), true);
	if (!SD.exists(fName) || resetFile == true)
	{
		//clear array
		gAnt = 1;
		gAntMode = 0;
		gAntBand = 0xff; //no band switching
		for (int i = 0; i < bandMemMax; i++)
		{
			bandMemLabel[i] = " ";
			bandMemFreq[i] = defaultMemFreq[i];
			bandMemRMode[i] = 2;
			bandMemOMode[i] = 1;
			bandMemTxLev[i] = 50;
			bandMemLPFltr[i] = 32;
			bandMemNFltr[i] = 32;
			bandMemAnt[i] = 1;
		}
		SaveBandList(gRadioSel + 1); //save new default file
	}

	LoadBandList();

}

void LoadBandList()
{

	//loaded on initial startup- then these are managed in memory and saved periodically (when band changes)
	String txt = "";
	char chr = 0;
	int rowCtr = 0;
	int colCtr = 0;
	bool commentLn = false; //goes true if line starts with #
	String fileName = "BNDLST.CSV"; //if using a common db
	if (gShareDB == false)
	{
		fileName = "BNDLST_" + String(gRadioSel + 1, HEX) + ".CSV";
	}
	fileName = "/MISC/" + fileName;
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Loading " + String(fName), true);
	int oldHMIPage = hmiPage;
	String oldHMIbRx = hmi_bRx;
	hmiPage = HMI_HOME;
	hmiWait4Reply = 0;
	Tx2HMI("Home.bRx.txt=`Loading " + String(fName) + "  `");
	hmiPage = oldHMIPage;
	delay(500);

	//load bandMem arrays with defaults
	for (int i = 0; i < bandMemMax; i++)
	{
		bandMemLabel[i] = " ";
		bandMemFreq[i] = defaultMemFreq[i];
		bandMemAnt[i] = 0; //first ant selected will set them all
		//OMode and RMode are preloaded when arrays were set up
	}

	//SD.remove("/MISC/BANDLIST.CSV"); //use to clear list

	myFile = SD.open(fName);
	if (myFile)
	{
		//SerialOut("Opened /MISC/BNDLST.CSV", true);
		while (myFile.available())
		{
			chr = (myFile.read());
			if (chr == '#' && txt.length() == 0)
			{
				commentLn = true;
			}
			if (commentLn == true)
			{
				//read until we hit the end of this line
				if (chr == 13)
				{
					//reached the linefeed, start new line
					commentLn = false;
					colCtr = 0;
					txt = "";
				}
			}
			else
			{
				if (chr == ',')
				{
					//end of field, save value
					ExtractBandInfo(colCtr, rowCtr, txt);
					colCtr++;
					txt = "";
				}
				else if (chr == 10)
				{
					//just ignore lf, use cr to inc 
					txt = "";
				}
				else if (chr == 13)
				{
					//we don't know which column we ended on, check colCtr					
					ExtractBandInfo(colCtr, rowCtr, txt);
					//new line					
					txt = "";
					colCtr = 0;
					rowCtr++;
					if (rowCtr == bandMemMax)
					{
						goto ExitHr;
					}
				}
				else
				{
					if (colCtr < 2 && txt.length() < 16)
					{
						txt += char(chr);
					}
					else if (isDigit(chr))
					{
						txt += char(chr);
					}
				}
			}
		}
	ExitHr:
		myFile.close();
		hmi_bRx = oldHMIbRx;
		hmiPage = HMI_HOME;
		hmiWait4Reply = 0;
		Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
		hmiPage = oldHMIPage;

		//chk for individual ants per band
		gAntBand = 0xff; //assume all the same
		uint8_t temp = bandMemAnt[0];
		for (int i = 1; i < bandMemMax; i++)
		{
			if (bandMemAnt[i] != temp)
			{
				//ants assigned per band
				gAntBand = bandMemAnt[gBand];
				break;
			}
		}

		if (hmiPage == HMI_HOME)
		{
			Tx2HMI("click code,1"); //update tRadioSel.txt to set radio:ant
		}
		return;
	}
	else
	{
		//failed to open
		hmiPage = HMI_HOME;
		hmiWait4Reply = 0;
		Tx2HMI("Home.bRx.txt=`Failed to open " + String(fName) + "  `");
		delay(2000);
		hmiPage = oldHMIPage;		
		Tx2HMI("page " + String(oldHMIPage));
		myFile.close();
		SaveBandList(gRadioSel + 1); //create a new default list
	}
}

void ExtractBandInfo(uint8_t colCtr, uint8_t rowCtr, String txt)
{
	//move txt to bandMemxxxx[]
	int i = 0;

	//SerialOut("rowCtr= " + String(rowCtr) + ", colCtr= " + String(colCtr) + ", txt= " + txt, true);
	switch (colCtr)
	{
	case 0:
		//ignore rec# column
		txt = "";
		break;
	case 1:
		if (txt.length() == 0)
		{
			txt = " ";
		}
		bandMemLabel[rowCtr] = txt;
		break;
	case 2:
		bandMemFreq[rowCtr] = txt.toInt();
		break;
	case 3:
		i = txt.toInt();
		if (i >= 0 && i < 9)
		{
			bandMemRMode[rowCtr] = i;
		}
		break;
	case 4:
		i = txt.toInt();
		if (i >= 0 && i < 5)
		{
			bandMemOMode[rowCtr] = i;
		}
		break;
	case 5:
		i = txt.toInt();
		if (i >= 1 && i <= 100)
		{
			bandMemTxLev[rowCtr] = i;
		}
		break;
	case 6:
		i = txt.toInt();
		if (i >= 1 && i <= 32)
		{
			bandMemLPFltr[rowCtr] = i;
		}
		break;
	case 7:
		i = txt.toInt();
		if (i >= 1 && i <= 32)
		{
			bandMemNFltr[rowCtr] = i;
		}
		break;
	case 8:
		i = txt.toInt();
		bandMemAnt[rowCtr] = i;	//bcd address			
		break;
	}
}

void SaveBandList(uint8_t radioNum)
{
	//save bandMem to BANDLIST.CSV file on SD card	
	if (gEncoder > 0 || gTxModeSet2 > RADIO_TX_ENAB || millis() - pttWatchDog < 10000)
	{		
		saveRadioCntr = 0; //reset counter - wait 60 more seconds before trying again
		return;
	}
	String fileName = "BNDLST.CSV"; //if using a common db
	if (gShareDB == false)
	{
		fileName = "BNDLST_" + String(radioNum, HEX) + ".CSV";
	}
	fileName = "/MISC/" + fileName;
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Saving " + String(fName), true);
	if (SD.exists(fName));
	{
		SD.remove(fName);
		delay(1000);
	}
	myFile = SD.open(fName, FILE_WRITE);
	if (myFile)
	{
		//write header first
		myFile.println("### CSV Band Frequency & mode file for CTR2 Radio " + String(radioNum));
		myFile.println("### Enter the Label - Frequency (in hz) - radio mode - operation mode in the columns below");
		myFile.println("###");
		myFile.println("### Radio Mode: 0=CW 1=CWr 2=LSB 3=USB 4=FMn 5=FMw 6=AM 7=DigL =DigH");
		myFile.println("### Op Mode: 0=CW 1=Voice 2=RTTY 3=Digital 4=Beacon (see www.ncdxf.org/beacon/)");
		myFile.println("### LP and Notch Filter values are 1/10th of actual values");
		myFile.println("###");
		myFile.println("###Record#,Label,Freq(hz),Radio Mode, Op Mode, Tx Level, LP Filter/10, N Filter/10, Antenna Adrs");
		for (int i = 0; i < bandMemMax; i++)
		{
			String txt = bandMemLabel[i];
			if (txt.length() == 0)
			{
				txt = " ";
			}
			txt = String(i + 1) + "," + txt + "," + String(bandMemFreq[i]) + "," + String(bandMemRMode[i]) + "," + String(bandMemOMode[i]) + "," + String(bandMemTxLev[i]) + "," + String(bandMemLPFltr[i]) + "," + String(bandMemNFltr[i]) + "," + String(bandMemAnt[i]);
			myFile.println(txt);
			//SerialOut(txt, true);
		}
	}
	myFile.close();
	ChkFreqModeChng(); //save current freq as last prev
}

void ChangeBaudRate(int curDir)
{
	int temp = radioBaud[gRadio];
	if (curDir == 1)
	{
		//inc baud rate
		switch (temp)
		{
		case 1200:
			temp = 2400;
			break;
		case 2400:
			temp = 4800;
			break;
		case 4800:
			temp = 9600;
			break;
		case 9600:
			temp = 19200;
			break;
		case 19200:
			temp = 38400;
			break;
		case 38400:
			temp = 57600;
			break;
		case 57600:
			temp = 115200;
			break;
		case 115200:
			temp = 1200;
			break;
		}
	}
	else
	{
		//dec baud
		switch (temp)
		{
		case 1200:
			temp = 115200;
			break;
		case 2400:
			temp = 1200;
			break;
		case 4800:
			temp = 2400;
			break;
		case 9600:
			temp = 4800;
			break;
		case 19200:
			temp = 9600;
			break;
		case 38400:
			temp = 19200;
			break;
		case 57600:
			temp = 38400;
			break;
		case 115200:
			temp = 57600;
			break;
		}
	}
	radioBaud[gRadio] = temp;
	SetRadioBaud();	
	SaveRadioBaud(gRadioSel + 1);
	Tx2HMI("gBaud=" + String(temp));
}

void LoadRadioBaud(uint8_t radioNum)
{
	//load radio baud list if it exists. It will only exist if the user has changed a default in radioBaud[]
	//NOTE: Each radio port can have its own baud list, reload when loading radio
	String fileName = "/MISC/BAUD_" + String(radioNum, HEX) + ".CSV";
	char fName[25];
	char chr = 0;
	String txt = "";
	bool commentLn = false;
	uint8_t colCtr = 0;
	fileName.toCharArray(fName, fileName.length() + 1);
	//SerialOut("Loading baud file " + fileName, true);
	if (SD.exists(fName))
	{
		myFile = SD.open(fName, FILE_READ);
		if (myFile)
		{
			while (myFile.available())
			{
				chr = (myFile.read());
				if (chr == '#' && txt.length() == 0)
				{
					commentLn = true;
				}
				if (commentLn == true)
				{
					//read until we hit the end of this line
					if (chr == 13)
					{
						//reached the linefeed, start new line
						commentLn = false;
						colCtr = 0;
						txt = "";
					}
				}
				else
				{
					if (chr == ',')
					{
						//end of field, save value
						radioBaud[colCtr] = txt.toInt();
						//SerialOut("Baud " + String(colCtr) + " = " + txt, true);
						colCtr++;
						txt = "";
					}
					else if (chr == 10)
					{
						//read in only one line
					}
					else if (chr == 13)
					{
						//we're done, exit
						myFile.close();
						return;
					}
					else if (isDigit(chr))
					{
						txt += char(chr);
					}
				}
			}
		}
		myFile.close();
	}
	else
	{
		//create a default file for this port
		SaveRadioBaud(radioNum);
	}
}


void SaveRadioBaud(uint8_t radioNum)
{
	//save radioBaud[] array to allow user to change default baude
	String fileName = "/MISC/BAUD_" + String(radioNum, HEX) + ".CSV";
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);
	SerialOut("Saving " + String(fName), true);
	if (SD.exists(fName));
	{
		SD.remove(fName);
		delay(1000);
	}
	myFile = SD.open(fName, FILE_WRITE);
	if (myFile)
	{
		//write header first
		myFile.println("### CSV Baud List for CTR2");
		myFile.println("###");
		myFile.println("###        ,Flex, PCR1000, Icom, Kenwood1, Kenwood2, Yaesu FTdx, Yaesu 100, Yaesu 757, Yaesu 8x7, Yaesu 890, Yaesu 1000");
		myFile.println("###Default:,WIFi, 9600, 19200, 9600-1 stopbit, 4800-2 stopbit, 38400, 4800, 38400, 38400, 38400, 38400,");
		myFile.println("###");
		String txt = "";
		for (int i = 0; i < radioTypeMax; i++)
		{
			txt += String(radioBaud[i]) + ",";
		}
		txt += "0"; //terminator
		//SerialOut("New baud rates= " + txt, true);
		myFile.println(txt);
	}
	myFile.close();
}



void EraseRadio()
{
	//reset selected radio to defaults and erase support files
	SerialOut("Erasing Radio Data", true);
	gRadioChange = 0;
	blockHMI = millis() + 5000; //ignore HMI for 5 sec
	gRadioSelPrev = gRadioSel;
	gShareDB = false; //so we don't delete shared files
	String txt = "- " + String(gRadioSel + 1) + " -";
	radioTag[gRadioSel] = txt;
	SaveRadioTags();
	gRadio = 0;
	gFreqRadio = 10000000;
	gBand = 15;
	gFreqRadioPrev = gFreqRadio;
	gVFOA = 10000000; //default to 10 mhz
	gVFOB = gVFOA;
	bPwr = "Pwr";
	gFFTFreq = 700;
	gFFTFreqPrev = 700;
	cTxSpeed = 15;
	cTxSpeedPrev = 15;
	cFarnSp = 15;
	cFarnSpPrev = 15;
	cKeyrMod = 0;
	cKeyrModPrev = 0;
	gDisLeft = false;
	cSideTn = 15;
	cSideTnPrev = 15;
	btPaddle = false;
	cLPFltr = 32;
	cNFltr = 32;
	gTxEQ = false;
	gTxEQPrev = false;
	gRxEQ = false;
	gRxEQPrev = false;
	vTxLev = 50;
	vLPFltr = 32;
	vNFltr = 32;
	gRtyBaud = 0;
	gRtyBaudPrev = 0;
	gRtyFrq = 0;
	gRtyFrqPrev = 0;
	gRtySft = 0;
	gRtySftPrev = 0;
	gRtyStp = 0;
	gRtyStpPrev = 0;
	rTxLev = 50;
	rLPFltr = 32;
	rNFltr = 32;
	gDigRxPath = 0;
	gDigRxPathPrev = 0;
	gDigTxPath = 0;
	gDigTxPathPrev = 0;
	dTxLev = 50;
	dTxLevPrev = 0;
	gDigVoxLev = 0;
	gDigVoxLevPrev = 0;
	gDigTxActiv = 0;

	gVocal = 0;

	gAnt = 1;
	gAntPrev = 1;
	gAntMode = 0;
	gAntModePrev = 0;
	gAntBand = 0xff;
	gSplit = 0;
	gFlexIP = "";
	gFlexPO = 100;
	gFlexLO = 20;
	gFlexTO = 10;
	gFlexWNB = 0;
	gFlexNB = 0;
	gFlexNR = 0;
	gFlexAF = 0;
	gFlexAnt = 1;

	gPCRStat = 0;
	gPCRCtrl = 0;

	gAnt = 1; //default to ant1
	gAntPrev = gAnt;
	gAntMode = false; //single ant mode
	gAntModePrev = gAntMode;
	gAntBand = 0xff; //all bands
	gAntBandPrev = gAntBand;

	Chk4BandListFile(true); //erase band and ant data

	txt = "/TXMEM/TXMEM_" + String(gRadioSel + 1, HEX) + ".TXT";
	char fName[25];
	txt.toCharArray(fName, txt.length() + 1);
	if (SD.exists(fName))
	{
		SD.remove(fName);		
	}
	Chk4TxMem(); //create empty file

	txt = "/FREQ/FREQMEM_" + String(gRadioSel + 1, HEX) + ".CSV";
	txt.toCharArray(fName, txt.length() + 1);
	if (SD.exists(fName))
	{
		SD.remove(fName);		
	}
	Chk4FreqListFile();

	txt = "/MISC/BNDLST_" + String(gRadioSel + 1, HEX) + ".CSV";
	txt.toCharArray(fName, txt.length() + 1);
	if (SD.exists(fName))
	{
		SD.remove(fName);		
	}
	SaveBandList(gRadioSel + 1);
	Tx2HMI("Home.bRx.txt='Rx:'");
	Tx2HMI("Home.bRx.txt='Rx:'");

}

void SaveRadio(uint8_t radioNum)
{
	//save the settings of the previously selected radio then update radio parmaeters to currently selected radio

	//if we've transmitted within the last 10 seconds, or have the encoder off-normal, exit and wait for next save event		
	//bool key = digitalRead(KEY_OUT);
	//bool ptt = digitalRead(PTT_OUT);		

	ChkFreqModeChng(); //save any changes to prev lists
	if (gEncoder > 0 || gTxModeSet2 > RADIO_TX_ENAB || millis() - pttWatchDog < 10000 || gAudioMode)
	{
		SerialOut("Save radio file blocked for 60 sec - millis=" + String(millis()), true);
		saveRadioCntr = 0; //reset counter - wait 60 more seconds before trying again
		return;
	}
	//reset save flag
	//SerialOut("Saving radio file - millis= " + String(millis()), true);
	gSvRadio = 0;
	hmiWait4Reply = 0;
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");

	//if this is the first update after booting, just load the selected radio
	if (gRadioSelPrev == 0xff)
	{
		//SerialOut("First update after booting - gRadioSel=" + String(gRadioSel) + ", gRadioSelPrev=" + String(gRadioSelPrev), true);
		LoadRadio();
		return;
	}
	String fileName = "/RADIO/RADIO_" + String(radioNum, HEX) + ".INI";
	char fName[25];
	fileName.toCharArray(fName, fileName.length() + 1);

	if (SD.exists(fName));
	{
		SD.remove(fName);
Wait2Rmv:
		delay(200);
		if (SD.exists(fName))
		{
			SerialOut("Radio file still exists", true);
			goto Wait2Rmv;
		}
	}

	SerialOut("Saving " + String(fName), true);
	Tx2HMI("Home.bRx.txt=`Saving Radio " + String(radioNum) + "            `");
	myFile = SD.open(fName, FILE_WRITE);
	delay(50);
	if (myFile)
	{
		myFile.println("Radio setting file for Radio " + String(radioNum));
		myFile.flush();
		myFile.println(" ");
		myFile.flush();
		myFile.println("label=" + radioTag[radioNum - 1]);
		myFile.flush();


		delay(1);

		//Home page
		//Don't save gUnit - leave it where the operator selected it
		//myFile.println("gUnit=" + String(gUnit));

		myFile.println("gTxLev=" + String(gTxLev));
		myFile.flush();
		myFile.println("gLPFltr=" + String(gLPFltr));
		myFile.flush();
		myFile.println("gNFltr=" + String(gNFltr));
		myFile.flush();
		myFile.println("gFreq=" + String(gFreqRadio));
		myFile.flush();
		myFile.println("gVFOA=" + String(gVFOA));
		myFile.flush();
		myFile.println("gVFOB=" + String(gVFOB));
		myFile.flush();
		myFile.println("gOMode=" + String(gOMode));
		myFile.flush();
		myFile.println("gRMode=" + String(gRMode));
		myFile.flush();
		myFile.println("gRadio=" + String(gRadio));
		myFile.flush();
		// don't save this - it's manually selected by operator
		//myFile.println("gRadioSel=" + String(gRadioSel));

		delay(1);

		myFile.println("gBand=" + String(gBand));
		myFile.flush();
		myFile.println("gShareDB=" + String(gShareDB));
		myFile.flush();
		myFile.println("Config.gFFTAvg.val=" + String(gFFTAvg));
		myFile.flush();
		myFile.println("gMon=" + String(gMon));
		myFile.flush();
		myFile.println("gVocal=" + String(gVocal));
		myFile.flush();
		if (bPwr.length() == 0)
		{
			bPwr = "Pwr";
		}
		myFile.println("bPwr=" + bPwr);
		myFile.flush();

		//gains are only loaded on the initial radio load so they don't change when selecting another radio
		myFile.println("gFFTFreq=" + String(int(gFFTFreq)));
		myFile.flush();
		myFile.println("Home.fftGain.val=" + String(int(gFFTGain)));
		myFile.flush();
		myFile.println("Home.volGain.val=" + String(int(gVolGain)));
		myFile.flush();
		myFile.println("Home.sqGain.val=" + String(int(gSqGain)));
		myFile.flush();

		//CW page
		myFile.println("CW.cTxSpeed.val=" + String(cTxSpeed));
		myFile.flush();
		myFile.println("CW.cFarnSp.val=" + String(cFarnSp));
		myFile.flush();
		myFile.println("CW.cKeyrMod.val=" + String(cKeyrMod));
		myFile.flush();
		myFile.println("CW.cSideTn.val=" + String(cSideTn));
		myFile.flush();
		myFile.println("CW.btPaddle.val=" + String(btPaddle));
		myFile.flush();
		myFile.println("CW.cLPFltr.val=" + String(cLPFltr));
		myFile.flush();
		myFile.println("CW.cNFltr.val=" + String(cNFltr));
		myFile.flush();

		delay(1);

		//Voice page
		myFile.println("Voice.vTxLev.val=" + String(vTxLev));
		myFile.flush();
		myFile.println("Voice.vLPFltr.val=" + String(vLPFltr));
		myFile.flush();
		myFile.println("Voice.vNFltr.val=" + String(vNFltr));
		myFile.flush();
		myFile.println("Voice.gTx0.val=" + String(gTx0));
		myFile.flush();
		myFile.println("Voice.gTx1.val=" + String(gTx1));
		myFile.flush();
		myFile.println("Voice.gTx2.val=" + String(gTx2));
		myFile.flush();
		myFile.println("Voice.gTx3.val=" + String(gTx3));
		myFile.flush();
		myFile.println("Voice.gTx4.val=" + String(gTx4));
		myFile.flush();
		myFile.println("Voice.gTxComp.val=" + String(gTxComp));
		myFile.flush();
		myFile.println("Voice.btEQ.val=" + String(gEQSel));
		myFile.flush();
		myFile.println("Voice.gTxEQ.val=" + String(gTxEQ));
		myFile.flush();
		myFile.println("Voice.gRx0.val=" + String(gRx0));
		myFile.flush();
		myFile.println("Voice.gRx1.val=" + String(gRx1));
		myFile.flush();
		myFile.println("Voice.gRx2.val=" + String(gRx2));
		myFile.flush();
		myFile.println("Voice.gRx3.val=" + String(gRx3));
		myFile.flush();
		myFile.println("Voice.gRx4.val=" + String(gRx4));
		myFile.flush();
		myFile.println("Voice.gRxEQ.val=" + String(gRxEQ));
		myFile.flush();

		delay(1);

		//RTTY page
		myFile.println("RTTY.rTxLev.val=" + String(rTxLev));
		myFile.flush();
		myFile.println("RTTY.rLPFltr.val=" + String(rLPFltr));
		myFile.flush();
		myFile.println("RTTY.rNFltr.val=" + String(rNFltr));
		myFile.flush();
		myFile.println("RTTY.gRtyFrq.val=" + String(gRtyFrq));
		myFile.flush();
		myFile.println("RTTY.gRtySft.val=" + String(gRtySft));
		myFile.flush();
		myFile.println("RTTY.gRtyStp.val=" + String(gRtyStp));
		myFile.flush();
		myFile.println("RTTY.gRtyBaud.val=" + String(gRtyBaud));
		myFile.flush();

		//Dig page
		myFile.println("Dig.dTxLev.val=" + String(dTxLev));
		myFile.flush();
		myFile.println("Dig.gRxPath.val=" + String(gDigRxPath));
		myFile.flush();
		myFile.println("Dig.gTxPath.val=" + String(gDigTxPath));
		myFile.flush();
		myFile.println("Dig.gVoxLev.val=" + String(gDigVoxLev));
		myFile.flush();
		myFile.println("gTxActiv=" + String(gDigTxActiv));
		myFile.flush();
		myFile.println("Dig.gProc.val=" + String(gDigProc));
		myFile.flush();

		delay(1);

		//Flex page
		if (gFlexIP.length() == 0)
		{
			gFlexIP = " ";
		}
		myFile.println("gFlexIP=" + gFlexIP);
		myFile.flush();
		myFile.println("gFlexAnt.val=" + String(gFlexAnt));
		myFile.flush();
		myFile.println("gFlexPO.val=" + String(gFlexPO));
		myFile.flush();
		myFile.println("gFlexLO.val=" + String(gFlexLO));
		myFile.flush();
		myFile.println("gFlexTO.val=" + String(gFlexTO));
		myFile.flush();
		myFile.println("gFlexWNB.val=" + String(gFlexWNB));
		myFile.flush();
		myFile.println("gFlexNB.val=" + String(gFlexNB));
		myFile.flush();
		myFile.println("gFlexNR.val=" + String(gFlexNR));
		myFile.flush();
		myFile.println("gFlexAF.val=" + String(gFlexAF));
		myFile.flush();

		//PCR page		
		myFile.println("gPCRStat=" + String(gPCRStat));
		myFile.flush();
		myFile.println("gPCRCtrl=" + String(gPCRCtrl));
		myFile.flush();

		delay(1);

		//Audio page
		myFile.println("Audio.gRecGain.val=" + String(gAudioRecGain));
		myFile.flush();

		//Ant page
		myFile.println("gAnt=" + String(gAnt)); //get this from bandMemAnt[] if gAntBand != 0xff after loading radio
		myFile.flush();
		myFile.println("gAntMode=" + String(gAntMode));
		myFile.flush();
		myFile.println("gAntBand=" + String(gAntBand));
		myFile.flush();
		myFile.println("gCtstCtr=" + String(gCtstCtr));
		myFile.flush();
		myFile.println("gLogMode=" + String(gLogMode));
		myFile.flush();

		//Levels page
		myFile.println("Levels.gLnInLv.val=" + String(int(gLnInLv)));
		myFile.println("Levels.gMicInLv.val=" + String(int(gMicInLv)));
		myFile.println("Levels.gLnOutLv.val=" + String(int(gLnOutLv)));
		myFile.println("Levels.gUSBInLv.val=" + String(int(gUSBInLv)));
		myFile.println("Levels.gUSBOutLv.val=" + String(int(gUSBOutLv)));
		myFile.println("Levels.gFFTLv.val=" + String(int(gFFTLv)));
		
		//add more as needed
	}
	else
	{
		SerialOut("Error creating Radio File", true);
	}
	myFile.close();
	gAction = 0;
	delay(100);

	//SerialOut("Radio Save complete", true);
	hmiWait4Reply = 0;
	Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
	Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");

	//reset save flag

	hmiWait4Reply = 0;
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");

	if (gRadioSel != gRadioSelPrev)
	{
		//SerialOut("Loading radio after saving it - gRadioSel=" + String(gRadioSel) + ", gRadioSelPrev=" + String(gRadioSelPrev), true);
		LoadRadio(); //now load the new radio from gRadioSel
	}
}

void LoadRadio()
{
	//load the currently selected radio's properties
	SetRJ45Switch(); //select the RJ45 port and radio antenna before loading the radio data
	if (gRadioSel == gRadioSelPrev)
	{
		SetAntSwitch(false); //just in case
		return; //nothing to load
	}

	char chr = 0;
	char fName[25];

	String fileName = "/RADIO/RADIO_" + String(gRadioSel + 1, HEX) + ".INI";

	fileName.toCharArray(fName, fileName.length() + 1);

	SerialOut("Loading " + String(fName), true);
	
	ShowInitializing();

	//if wifi is on and flex is connected, disconnect flex
	if (gWiFi != 0 && gFlexCon == true)
	{
		gAction = 151; //kill slice if we're moving to another radio
		DoAction();
	}

	if (!SD.exists(fName))
	{
		//save current radio and exit				
		SerialOut("File " + String(fName) + " doesn't exist, saving it now...", true);
		gRadioSelPrev = gRadioSel; //save current radio - also block continous loop
		EraseRadio(); //set to defaults and create new aux files
		SaveRadio(gRadioSel + 1);
		//load radio from new file to setup hmi display values
	}

	//SerialOut("Start: " + String(millis()), true);

	hmiWait4Reply = 0;
	blockHMI = millis() + 10000; //block txInfo decoding for 10 seconds while we load the new data from file

	uint8_t ptr = 0; //points to '='

	if (!hmiRadioLoaded)
	{
		//mute volume if this is first load
		gVolGain = 0;
		ChkRxSquelch(false);
	}

	LoadRadioBaud(gRadioSel + 1); //get baud list for this port

	myFile = SD.open(fName);
	if (myFile)
	{
		//parse file and reload variables
		String txt = "";
		String temp = "";
		String sel = String(gRadioSel + 1);
		Tx2HMI("Home.bRx.txt=`Loading " + radioTag[gRadioSel] + "  `");

		while (myFile.available())
		{
			txt = "";
			while (myFile.available())
			{
				chr = myFile.read();
				if (chr != 10 && chr != 13)
				{
					txt += String(chr);
				}
				else if (chr == 13)
				{
					break;
				}
			}

			ptr = txt.indexOf("=") + 1;			
			delay(20);
			if (txt.length() > ptr)
			{
				SerialOut(txt, true);
				if (txt.substring(0, ptr) == "label=")
				{
					//radioTag[gRadioSel] = ExtractValue(txt); //no need to do this
				}
				else if (txt.substring(0, ptr) == "gTxLev=")
				{
					gTxLev = ExtractValue(txt);
					gTxLevPrev = gTxLev;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gLPFltr=")
				{
					gLPFltr = ExtractValue(txt);
					gLPFltrPrev = gLPFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gNFltr=")
				{
					gNFltr = ExtractValue(txt);
					gNFltrPrev = gNFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gFreq=") //Home page variables
				{
					gFreqRadio = ExtractValue(txt);
					//gFreqHMI = gFreqRadio; //gFreqHMI won't be sent back if the radio starts as locked
					gFreqRadioPrev = gFreqRadio;
					TxFreq2Radio(gFreqRadio);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					delay(20);
					temp = CalcBand();
					Tx2HMI("gBand=" + String(gBand));
					Tx2HMI("gBand=" + String(gBand));
					gBandPrev = gBand;
					delay(20);
					Tx2HMI("Home.bBand.txt=`" + temp + "`");
					Tx2HMI("Home.bBand.txt=`" + temp + "`");
				}
				else if (txt.substring(0, ptr) == "gVFOA=")
				{
					gVFOA = ExtractValue(txt);				
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gVFOB=")
				{
					gVFOB = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gOMode=")
				{
					gOMode = ExtractValue(txt);
					gOModePrev = gOMode;
					hmiTxMemMode = gOMode; //so TxMem labels work first time
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					Tx2HMI("TxMem.mode.val=" + String(gOMode));
					Tx2HMI("TxMem.mode.val=" + String(gOMode));
				}
				else if (txt.substring(0, ptr) == "gRMode=")
				{
					gRMode = ExtractValue(txt);
					gRModePrev = gRMode;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gRadio=")
				{
					gRadio = ExtractValue(txt);
					if (gRadio >= RADIO_TYPE_NUMRADIOS)
					{
						gRadio = 0;
					}
					gRadioPrev = gRadio;
					txt = "gRadio=" + String(gRadio);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				/* Don't load this from file - operator changes this to change radio port
				else if (txt.substring(0, ptr) == "gRadioSel=")
				{
					gRadioSel = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				*/
				/* gBand is calculated by gFreqRadio above				
				else if (txt.substring(0, ptr) == "gBand=")
				{
					gBand = ExtractValue(txt);
					gBandPrev = gBand;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				*/
				else if (txt.substring(0, ptr) == "gShareDB=")
				{
					gShareDB = ExtractValue(txt);
					gShareDBPrev = gShareDB;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}				
				else if (txt.substring(0, ptr) == "Config.gFFTAvg.val=")
				{
				gFFTAvg = ExtractValue(txt);					
				hmiWait4Reply = 0;
				Tx2HMI(txt);
				Tx2HMI(txt);
				}

				else if (txt.substring(0, ptr) == "gMon=")
				{
					gMon = ExtractValue(txt);
					gMonPrev = gMon;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gVocal=")
				{
					gVocal = ExtractValue(txt);					
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					hmiAnnounce = VOICE_SAY_Freq + VOICE_SAY_gRMode + VOICE_SAY_gOMode; //say freq & mode if enabled
				}

				else if (txt.substring(0, ptr) == "bPwr=")
				{
					bPwr = txt.substring(ptr);					
					if (bPwr.length() == 0)
					{
						bPwr = "Pwr";
					}
					hmiWait4Reply = 0;
					Tx2HMI("Home.bPwr.txt=`" + bPwr + "`");
					Tx2HMI("Home.bPwr.txt=`" + bPwr + "`");
				}
				else if (txt.substring(0, ptr) == "gFFTFreq=")
				{
					//set freq only on intial radio file load so they don't change when changing radios
					gFFTFreq = float(ExtractValue(txt));
					gFFTFreqPrev = gFFTFreq;	
					hmiWait4Reply = 0;
					Tx2HMI("gFFTFreq=" + String(int(gFFTFreq / 25)));
					Tx2HMI("gFFTFreq=" + String(int(gFFTFreq / 25)));
				}
				else if (txt.substring(0, ptr) == "Home.fftGain.val=" && !hmiRadioLoaded)
				{
					//set gains only on intial radio file load so they don't change when changing radios
					gFFTGain = float(ExtractValue(txt));
					gFFTGainPrev = gFFTGain;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Home.volGain.val=" && !hmiRadioLoaded)
				{
					gVolGain = float(ExtractValue(txt));
					gVolGainPrev = gVolGain;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Home.sqGain.val=" && !hmiRadioLoaded)
				{
					gSqGain = ExtractValue(txt);
					gSqGainPrev = gSqGain;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}

				else if (txt.substring(0, ptr) == "CW.cTxSpeed.val=") // CW page
				{
					cTxSpeed = ExtractValue(txt);
					cTxSpeedPrev = cTxSpeed;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.cFarnSp.val=")
				{
					cFarnSp = ExtractValue(txt);
					cFarnSpPrev = cFarnSp;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.cKeyrMod.val=")
				{
					cKeyrMod = ExtractValue(txt);
					cKeyrModPrev = cKeyrMod;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.cSideTn.val=")
				{
					cSideTn = ExtractValue(txt);
					cSideTnPrev = cSideTn;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.btPaddle.val=")
				{
					btPaddle = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.cLPFltr.val=")
				{
					cLPFltr = ExtractValue(txt);
					cLPFltrPrev = cLPFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "CW.cNFltr.val=")
				{
					cNFltr = ExtractValue(txt);
					cNFltrPrev = cNFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.vTxLev.val=") //Voice page
				{
					vTxLev = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.vLPFltr.val=") //Voice page
				{
					vLPFltr = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.vNFltr.val=") //Voice page
				{
					vNFltr = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTx0.val=")
				{
					gTx0 = ExtractValue(txt);
					gTx0Prev = gTx0;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTx1.val=")
				{
					gTx1 = ExtractValue(txt);
					gTx1Prev = gTx1;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTx2.val=")
				{
					gTx2 = ExtractValue(txt);
					gTx2Prev = gTx2;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTx3.val=")
				{
					gTx3 = ExtractValue(txt);
					gTx3Prev = gTx3;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTx4.val=")
				{
					gTx4 = ExtractValue(txt);
					gTx4Prev = gTx4;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTxComp.val=") //Voice page
				{
					gTxComp = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.btEQ.val=")
				{
					gEQSel = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gTxEQ.val=")
				{
					gTxEQ = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRx0.val=")
				{
					gRx0 = ExtractValue(txt);
					gRx0Prev = gRx0;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRx1.val=")
				{
					gRx1 = ExtractValue(txt);
					gRx1Prev = gRx1;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRx2.val=")
				{
					gRx2 = ExtractValue(txt);
					gRx2Prev = gRx2;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRx3.val=")
				{
					gRx3 = ExtractValue(txt);
					gRx3Prev = gRx3;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRx4.val=")
				{
					gRx4 = ExtractValue(txt);
					gRx4Prev = gRx4;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Voice.gRxEQ.val=")
				{
					gRxEQ = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.rTxLev.val=") // RTTY page
				{
					rTxLev = ExtractValue(txt);
					rTxLevPrev = rTxLev;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					}
				else if (txt.substring(0, ptr) == "RTTY.rLPFltr.val=")
				{
					rLPFltr = ExtractValue(txt);
					rLPFltrPrev = rLPFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.rNFltr.val=")
				{
					rNFltr = ExtractValue(txt);
					rNFltrPrev = rNFltr;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.gRtyFrq.val=")
				{
					gRtyFrq = ExtractValue(txt);
					gRtyFrqPrev = gRtyFrq;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.gRtySft.val=")
				{
					gRtySft = ExtractValue(txt);
					gRtySftPrev = gRtySft;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.gRtyStp.val=")
				{
					gRtyStp = ExtractValue(txt);
					gRtyStpPrev = gRtyStp;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "RTTY.gRtyBaud.val=")
				{
					gRtyBaud = ExtractValue(txt);
					gRtyBaudPrev = gRtyBaud;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Dig.dTxLev.val=") // Dig page
				{
					dTxLev = ExtractValue(txt);
					dTxLevPrev = dTxLev;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Dig.gRxPath.val=")
				{
					gDigRxPath = ExtractValue(txt);
					gDigRxPathPrev = gDigRxPath;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Dig.gTxPath.val=")
				{
					gDigTxPath = ExtractValue(txt);
					gDigTxPathPrev = gDigTxPath;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Dig.gVoxLev.val=")
				{
					gDigVoxLev = ExtractValue(txt);
					gDigVoxLevPrev = gDigVoxLev;
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gTxActiv=")
				{
					gDigTxActiv = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Dig.gProc.val=")
				{
					gDigProc = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gFlexIP=") //Flex page
				{
					gFlexIP = txt.substring(ptr);
					if (gFlexIP.length() == 0)
					{
						gFlexIP = " ";
					}
					hmiWait4Reply = 0;
					Tx2HMI("Flex.gFlexIP.txt=`" + gFlexIP + "`");
					Tx2HMI("Flex.gFlexIP.txt=`" + gFlexIP + "`");
				}
				else if (txt.substring(0, ptr) == "gFlexPO.val=")
				{
					gFlexPO = ExtractValue(txt);
					gFlexPOPrev = gFlexPO;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexLO.val=")
				{
					gFlexLO = ExtractValue(txt);
					gFlexLOPrev = gFlexLO;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexTO.val=")
				{
					gFlexTO = ExtractValue(txt);
					gFlexTOPrev = gFlexTO;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexWNB.val=")
				{
					gFlexWNB = ExtractValue(txt);
					gFlexWNBPrev = gFlexWNB;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexNB.val=")
				{
					gFlexNB = ExtractValue(txt);
					gFlexNBPrev = gFlexNB;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexNR.val=")
				{
					gFlexNR = ExtractValue(txt);
					gFlexNRPrev = gFlexNR;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexAF.val=")
				{
					gFlexAF = ExtractValue(txt);
					gFlexAFPrev = gFlexAF;
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gFlexAnt.val=")
				{
					gFlexAnt = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI("Flex." + txt);
					Tx2HMI("Flex." + txt);
				}
				else if (txt.substring(0, ptr) == "gPCRStat=") // PCR page
				{
					gPCRInit = false; //reset initialize flag so we reinitialize it
					gPCRStat = ExtractValue(txt);
					//SerialOut("Loading PCR stat =" + String(gPCRStat), true);
					Dec_gPCRStat();
					hmiWait4Reply = 0;
					Tx2HMI("gPCRStat=" + String(gPCRStat)); //hmi will extract booleans when PCR page opens
					Tx2HMI("gPCRStat=" + String(gPCRStat));
					delay(10);
					//send gPRCPwrBtn so HMI knows the state of the radio power switch
					uint8_t radioPwr = PCR_Ping();
					if (radioPwr > 0)
					{
						Tx2HMI("PCR.gPwrSw.val=1");
						Tx2HMI("PCR.gPwrSw.val=1");
					}
					Tx2HMI("PCR.gPwrBtn.val=" + String(gPRCPwrBtn));
					Tx2HMI("PCR.gPwrBtn.val=" + String(gPRCPwrBtn));
				}
				else if (txt.substring(0, ptr) == "gPCRCtrl=")
				{
					gPCRInit = false; //reset initialize flag so we reinitialize it
					gPCRCtrl = ExtractValue(txt);
					//SerialOut("Loading PCR Ctrls = " + String(gPCRCtrl, HEX), true);
					Dec_gPCRCtrl();
					Tx2HMI("gPCRCtrl=" + String(gPCRCtrl)); //hmi will extract booleans when PCR page opens
					Tx2HMI("gPCRCtrl=" + String(gPCRCtrl));
				}
				else if (txt.substring(0, ptr) == "Audio.gRecGain.val=") // Audio page
				{
					gAudioRecGain = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}				
				else if (txt.substring(0, ptr) == "gAnt=") // Antenna page
				{
					gAnt = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					SerialOut(txt, true);
				}				
				else if (txt.substring(0, ptr) == "gAntMode=") // Antenna page
				{
					gAntMode = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					SerialOut(txt, true);
				}
				else if (txt.substring(0, ptr) == "gAntBand=") //Antenna band
				{
					gAntBand = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
					SerialOut(txt, true);
				}
				else if (txt.substring(0, ptr) == "Levels.gLnInLv.val=") //level offset
				{
					gLnInLv = float(ExtractValue(txt));
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Levels.gMicInLv.val=")
				{
					gMicInLv = float(ExtractValue(txt));
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Levels.gLnOutLv.val=") 
				{
					gLnOutLv = float(ExtractValue(txt));					
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Levels.gUSBInLv.val=") 
				{
					gUSBInLv = float(ExtractValue(txt));
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "Levels.gUSBOutLv.val=") 
				{				
					gUSBOutLv = float(ExtractValue(txt));
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);									
				}
				else if (txt.substring(0, ptr) == "Levels.gFFTLv.val=") 
				{
					gFFTLv = float(ExtractValue(txt));
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gCtstCtr=") //contest counter
				{
					gCtstCtr = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);
				}
				else if (txt.substring(0, ptr) == "gLogMode=") 
				{
					gLogMode = ExtractValue(txt);
					hmiWait4Reply = 0;
					Tx2HMI(txt);
					Tx2HMI(txt);					
				}
				delay(10);
			}
			gTxLevPrev = 0xff; //force hmi update with new values
			gLPFltrPrev = 0xff;
			gNFltrPrev = 0xff;
		}
		ChkFreqChange();
	}
	else
	{
		SerialOut("Failed to open " + String(fName), true);
		gRadioSel = 0; //load radio 1 files
	}
	myFile.close();

	gTxModeSet2 = RADIO_TX_OFF; //make sure this is off when we load a new radio
	gTxMode = RADIO_TX_OFF;
	Tx2HMI("gTxMode=0");
	Tx2HMI("gTxMode=0");
	Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
	Tx2HMI("Home.bRx.txt=`" + hmi_bRx + "`");
	Tx2HMI("Home.bTx.txt=`Tx:`");
	Tx2HMI("Home.bTx.txt=`Tx:`");
	gMSel = 0;
	Tx2HMI("gMSel=0");
	Tx2HMI("gMSel=0");
	Tx2HMI("Scan.gMemSel.val=0");
	Tx2HMI("Scan.gMemSel.val=0");
	gMSelPrev = 0;
	gMSelPtr = 0;

	delay(500);
	//reset save flag
	gSvRadio = 0;
	hmiWait4Reply = 0;
	Tx2HMI("Radio.gSelNum.val=255"); //update labels next scan
	Tx2HMI("Radio.gSelNum.val=255");
	delay(10);
	Tx2HMI("Radio.gSelTxt.txt=``");
	Tx2HMI("Radio.gSelTxt.txt=``");
	delay(10);
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");
	Tx2HMI("gSvRadio=0");
	delay(10);

	//SerialOut("Done: " + String(millis()), true);

	gRadioSelPrev = gRadioSel; //match them up after everything's loaded

	Chk4FreqListFile();
	Chk4BandListFile(false); //don't erase band data
	Chk4TxMem();
	SetTxPath();	
	SetEqualizer(true);	
	SetOutputSource(0, true);		
	SetFilterFreq(6);	
	SetRadioBaud();	
	ChkFreqModeChng(); //save any changes to prev lists
	CalcBand(); //sets gBand, gAnt, and gAntBand
	SetAntSwitch(false); //set ant switch on exit

	hmiRadioLoaded = true;//set once the first radio is loaded - this allows decoding of the block txInfo message
	hmiAnnounce = VOICE_SAY_Freq + VOICE_SAY_gRMode + VOICE_SAY_gOMode;
	if (hmiPage == HMI_HOME)
	{
		Tx2HMI("click code,1"); //update tRadioSel.txt	
	}

	if (gRadio == RADIO_TYPE_FLEX && gWiFi == 1)
	{
		//switch to flex page if flex is the selected radio and wifi is on		
		blockHMI = 0; //shorter time so Flex page can download
		Tx2HMI("page Flex");
	}
	Tx2HMI("Home.tInfo1.bco=BLACK");
	Tx2HMI("Home.tInfo1.bco=BLACK");
	Tx2HMI("Home.tInfo2.bco=BLACK");
	Tx2HMI("Home.tInfo2.bco=BLACK");
	blockHMI = millis() + 2000; //wait 2 sec for hmi to settle down

}

void LoadRadioTags()
{
	String txt = "";
	char chr = 0;
	uint8_t ptr = 0;
	int idx = 0;
	int jdx = 0;
	//if label file doesn't exist, create it

	//use this code to reset labels file

	/*
	if (SD.exists("/MISC/RAD-TAGS.TXT"))
	{
		SerialOut("============ Deleted RAD-TAGS", true);
		SD.remove("R-LABEL.TXT");
		delay(10000);
	}
	*/


	if (!SD.exists("/MISC/RAD-TAGS.TXT"))
	{
		SerialOut("Creating RAD-TAGS.TXT", true);
		myFile = SD.open("/MISC/RAD-TAGS.TXT", FILE_WRITE);
		for (int i = 0; i < 24; i++)
		{
			if (i < 16)
			{
				//first 16 are radio tags, last 8 are ant tags
				txt = "=-- " + String(i + 1) + " --";
				if (i == gRadioSel && gShareDB == true)
				{
					//add astrick to name if sharing dbase
					txt = '*' + txt;
				}
				else
				{
					//not shared - just space
					txt = ' ' + txt;
				}
			}
			else
			{
				//ant tags
				txt = "=-- " + String(i - 15) + " --";
			}
			myFile.println(String(i + 1) + txt);
		}
		myFile.close();
	}
	delay(500);

	myFile = SD.open("/MISC/RAD-TAGS.TXT");
	if (myFile)
	{
		//parse file and reload variables
		while (myFile.available())
		{
			txt = "";
			while (myFile.available())
			{
				chr = myFile.read();
				if (chr != 10 && chr != 13)
				{
					txt += String(chr);
				}
				else if (chr == 13)
				{
					break;
				}
			}
			jdx = txt.indexOf("=") + 1;
			if (jdx > 1)
			{
				//ignore unless it's a pair
				idx = txt.toInt() - 1; //labels saved in idx=txt format				
				radioTag[idx] = txt.substring(jdx); //these will be uploaded to HMI Radio page when it's selected		
				String temp = radioTag[idx];
				//SerialOut("Load: " + radioTag[idx] + ", Len= " + String(temp.length()), true);
				if (idx == gRadioSel)
				{
					//chk to see if "*" is in name, if so, we're sharing dbase
					txt = radioTag[idx];
					if (txt.charAt(0) == '*')
					{
						gShareDB = true;
					}
					else
					{
						gShareDB = false;
					}
				}
				ptr++;
				if (ptr > 23)
				{
					break;
				}
			}
		}
	}
	else
	{
		SerialOut("Failed to open /MISC/RAD-TAGS.TXT", true);
	}
	myFile.close();
}

void SaveRadioTags()
{
	String txt = "";
	if (SD.exists("/MISC/RAD-TAGS.TXT"))
	{
		SD.remove("/MISC/RAD-TAGS.TXT");
		delay(1000);
	}
	//SerialOut("Saving Radio Labels", true);
	myFile = SD.open("/MISC/RAD-TAGS.TXT", FILE_WRITE);
	if (myFile)
	{
		myFile.println("# This file contains the labels used for the 16 radio channels");
		myFile.println("# and the 8 antenna switches.");
		myFile.println("# To reset these labels to default, delete this file.");
		myFile.println("#");
		for (int i = 0; i < 24; i++)
		{
			//mark radio tag with backspace chr if shareDB is selected
			txt = radioTag[i];
			if (i < 16)
			{
				//radio tags 0 to 15, antenna tags 16 to 23
				if (i == gRadioSel)
				{
					if (txt.charAt(0) != '*' && gShareDB == true)
					{
						radioTag[i] = '*' + txt.substring(1); //add shared flag to front of txt
					}
					else if (txt.charAt(0) == '*' && gShareDB == false)
					{
						//remove it if we're not sharing db
						radioTag[i] = ' ' + txt.substring(1);
					}
					if (txt.charAt(0) != ' ' && txt.charAt(0) != '*')
					{
						//pad with char(1) if not using it for shared - strip first chr when sending to hmi
						radioTag[i] = ' ' + radioTag[i];
					}
				}
			}
			myFile.println(String(i + 1) + "=" + radioTag[i]);
			//SerialOut("Saving " + radioTag[i], true);
		}
	}
	myFile.close();
}

uint32_t ExtractValue(String txt)
{
	//NOTE: THIS ROUTINE EXPECTS AN INTEGER VALUE IN TXT (NO PERIODS)
	
	//extract the value from the pair and return it
	//count in digits one at a time - the .toInt() function only works up to 31 bits then overflows 

	uint8_t strt = txt.indexOf("=") + 1;
	uint32_t val = 0;
	txt = txt.substring(strt);

	//count digits in and multiply them by their digit position

	long multiplier = 1; //inc by 10 each interation
	for (int i = txt.length(); i > 0; i--)
	{
		String temp = txt.substring(i - 1, i);
		val += (temp.toInt() * multiplier);
		multiplier *= 10;
	}

	//SerialOut("Extracted val=" + String(val), true);

	hmiRx[2] = val & 0xff;
	hmiRx[3] = (val & 0xff00) >> 8;
	hmiRx[4] = (val & 0xff0000) >> 16;
	hmiRx[5] = (val & 0xff000000) >> 24;
	return val;
}

