String version = "Code ver: 08/11/2021"; //this appears on Config page with display version
//   HMI version = 8/04/2021

/*
  THIS FILE CONTAINS THE CTR2 PROJECT GLOBAL VARIABLES AND DEBUGGING CODE

  INITIAL SETUP IS CONTAINED IN THE SETUP.INO FILE

  LOOP FUNCTIONS ARE CONTAINED IN THE LOOP.INO FILE

  OTHER .INO FILES ARE NAMED FOR THE FUNCTIONS THEY CONTAIN


  Portions Copyright (c) 2012-2021 http://www.pjrc.com/


*/

// =====================================================================================================================================================================================================
// (c) 2021 Lynn Hansen, KU7Q															                                                                                                               |
// This Source Code Form is subject to the terms of the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007. A copy of this license can be found here: https://choosealicense.com/licenses/gpl-3.0/|
// =====================================================================================================================================================================================================


//comment this out to turn off Serial.print/prnitln debug outputs 
#define enabSerialOut 1 

//Debug switches - uncommend to send debug data to Serial

//#define DEBUG_HMI_RX     1
//#define DEBUG_HMI_RX_DATA    1
//define DEBUG_HMI_TX        1  //prints summary
//#define DEBUG_HMI_TX_DATA  1  //prints detail
//#define PRINT_ERRORS		 1
//#define DEBUG_FLEX_API     1

#define ctrlAllRJ45Ports     1 //uncomment this for debugging - it ignores unused RJ45 boards in logic and just directly controls all RJ45 (and antenna switch) ports

//===========================================================================================================

// Default values for Audio components - adjust these to change the levels as needed for different mics, usb audio, etc
// set controls to LEV_OFF to turn off audio
// For AMPs, add value below to level from hmi level value

#define LEV_OFF         0.0 //set amp off
#define LEV_UNITY       1.0 //set amp for unity gain

#define LEV_MIXER_RX0   0.7 //line-in (rx) 
#define LEV_MIXER_RX1   0.1 //sidetone level

#define LEV_MIXER_TX0   0.7 //mic input -- reduce this level to reduce digital noise in Tx
#define LEV_MIXER_TX1	0.7 //USB In
#define LEV_MIXER_TX2	0.1 //RTTY In
#define LEV_MIXER_TX3   0.7 //PlayRawSD In

#define LEV_OUT_SRC0	0.7 //Filtered Rx
#define LEV_OUT_SRC1	0.7 //Unfiltered Rx
#define LEV_OUT_SRC2	0.7 //Unfiltered Tx
#define LEV_OUT_SRC3	0.7 //Filtered Tx

#include <USBHost_t36.h>
#include <antplusdefs.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <WiFiEspAT.h>

//See https://github.com/jandrassy/WiFiEspAT for a description of the WiFiEspAT.h library
//ESP01 must have at least v1.7 firmware - but not 2.0, 2.1 is OK


//see https://wiki.uiowa.edu/display/teensymacos/Audio+Processing+on+the+Teensy for a description of how to set the eqFilter on the SGTL5000

// GUItool: begin automatically generated code ============================================
//Paste autogenerated code from https://www.pjrc.com/teensy/gui/
//between the two ===== lines below
//
//=========================================================================================

#include <Audio.h>
#include <Wire.h>
#include <SPI.h>
#include <SD.h>
#include <SerialFlash.h>

// GUItool: begin automatically generated code
AudioInputUSB            USB_In;         //xy=146,468
AudioInputI2S            Line_In;        //xy=163,316
AudioSynthWaveformDc     RTTY_KEY;       //xy=210,530
AudioAmplifier           Amp_USB_In;           //xy=306,469
AudioAmplifier           Amp_Mic_In;           //xy=322,398
AudioAmplifier           Amp_In;           //xy=327,292
AudioSynthWaveformSine   Sidetone;       //xy=328,346
AudioPlaySdWav           playSdWav;     //xy=333,594
AudioSynthWaveformSineModulated RTTY;           //xy=360,531
AudioMixer4              Mixer_Rx;       //xy=535,359
AudioMixer4              Mixer_Tx;       //xy=539,521
AudioAmplifier           Amp_USB_Out;        //xy=703,137
AudioFilterBiquad        Filter_Tx;      //xy=708,541
AudioAnalyzeRMS          Vox_Det;        //xy=710,603
AudioFilterBiquad        Filter_Rx;      //xy=713,204
AudioAnalyzeRMS          Sq_Det;         //xy=718,264
AudioMixer4              Output_Source;  //xy=884,404
AudioOutputUSB           USB_Out;        //xy=891,138
AudioAmplifier           Amp_FFT;        //xy=965,196
AudioAmplifier           Amp_Rec;        //xy=1029,295
AudioAmplifier           Amp_Out;        //xy=1098,400
AudioOutputI2S           Output;         //xy=1100,492
AudioRecordQueue         Record_Out;     //xy=1148,346
AudioAnalyzeToneDetect   Tone2;          //xy=1154,192
AudioAnalyzeToneDetect   Tone1;          //xy=1156,144
AudioAnalyzeFFT1024      fft1024_1;      //xy=1157,239
AudioConnection          patchCord1(USB_In, 0, Amp_USB_In, 0);
AudioConnection          patchCord2(Line_In, 0, Amp_In, 0);
AudioConnection          patchCord3(Line_In, 1, Amp_Mic_In, 0);
AudioConnection          patchCord4(RTTY_KEY, RTTY);
AudioConnection          patchCord5(Amp_USB_In, 0, Mixer_Tx, 1);
AudioConnection          patchCord6(Amp_Mic_In, 0, Mixer_Tx, 0);
AudioConnection          patchCord7(Amp_In, 0, Mixer_Rx, 0);
AudioConnection          patchCord8(Sidetone, 0, Mixer_Rx, 1);
AudioConnection          patchCord9(playSdWav, 0, Mixer_Tx, 3);
AudioConnection          patchCord10(RTTY, 0, Mixer_Tx, 2);
AudioConnection          patchCord11(Mixer_Rx, Filter_Rx);
AudioConnection          patchCord12(Mixer_Rx, Amp_USB_Out);
AudioConnection          patchCord13(Mixer_Rx, 0, Output_Source, 1);
AudioConnection          patchCord14(Mixer_Rx, Sq_Det);
AudioConnection          patchCord15(Mixer_Tx, Filter_Tx);
AudioConnection          patchCord16(Mixer_Tx, Vox_Det);
AudioConnection          patchCord17(Mixer_Tx, 0, Output_Source, 2);
AudioConnection          patchCord18(Amp_USB_Out, 0, USB_Out, 0);
AudioConnection          patchCord19(Amp_USB_Out, 0, USB_Out, 1);
AudioConnection          patchCord20(Filter_Tx, 0, Output_Source, 3);
AudioConnection          patchCord21(Filter_Rx, 0, Output_Source, 0);
AudioConnection          patchCord22(Output_Source, Amp_FFT);
AudioConnection          patchCord23(Output_Source, Amp_Out);
AudioConnection          patchCord24(Output_Source, Amp_Rec);
AudioConnection          patchCord25(Amp_FFT, fft1024_1);
AudioConnection          patchCord26(Amp_FFT, Tone1);
AudioConnection          patchCord27(Amp_FFT, Tone2);
AudioConnection          patchCord28(Amp_Rec, Record_Out);
AudioConnection          patchCord29(Amp_Out, 0, Output, 0);
AudioConnection          patchCord30(Amp_Out, 0, Output, 1);
AudioControlSGTL5000     sgtl5000_1;     //xy=348,654
// GUItool: end automatically generated code


//==========================================================================================

/*
	Teensy Audio Board Notes:
	1. Use Output_Source mixer to select source to send to output
	  a. 0=filtered rx path
	  b. 1=unfiltered rx path (used for digital mode
	  c. 2=filtered tx path (to monitor tx traffic)
	2. Both left and right channels of Output must be connected to Output_Source to work 
	3. Output goes to both Line-Out and Headphone - use sgtl5000_1.mute/unmute to enable/disable each output
	4. Vox_Det samples USB_In from PC. If tone is found, switch audio path to output tones and key PTT
	5. Sq_Det samples Rx audio. Compare with sqGain - if greater, allow Amp_Out gain to be set in Rx mode
	
*/


// Use these with the Teensy Audio Shield
#define SPI_CS_PIN    10
#define SPI_MOSI_PIN  11
#define SPI_MISO_PIN  12 //from forum
#define SPI_SCK_PIN   13

//uncomment to use SPI_CS_PIN to use SD card on audio board
//
//#define SD_CS  SPI_CS_PIN  	
//comment BUILTIN_SDCARD to disable SD card on the 4.1 board
#define SD_CS  BUILTIN_SDCARD //use SD card on 4.1 board



//set ISR interrupt here 
#define ISR_Interval     3000 //run decoder ISR every 3 mSec


//pin assingments
#define PTT_OUT			2
#define KEY_OUT			3
#define PDL_LEFT		4
#define PDL_RIGHT		5
#define ROTARY_SW       6
#define ROTARY_A		22 
#define ROTARY_B		9

//pins for RJ45 Switch - accessable from the bottom of the Teensy 4.0
#define RJ_SW_DATA_1	26
#define RJ_SW_DATA_2	27
#define RJ_SW_DATA_3	30
#define RJ_SW_DATA_4	31
#define RJ_SW_STROBE	32
#define RJ_SW_INHIBIT	33

//separate strobe for ant switch - output based on gAnt
#define ANT_SW_STROBE   41 

//Enumerated values **************************************************************************************************************************

//HMI screens - change here if changing order in HMI configuration
#define HMI_S		   0 //splash page - concentrated variables are here
#define HMI_HOME	   1
#define HMI_BAND	   2
#define HMI_MODE       3
#define HMI_CW	       4
#define HMI_VOICE      5
#define HMI_RTTY	   6
#define HMI_DIG        7
#define HMI_TXMEM      8
#define HMI_FREQMEM	   9
#define HMI_LOG        10
#define HMI_HELP 	   11
#define HMI_CONFIG	   12
#define HMI_KEYPAD	   13
#define HMI_RXMSG	   14
#define HMI_INPUT	   15
#define HMI_EDIT	   16
#define HMI_SAVELOG    17
#define HMI_AUTOLOG    18
#define HMI_SCAN       19
#define HMI_FLEX       20
#define HMI_RADIO      21
#define HMI_PCR		   22
#define HMI_VFO		   23
#define HMI_AUDIO      24
#define HMI_ANT		   25
#define HMI_LEVELS     26

//set up serial port names here
#define HMI		 Serial3 //local HMI display connected here
#define HMIR     Serial8 //serial port on Aux board - use for remote HMI display - it has precidence if it's connected
#define RADIO    Serial4
//TTL Serial port on Serial6 - define it here in the future
#define ESP      Serial7 //use for ESP8266 comm


//command values - used to set lastHMICmd so DecHMICmd knows what command was transmitted
//Start at 100 so control IDs below don't interfer with these - THESE VALUES MUST BE UNIQUE!

#define HMI_RESET			100
#define HMI_ADDT			101
#define HMI_bPwr			102 //get power for log
#define HMI_gMyCall			103
#define HMI_EDIT_DOWNLOAD	104 //record # to save if btSave pressed on Edit page
#define HMI_EDIT_b1			105
#define HMI_EDIT_b2			106
#define HMI_EDIT_b3			107
#define HMI_EDIT_b4			108
#define HMI_EDIT_bt5		109
#define HMI_EDIT_b6			110
#define HMI_RADIO_gSelTxt   111 //get Radio.gSelTxt.txt to update radioLabel array
#define HMI_KEYER_tuneTx	112 //chk position of tune btn


#define HMI_ANT_saveTag     113 //get changed antenna tag from Ant page then save it

//hmi component id enumeration
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
// -- NOTE --- !!!! These values will change if you delete variable or controls, or change the controls level !!!!
//!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
#define HMI_FFT35			52 //fft graph id on 3.5" display
#define HMI_FFT50			51 //fft graph id on 5" display
#define HMI_CONFIG_DEL_LOG  19 //delete log button
#define HMI_EDIT_SAVE		2

//enumeration for sequence of encoder select button on Home page
#define HMI_HOME_PG_FREQ	  0
#define HMI_HOME_PG_SPEED     1
#define HMI_HOME_PG_FFTFREQ   2
#define HMI_HOME_PG_LPFLTR    3
#define HMI_HOME_PG_NFLTR     4
#define HMI_HOME_PG_MEMCH     5
#define HMI_HOME_PG_FFTGAIN   6
#define HMI_HOME_PG_VOLGAIN   7
#define HMI_HOME_PG_SQGAIN    8
#define HMI_HOME_PG_MAX_CTRL  9

//enumeration for encoder select on Band Page
#define HMI_BAND_PG_NONE	  0
#define HMI_BAND_PG_RADIO     1
#define HMI_BAND_PG_BAUD      2
#define HMI_BAND_PG_MAX_CTRL  3

//enumeration for encoder select CW page
#define HMI_CW_PG_NONE		0
#define HMI_CW_PG_KEYER	    1
#define HMI_CW_PG_SIDETONE  2
#define HMI_CW_PG_SPEED     3
#define HMI_CW_PG_FARNSP    4
#define HMI_CW_PG_LPFLTR    5 //filter low pass
#define HMI_CW_PG_NFLTR     6 //filter notch
#define HMI_CW_PG_MAX_CTRL  7

//enumeration for encoder select Voice page
#define HMI_VOICE_PG_NONE     0
#define HMI_VOICE_PG_EQ0	  1
#define HMI_VOICE_PG_EQ1	  2
#define HMI_VOICE_PG_EQ2	  3
#define HMI_VOICE_PG_EQ3	  4
#define HMI_VOICE_PG_EQ4	  5
#define HMI_VOICE_PG_TXLEV	  6
#define HMI_VOICE_PG_LPFLTR   7
#define HMI_VOICE_PG_NFLTR    8
#define HMI_VOICE_PG_MAX_CTRL 9

//enumeration for encoder select RTTY page
#define HMI_RTTY_PG_NONE     0
#define HMI_RTTY_PG_BAUD     1
#define HMI_RTTY_PG_FREQ     2
#define HMI_RTTY_PG_SHIFT    3
#define HMI_RTTY_PG_STOP     4
#define HMI_RTTY_PG_TXLEV	 5
#define HMI_RTTY_PG_LPFLTR   6
#define HMI_RTTY_PG_NFLTR    7
#define HMI_RTTY_PG_MAX_CTRL 8

//enumeration for encoder select Dig page
#define HMI_DIG_PG_NONE     0
#define HMI_DIG_PG_TXLEV	1
#define HMI_DIG_PG_VOXLEV   2
#define HMI_DIG_PG_MAX_CTRL 3

//enumeration for encoder select FreqMem page
#define HMI_FMEM_PG_NONE    0
#define HMI_FMEM_PG_SCROLL	1
#define HMI_FMEM_PG_MAX_CTRL 2

//enumeration fo encoder select Log page
#define HMI_LOG_PG_NONE     0
#define HMI_LOG_PG_SCROLL   1
#define HMI_LOG_PG_MAX_CTRL 2

//enumeration for encoder select PCR page
#define HMI_PCR_PG_NONE		0
#define HMI_PCR_PG_BW		1
#define HMI_PCR_PG_VOL		2
#define HMI_PCR_PG_SQ		3
#define HMI_PCR_PG_IF		4
#define HMI_PCR_PG_DSPNR	5
#define HMI_PCR_PG_MAX_CTRL 6

//enumeration for encoder select Flex page
#define HMI_FLEX_PG_NONE    0
#define HMI_FLEX_PG_LO      1
#define HMI_FLEX_PG_PO      2
#define HMI_FLEX_PG_TO      3
#define HMI_FLEX_PG_WNB     4
#define HMI_FLEX_PG_NB      5
#define HMI_FLEX_PG_NR      6
#define HMI_FLEX_PG_AF      7
#define HMI_FLEX_PG_MAX_CTRL 8

#define HMI_LEVELS_PG_NONE     0
#define HMI_LEVELS_PG_LN_IN    1
#define HMI_LEVELS_PG_MIC_IN   2
#define HMI_LEVELS_PG_USB_IN   3
#define HMI_LEVLES_PG_USB_OUT  4
#define HMI_LEVELS_PG_LN_OUT   5
#define HMI_LEVELS_PG_FFT      6
#define HMI_LEVELS_PG_MAX_CTRL 7

//hmi rtc register read commands - set them higher than others because they are read from any page based on hmiRTCUpdateTimer
#define HMI_RTC_YR			200
#define HMI_RTC_MON			201
#define HMI_RTC_DAY			202
#define HMI_RTC_HR			203
#define HMI_RTC_MIN			204
#define HMI_RTC_SEC			205

//RADIO TYPES*********************************************************************************************************************************
//This is how the radios are sequened in Band.tm0 event that fills in tRadio.txt - gRadio is sent to HMI to be saved in EEProm
#define RADIO_TYPE_NONE			0
#define RADIO_TYPE_FLEX         1
#define RADIO_TYPE_PCR1000		2
#define RADIO_TYPE_ICOM			3
#define RADIO_TYPE_KENWOOD1		4
#define RADIO_TYPE_KENWOOD2     5
#define RADIO_TYPE_YAESUFTDX    6
#define RADIO_TYPE_YAESU100		7
#define RADIO_TYPE_YAESU757		8 
#define RADIO_TYPE_YAESU8x7     9
#define RADIO_TYPE_YAESU890		10
#define RADIO_TYPE_YAESU1000	11
#define RADIO_TYPE_NUMRADIOS    12 //this must match the # of entries in the radioList[] array

//MODES **************************************************************************************************************************************
#define RADIO_CW			0 //coorlates to Mode page Radio Mode options
#define RADIO_CW_R			1
#define RADIO_LSB			2
#define RADIO_USB			3
#define RADIO_FM_N			4
#define RADIO_FM_W			5
#define RADIO_AM			6
#define RADIO_DIG_L			7
#define RADIO_DIG_H			8

//transmit modes
#define RADIO_TX_OFF		0 //transmit modes
#define RADIO_TX_ENAB		1 //tx enabled
#define RADIO_TX_PADDLE		2 //transmitting using paddle ptt
#define RADIO_TX_VOX		3 //transmitting using vox ptt
#define RADIO_TX_BTN		4 //transmitting using btTxMode btn

#define RADIO_VFO_A			0 //gSplit using vfoA for tx/rx
#define RADIO_VFO_B			1 //gSplit using vfoB for tx/rx
#define RADIO_VFO_SPLIT		2 //gSplit using vfoA for Rx, vfoB for Tx

#define MODE_CW				0 //corolates to Mode page OP Mode options
#define MODE_VOICE			1
#define MODE_RTTY			2
#define MODE_DIG			3
#define MODE_BEACON			4

#define AUDIO_IDLE			0 //audio record/playback modes for gAudioMode
#define AUDIO_RECORD		1
#define AUDIO_PLAYBACK		2

//keyer mode enumeration
#define KEYER_NONE			0 //keyer modes
#define KEYER_STRAIGHT		1
#define KEYER_PASSTHRU      2 //passes tip to Key and ring to PTT toward radio
#define KEYER_IAMBIC_A		3
#define KEYER_IAMBIC_B		4
#define KEYER_ULTIMATIC     5
#define KEYER_BUG			6
#define KEYER_MODE_MAX      7

//rtty mode enumeration
#define RTTY_BAUD_45		0 //rtty baud rates
#define RTTY_BAUD_50		1
#define RTTY_BAUD_75		2
#define RTTY_BAUD_100		3
#define RTTY_BAUD_MAX		4

#define RTTY_SHIFT_170		0 //rtty freq shift
#define RTTY_SHIFT_225		1
#define RTTY_SHIFT_425		2
#define RTTY_SHIFT_450		3
#define RTTY_SHIFT_850		4
#define RTTY_SHIFT_MAX		5

#define RTTY_STOP_1			0
#define RTTY_STOP_1_5		1
#define RTTY_STOP_2			2
#define RTTY_STOP_MAX		3

#define RTTY_FREQ_2125		0
#define RTTY_FREQ_2295		1
#define RTTY_FREQ_MAX		2

//digital mode enumeration
#define DIG_TX_USB			0 //digital tx path from USB
#define DIG_TX_MIC			1 //digital tx path from mic
#define DIG_RX_USB			0 //digital rx path to USB
#define DIG_RX_HDPHONE		1 //digital rx path to headphones
#define DIG_ACT_NOTHING     0 //do nothing when tx audio exceeds threshold
#define DIG_ACT_PASS		1 //pass tx audio to radio when threshold exceeded
#define DIG_ACT_KEY		    2 //key PTT and pass audio to radio when threshold exceeded

//esp tx enumeration
#define ESP_FLEX			0 //tx to flex
#define ESP_WEB				1 //tx to web server

//comm mode enumeration
#define COM_MODE_DEBUG       0 //idle, print out serial messages
#define COM_MODE_CAT         1 //process cat commands
#define COM_MODE_TERM		 2 //process keyboard commands from a terminal program

//audio recording source enumeration
#define AUDIO_SRC_MIC		0 //record from mic
#define AUDIO_SRC_LINEIN	1 //record from linein

//voice announcement enumeration
#define VOICE_SAY_None		0
#define VOICE_SAY_Freq		1
#define VOICE_SAY_gRMode	2
#define VOICE_SAY_gOMode	4

//disclaimer page
#define HELP_DISCLAIMERPG   34 //change if changing last page in disclaimer page in help - user must visit this page to stop disclaimer from appearing on bootup

//********************************************************************************************************************************************
//Global Variables
// ==========================================================================================================================================


//HMI ****************************************************************************************************************************************
bool hmiRmt = true; //stays true if a remote display is connected to HMIR (serial8) - if not, use HMI (serial3)

bool hmiInitialized = false;
bool hmiRadioLoaded = false; //goes true after initial file is loaded

bool hmiReadDisclaimer = false; //save in RadioTags file, goes true when user displays 2nd page of disclaimer - then we won't show it again

volatile bool ISRActive = false; //goes true while ISR is running

uint8_t gSize = 0; //display size, 35 for 3.5", 50 for 5.0" - send from S.TxS,1 block msg on startup
int hmiPage = 0; //tracks selected page#
int hmiPagePrev = 0;
int hmiCompID = 0; //tracks last component ID pressed
int hmiEvent = 0; //tracks last component event, 1=pressed, 0=released (for two state buttons)
int hmiNewMsg = 0; //if >0 contains new msg index so we know what to process 
int hmiCtrlChange = 0; //set to control # to send change to
int hmiTransparentMode = 0; //hold transparent mode reply code so we know we're ready to tx fft data
int hmiWait4Reply = 0; //stores the last request for a global variable - reply doesn't include ID#
int hmiLastPage = 0; //track what page we were on the last call
int hmiUpdateCtr = 0; //counts # of times UpdateHMIDisplay() is called, used to limit updates
uint32_t blockHMI = 0; //add time to millis() to block decoding of rx txInfo blocks for a certain time to keep hmi data from overwriting new data values from encoder 
String fftID = ""; //holds device id for fft based on HMI_FFT35 or HMIFFT50

int hmiFFTMarker1 = 0; //pointers to cursors on fft - calculate position when changing modes
int hmiFFTMarker2 = 0;

long hmiRTCUpdateTimer = millis(); //update uProc RTC from HMI
long hmiRTCUpdateTimerDefault = 43200000; //update RTC on uP from HMI every 12 hours

String hmiTxQue = ""; //save cmd hr if we are txing to hmi during ISR
String espTxQue = ""; //save esp cmd if we're in an ISR when its called

String hmi_tData = ""; //holds Input.tData.txt while Input page is open 

uint8_t hmiTxMemCtr = 0; //if > 0 we have editied one of the tx mems and haven't saved it yet - don't update display
uint8_t hmiTxMemMode = 0; //mode that TxMem is editing, 0=cw, 1=voice, 2=rtty, 3=rx audio 

uint8_t hmiFreqMemStartAt = 1; //holds value of start memory location on FreqMem page
uint8_t hmiFreqMemStartAtPrev = 0xff; //holds previous start memory so we can upload new values to FreqMem page
uint8_t gMSel = 0; //memSel status - 1s based -- holds selected memory location from FreqMem page - reset to 0 once changed
uint8_t gMSelPtr = 0; //points to current memory selection
uint8_t gMSelPrev = 0; //tracks changes

//flag for button action
uint8_t gAction = 0;
uint8_t gActionPrev = 0;
   /*
   0=Home.btPlay 1>0 change
   1=Home.btPlay 0>1 change
   3=Home.btStop pressed
   4=future
   5=TxMem.bSave pressed
   6=Dec radio
   7=Inc radio
   8=Inc baud rate
   9=Dec baud rate
   100-109 - audio record/playback
   150-159 - Flex connect/disconnect/tune
   */


String hmiLogEntry = ""; //used to collect the .adi formatted log string to save to the CTR2_LOG.ADI file

int hmiLogCtr = 0; //tracks # of active alarms - limit to hmiLogMax
int hmiLogOffset = 0; //tract what entry goes into the top log entry on hmi
int hmiLogFirstEntry = -1;//track where first log entry starts... once we fill the list once, set this to 0 to start tracking first entry on list
int hmiLogNextEntry = 1; //log is rotating list, hmiLogNextEntry points to the latest entry

int hmiHelpPageDir = 0; //holds curDir from encoder to inc or dec help page if we're on it

//rtc min & sec used for beacon mode
uint32_t hmiRTCMin = 0xff; 
uint32_t hmiRTCSec = 0xff;

//rx text boxes on hmi
unsigned int hmi_rxM_len = 36; //limit size of string on 3.5" display - change to 50 for 5" display - based on gSize
unsigned int hmi_bRx_max = 36; //max_len for bRx on 3.5" display - change to 50 for 5" display
String hmi_bRx = "Rx:"; //holds txt for bRx on Home page

//tx text box for tx msg buffer
String hmi_bTx = "Tx:"; //load with Home.bTx.txt - pick off one chr at a time and run it through ascii/morse converter


//DSP ************************************************************************************************************************************

//offset values from Levels page - add to these amps
//subtract 50 from these levels when you apply them
float gLnInLv = 50;
uint8_t gLnInLvPrev = 50;
float gMicInLv = 50;
uint8_t gMicInLvPrev = 50;
float gLnOutLv = 50.0;   //output bias - add to volumne or tx gain
uint8_t gLnOutLvPrev = 50;
float gUSBInLv = 50.0;   //USB Out amp offset from Levels page
uint8_t gUSBInLvPrev = 50;
float gUSBOutLv = 50.0;   //USB Out amp offset from Levels page
uint8_t gUSBOutLvPrev = 50;
float gFFTLv = 50.0;   //FFT level- add to FFT gain from HMI
uint8_t gFFTLvPrev = 50;


float gFFTGain = 10; //use to adjust gain of fft amp  - 1 to 100
float gFFTGainPrev = 10;
float gFFTFreq = 700; //fft detect freq
float gFFTFreqPrev = gFFTFreq; 

float gVolGain = 10; //use volGainU and volGainD to adjust gain of output amp
float gVolGainPrev = 10; //detect change of value

int gSqGain = 1; //use sqGainU and sqGainD to adjust gain of rx vox
int gSqGainPrev = 1; //detect change of value


//values for tx parametric equalizer - see https://wiki.uiowa.edu/display/teensymacos/Audio+Processing+on+the+Teensy for info
const uint32_t dspQ_UNIT = 524288;
const int dspF_S = 44100;
int dspFilterParams[5];


//HMI Options ************************************************************************************************************************

String gMyCall = ""; //read from config page

uint32_t gPCRStat = 0; //used for PCR status
uint32_t gPCRCtrl = 0; //used for PCR controls

uint8_t gWDog = 0; //sent to 1 when we get gSize and gRadioSel from him - this starts initial load process - toggle between 1 and 2 every update of Home page - if hmi doesn't see the change it raises a comm fail warning

uint8_t gAnt = 1; //binary of ant switch bits
uint8_t gAntPrev = 1;
bool gAntMode = false; //if true=multiple antennas
bool gAntModePrev = false;
uint8_t antSaveTag = 0; //if !=0, download and save edited tag on Ant page
uint8_t gAntBand = 0xff; //this is used to indiate which band is selecting on the ant page - if 0xff, use selected ant for all bands
uint8_t gAntBandPrev = 0xff;

uint8_t gRadio = RADIO_TYPE_NONE; //index of selected radio - from radioList[]
uint8_t gRadioPrev = gRadio; //tracks change of state

uint8_t gRadioSel = 0xfe; //default to no radio so we load selected radio on startup
uint8_t gRadioSelPrev = 0xff; //this will allow LoadRadio() to load on startup

volatile uint32_t gFreqRadio = 0; //freq to/from radio
uint32_t gFreqRadioPrev = 0; //previous freq before change - use to track notch filter if it's on

uint32_t gVFOA = 0;//holds vfo settings
uint32_t gVFOB = 0;
uint8_t gSplit = 0; //vfo mode, 0=vfoA, 1=vfoB, 2=split, rx on vfoA, tx on vfoB
String bPwr = "Pwr"; //power setting for log

//uint32_t gFreqHMI = 0; //freq to/from hmi

uint32_t gUnit = 1000; //highlighted digit on display used for freq step with encoder and digits on display
uint32_t gUnitPrev = gUnit; //tracks change to gUnit

uint8_t gRMode = 0; //radio mode, 0=cw, 1=cw_r, 2=lsb, 3=usb, 4=fmn, 5=fmw, 6=am, 7=digL, 8=digH
uint8_t gRModePrev = 0; //holds previous radio mode from radio - update HMI if != gRMode
uint8_t gOMode = 0; //operation mode, 0=cw, 1=voice, 2=rtty, 3=Dig, 4=Beacon
uint8_t gOModePrev = 0; //triggers update on Op Mode change

uint8_t gComMode = COM_MODE_DEBUG; //mode of USB com port - NONE, CAT, or TERMinal

uint8_t gSvRadio = 0; //=1 if any value in hmi changes that needs to be save to the radio file

uint8_t gBand = 0; //load new band freq if this changes
uint8_t gBandPrev = 0;

volatile uint8_t gEncoder = 0; //selects encoder function - based on page -
uint8_t gEncoderPrev = 0; //use to detect gEncoder change if current state != new state
bool gEncoderChng = false; //goes true when encoder changes - calls Chk4HMIChng()

//gopbal tx level, filter & notch variables
volatile uint8_t gTxLev = 50; //global line out level - loaded by the HMI for the  current OMode 
uint8_t gTxLevPrev = gTxLev; //track change
volatile uint8_t gLPFltr = 32; //global low pass filter /100 - send to active mode page freq slider
uint8_t gLPFltrPrev = gLPFltr; //track change
volatile uint8_t gNFltr = 32; //global notch filter /100 - send to active mode page notch slider
uint8_t gNFltrPrev = gNFltr;

//variables for voice page
//voice tx level, filter & notch variables for radio save/load
uint8_t vTxLev = 50; //global line out level - loaded by the HMI for the  current OMode 
uint8_t vTxLevPrev = 50;
uint8_t vLPFltr = 32; //global low pass filter /100 - send to active mode page freq slider
uint8_t vLPFltrPrev = 32;
uint8_t vNFltr = 32; //global notch filter /100 - send to active mode page notch slider
uint8_t vNFltrPrev = 32;


bool gTxComp = false; //hold tx compressor switch status from Voice page
bool gEQSel = true; //holds the state of btEQEn - false=rx, true=tx encoder selected 
bool gTxEQ = false; //tx equalizer enabled state
bool gTxEQPrev = false;
uint8_t gTx0 = 10; //voice tx equalizer settings - mid scale
uint8_t gTx0Prev = 10;
uint8_t gTx1 = 10;
uint8_t gTx1Prev = 10;
uint8_t gTx2 = 10;
uint8_t gTx2Prev = 10;
uint8_t gTx3 = 10;
uint8_t gTx3Prev = 10;
uint8_t gTx4 = 10;
uint8_t gTx4Prev = 10;

bool gRxEQ = false; //rx equalizer enabled state
bool gRxEQPrev = false;
uint8_t gRx0 = 10; //voice tx equalizer settings - mid scale
uint8_t gRx0Prev = 10; 
uint8_t gRx1 = 10;
uint8_t gRx1Prev = 10;
uint8_t gRx2 = 10;
uint8_t gRx2Prev = 10;
uint8_t gRx3 = 10;
uint8_t gRx3Prev = 10;
uint8_t gRx4 = 10;
uint8_t gRx4Prev = 10;

//variables for CW Page
bool gDisLeft = false; //false=dah key (and Rmt PTT) is normal, true = dah key (and Rmt PTT) is straight key - allows straight key to be plugged into Rmt PTT and rapid switching between keyer and straight key (Iambic and Ultimatice become Bugs if this is true)
volatile uint8_t cTxSpeed = 15; //wpm from CW page
uint8_t cTxSpeedPrev = cTxSpeed; //to detect change
volatile uint8_t cFarnSp = cTxSpeed; //farnsworth spacing from CW page
uint8_t cFarnSpPrev = cTxSpeed;
volatile uint8_t cLPFltr = 32; //cw low pass filter /100 
uint8_t cLPFltrPrev = 32;
volatile uint8_t cNFltr = 32; //cw notch filter /100 
uint8_t cNFltrPrev = 32;

//variables for RTTY page
volatile uint8_t gRtyFrq = 0; //default 2125 mark freq 
uint8_t gRtyFrqPrev = 0;
volatile uint8_t gRtySft = 0; //0=170 hz, 1=225 hz, 2=425 hz, 3=450 hz, 4= 850 hz
uint8_t gRtySftPrev = 0;
volatile uint8_t gRtyStp = 1; //0=1 stop bit, 1=1.5 stop bits, 2=2 stop bits
uint8_t gRtyStpPrev = 1;
volatile uint8_t gRtyBaud = 0; //0=45.45, 1=50, 2=75, 3=100 baud
uint8_t gRtyBaudPrev = 0;
volatile uint8_t rTxLev = 50; //rtty line out level 
uint8_t rTxLevPrev = 50;
volatile uint8_t rLPFltr = 32; //rtty low pass filter /100 
uint8_t rLPFltrPrev = 32;
volatile uint8_t rNFltr = 32; //rtty notch filter /100 
uint8_t rNFltrPrev = 32;

//variables for Dig page
bool gDigRxPath = DIG_RX_USB; //0=usb, 1=headphones
bool gDigRxPathPrev = DIG_RX_USB;
bool gDigTxPath = DIG_TX_USB; //0=usb, 1=mic
bool gDigTxPathPrev = DIG_TX_USB;
volatile uint8_t gDigVoxLev = 0; // value of vox threshold slider - used to calc gDigVoxThresh
uint8_t gDigVoxLevPrev = 0; //detect change
volatile uint16_t gDigVoxThresh = 0; //adjust when gDigVoxLev changes - compare value of Vox_Det * 10000
bool gDigVoxKeyed = false; //goes true when radio keyed by vox
uint8_t gDigTxActiv = DIG_ACT_NOTHING; //what to do when tx audio treshold is reached, 0=do nothing, 1=send audio to radio, 2=key ptt
volatile uint8_t dTxLev = 50; //Dig line out level 
uint8_t dTxLevPrev = gTxLev; //track change

//variables for Log page
uint16_t gCtstCtr = 1; //inc each time we save a log entry
uint16_t gCtstCtrPrev = 1; //for change detect
bool gLogMode = 0; //0=normal, 1=contest
uint16_t gLogNumEntries = 0; //holds total # of log entries in LOG.TXT file

//variables for Config page
uint8_t gWiFi = 0; //0=off, 1=active
uint8_t gWiFiPrev = 0; //detect change
uint8_t gIPMode = 0; //0=station, 1=ap
uint8_t gIPModePrev = 0;
String gWiFiChan = "0"; //holds channel ESP server is using
String gAPName = ""; //loaded from config page
String gAPKey = ""; //ap passkey
uint8_t gAPChan = 6; //ap channel
String gSSID = ""; //SSID
String gStaKey = ""; //wifi passkey
String gStaAdrs = ""; //station wifi address
String gSubnet = "255.255.255.0"; //station sub net
String gGW = ""; //station gateway address
bool gFFTAvg = 1; //average FFT values if true
bool gMon = false; //click btMonTx to enable monitoring of USB Tx or Rx in headphones
bool gMonPrev = false;
bool gDigProc = false; //goes true if user want to apply filtering to Dig audio
bool gDigProcPrev = false;
bool gVocal = false; //goes true when user clicks on Announce btn in Config page 
volatile uint16_t hmiAnnounce = VOICE_SAY_None; //>0 starts announcement of specific values, byte0=Say_Freq, byte1=Say_gRMode, byte2=Say_gOMode, 

//flex radio variables
String gFlexIP = "";
uint8_t gFlexPO = 100; //power out - also put in bPwr for log
uint8_t gFlexPOPrev = 100; //change detect
uint8_t gFlexTO = 10; //tune power
uint8_t gFlexTOPrev = 10;
uint8_t gFlexLO = 20; //lineout
uint8_t gFlexLOPrev = gFlexLO;
uint8_t gFlexWNB = 0; //msb is enabled flag on these
uint8_t gFlexWNBPrev = 0;
uint8_t gFlexNB = 0;
uint8_t gFlexNBPrev = 0;
uint8_t gFlexNR = 0;
uint8_t gFlexNRPrev = 0;
uint8_t gFlexAF = 0; //used for both auto peaking and auto notch filter
uint8_t gFlexAFPrev = 0;
uint8_t gFlexAnt = 1;
bool gFlexCon = false; //goes true if we're connected to flex wifi
uint16_t gFlexCmdNum = 0;//incrementing command # for flex commands
uint32_t gFlexPingTmr = millis(); //ping every 2 seconds to keep connection alive
uint32_t gFlexLastReply = 0; //holds time of last flex reply - if >10 seconds, show radio failed off
							 
//require two presses of Delete Log btn to clear log
static bool gDelLogClick = false;
static uint32_t gDelLogTimer = 0; //second click must be within 5 seconds of first

//varibles for radio mode

uint8_t gTxMode = RADIO_TX_OFF; //goes to 1 when Home.btEnabTx is pressed - enables tx output, set to 2 when txing
uint8_t gTxModeSet2 = RADIO_TX_OFF; //mode to set gTxMode to - from program

bool gPlay = false; //goes true when Home.btPlay is pressed - enables tx buffer
bool gPlayPrev = false; //track change

bool gShareDB = false; //mirrors gShareDB - if true, don't index the freq, tx, or band databases for each radio, use a common db for all radios
bool gShareDBPrev = false;// change detect

bool gLock = false; //status of Home.btLock btn - ignore freq changes when true - keeps radio on locked freq

uint8_t radioOnline = 0; //after 3 radio comm fails, post alert in tInfo1 and 2
uint8_t gIcmAdr = 0x0; //if Icom is selected, try broadcast address - if that doesn't work poll radio for freq using incrementing addresses until it answers back - put adrs in label - no broadcast command I know of
uint8_t radioRxBytes = 0; //holds # of bytes we're waiting for from radio
bool radioCommBusy = false; //goes true when any routine is tx or rx to radio - blocks ISR from overwriting comm

uint8_t gRadioSelNum = 0xff; //Radio.gSelNum.val - if < 16 update radioTag[gSelNum] and save 
String gSelTxt = ""; //label text to save
uint8_t gRadioPopup = 0; //if gPopup on Radio page is >0 block label updates - they overwrite the popup window
uint8_t gRadioChange = 0; //if = 0xff, erase radio when returing to home page from radio page. If 1 to 16, copy selected radio's settings to radio # in gRadioChange


//Keyer Options **************************************************************************************************************************

/* Keyer Mode Descriptions
 See https://ag6qr.net/index.php/keys-bugs-paddles-and-keyers-a-terminology-introduction/ for description of modes
 0= Stright: Connect manual key to tip of paddle (PDL_LEFT) - no keyer action, just pass PDL_LEFT to KEY_OUT
 1= Iambic A: Squeezing both paddles causes alternating dit-dah-dit-dah or dah-dit-dah-dit depending on which paddle was pressed first - sequence ends as soon as both paddles open
 2= Iambic B: Same as A but send one additional element after both paddles released
 3= Ultimatic: Second paddle pressed has priority - press dit first and dits are generated. Press dah while holding dit and dahs are generated
 4= Bug: Auto generate dits only - manual dahs
*/

int keyerDitDur = 0; //updated from gStat3
int keyerDitFarnsDur = 0; //duration of keyer space based on farnsworth spacing

uint8_t cKeyrMod = KEYER_NONE; //mode 0=none, 1=straight, 2=Passthru, 3=Iambic A, 4=Iambic B, 5=Ultimatic, 6=bug 
uint8_t cKeyrModPrev = cKeyrMod; //tracks changes
uint8_t cSideTn = 15; //CW.cSideTn = sidetone level - 0=off, 1 to 30 level
uint8_t cSideTnPrev = 15; 

bool btPaddle = false; //dit on left, dah on right. If true, dah on left, dit on right
bool btTuneTx = false; //goes true if btTuneTx.val=1 - keys tx if Tx enabled

//variables for Audio page
uint8_t gAudioMode = 0; //see AUDIO_xxx enumeration above
uint8_t gAudioRecGain = 0; //0 to 100% - from Audio.hMicGain
uint8_t gAudioVMsg = 0; // message # to record/playback - range 1 to 10
bool gAudioRecBtn = false; //track position of audio record/playback/start buttons on Audio page
bool gAudioPlayBtn = false;
bool gAudioStartBtn = false;
uint8_t gAudioRecSrc = AUDIO_SRC_MIC; //0=record from mic, 1=record from line-in (rx audio)
bool gAudioStartBtnPrev = false; //to detect start cos
bool gAudioRecRx = false; //goes true when recording rx to SD
uint32_t recBytesSaved = 0; //used for playSdWav object to track # of bytes saved to file so header can be created


//Timers *********************************************************************************************************************************

const uint32_t hmiMsgTimeoutDefault = 20; //give it 20 mS of intercharacter space to time out
uint32_t hmiMsgTimeout = 0; //timeout for hmi msg

const uint32_t hmiUpdateTimerDefault = 150; //update radio every poll, display every 3 polls (450 mS) 

//not used, just update fft any time fft data is available
const uint32_t hmiFFTUpdateDefault = 300; //update fft 
uint32_t hmiFFTUpdate = 0;

const uint32_t hmiFFTMarkerUpdateTimerDefault = 3000; //update fft graph markers every 3 sec
uint32_t hmiFFTMarkerUpdate = 0;

uint32_t radioMsgTimeoutDefault = 150; //timeout for rx msg from radio - adjust for each radio based on baud rate & # of chrs

const uint32_t hmiReplyTmrDefault = 100; //hmi reply window

const uint32_t hmiEncoderTimeoutDefault = 5000; //time out encoder select after 5 seconds of inactivity
uint32_t hmiEncoderTimeout = millis(); //tracks amount of time the encoder is selected - reset encoder selection after inactivity

const uint32_t hmiAutoLogUpdateDefault = 10000; //update AutoLog page every 10 seconds
uint32_t hmiAutoLogUpdate = millis() - hmiAutoLogUpdateDefault;

static uint8_t saveRadioCntr = 0; // counts # of polls after gSvRadio goes true - save radio data after 75 counts (approx 60 seconds)
static uint8_t savePrevCntr = 0; // save prev freq & modes every 10 seconds when they change

const unsigned long voxHoldTimeDefault = 750; //hold vox for 3/4 sec after not audio detected on Vox_Det
unsigned long voxHoldTime = millis();

const unsigned long pttWatchDogDefault = 180000; // 3 minute timeout
unsigned long pttWatchDog = millis();

uint32_t lastRxAudioUpdate = millis(); //used to time rx audio update frequency in ChkRxSq()

//Misc ***********************************************************************************************************************************

uint8_t decodeMode = 0; //cw=0, rtty=1, dig=2

//Arrays **********************************************************************************************************************************

float fft2[1024]; //hold the second to last floating fft data for averaging - (fft2+fft1+fftCurrent)/3
float fft1[1024]; //hold the last floating fft data

//fft data is averaged and ramped between actual samples
//  for 3.5" fft (210 pixels) there is one sample and two ramped samples
//  for 5" fft (350 pixels) there is one sample and four ramped samples
uint8_t fftWave0[80]; //holds 'real' fft data for first pixel in waveform
uint8_t fftWave1[80]; //holds first rampped pixel fft data - 1/3 of the way between the last real pixel and the next one to smooth the squares
uint8_t fftWave2[80]; //holds second rampped pixel fft data - 2/3 of the way between the last real pixel and the next one to smooth the squares
uint8_t fftWave3[80]; //holds third rampped pixel fft data - 2/3 of the way between the last real pixel and the next one to smooth the squares
uint8_t fftWave4[80]; //holds second rampped pixel fft data - 2/3 of the way between the last real pixel and the next one to smooth the squares
uint8_t fftFinal[350]; //20 bytes larger than we need to hold final compiled data - max size of 5" display fft is 350 pixels, so 5x the 70 points sampled - helps to make sure we get out of transparent mode

const int hmiBufMax = 255;
byte hmiTx[hmiBufMax]; //tx buffer for hmi msg
byte hmiRx[hmiBufMax];

int hmi_rxM_ptr = 0; //points to active rxMsgT[] string taking new chars from decoder for RxMsg page
String hmi_rxM[11] = { "","","","","","","","","","","" }; //holds rx data for RxMsg fields - indexted by 

const int radioRxBufMax = 100;
char radioRx[radioRxBufMax]; //radio rx buffer

const int radioTypeMax = 12;
//these are enumerated above
String radioType[radioTypeMax] = { "None", "Flex", "PCR1000", "Icom", "Kenwood1", "Kenwood2", "Yaesu FTdx", "Yaesu 100", "Yaesu 757", "Yaesu 8x7", "Yaesu 890", "Yaesu 1000" };
//baud rates for selected radio
int radioBaud[radioTypeMax] = { 0, 0, 9600, 19200, 9600, 4800, 38400, 38400, 4800, 38400, 38400, 38400 };


String radioRMd[9] = { "CW","CWr", "LSB", "USB","FMn","FMw","AM","DigL","DigH" };
String radioOMd[5] = { "CW", "Voice","RTTY","Dig","Bcon" }; 

//shorter terms for FreqMem grid
//NOTE: If changing any of these, update Keypad Preinitialization and Keypad.bOK for func.val 5 or 6
String radioRMdShort[9] = { "CW", "CWr", "LSB", "USB", "FMn", "FMw", "AM", "DgL", "DgH" };
String radioOMdShort[5] = { "CW", "Voc", "RTY", "Dig","Bcn" };

String radioTag[24] = { "-- 1 --", "-- 2 --", "-- 3 --", "-- 4 --", "-- 5 --", "-- 6 --", "-- 7 --", "-- 8 --", "-- 9 --", "-- 10 --", "-- 11 --", "-- 12 --", "-- 13 --", "-- 14 --", "-- 15 --", "-- 16 --",
					   "-- 1 --", "-- 2 --", "-- 3 --", "-- 4 --", "-- 5 --", "-- 6 --", "-- 7 --", "-- 8 --" }; //holds 16 radio tags for Radio page and 8 antenna switch tags- save to each radio file

const int hmiTxMemMax = 40;
String hmiTxMem[hmiTxMemMax]; //10 records for cw, voice tags, rtty, and Rx>SD tags - to hold TxMem strings - saved to TXMEM.TXT

const int freqMemMax = 100;
//default values are loaded into 91-100 when creating a new file
String defaultFreqMemLabel[10] = {"20m beacon","17m beacon","15m beacon","12m beacon","10m beacon" };//default label
uint32_t defaultFreqMemFreq[10] = {14100000, 18110000,21150000,24930000,28200000};//arrays to hold default freq & RMode and OMode 
uint8_t defaultFreqMemRMode[10] = { 0,0,0,0,0,6,6,6,6,6 };
uint8_t	defaultFreqMemOMode[10] = { 4,4,4,4,4,1,1,1,1,1 };
//arrays for file
String freqMemLabel[freqMemMax];
uint32_t freqMemFreqA[freqMemMax]; //holds VFOA
uint32_t freqMemFreqB[freqMemMax]; //holds VFOB
uint8_t	freqMemOMode[freqMemMax];
uint8_t freqMemRMode[freqMemMax];
uint8_t freqMemTxLev[freqMemMax];
uint8_t freqMemLPFltr[freqMemMax];
uint8_t freqMemNFltr[freqMemMax];
uint8_t freqMemSplit[freqMemMax]; //0= use VFOA, 1=use VFOB, 2=split mode (Rx VFOA, Tx VFOB)

//array to hold temporary data from Edit page when editing values
String editPgTxt[8] = { "", "", "", "", "", "" , "", ""};
uint8_t editPgSplit = 0; //status of bt5 on Edit page


//initial seeting for BANDLIST.CSV
const int bandMemMax = 16; //memories for each band - load them into current VFO when changing bands
String bandMemLabel[bandMemMax] = { "160m","80m","60m","40m","30m","20m","17m","15m","12m","10m","6m","2m","1.25m","70cm","33cm","Gen" };
uint32_t defaultMemFreq[bandMemMax] = { 1850000,3550000,5330500,7100000, 10125000, 14100000,18110000,21150000,24930000,28200000,50100000,144500000,223000000,421000000,903000000, 9500000 };//arrays to hold saved freq & RMode and OMode 
uint32_t bandMemFreq[bandMemMax]; //loaded with values from BANDLIST.CSV file, or default if that file doesn't exist
uint8_t bandMemRMode[bandMemMax] = { 2,2,3,2,2,3,3,3,3,3,3,4,4,4,4,6 };
uint8_t	bandMemOMode[bandMemMax] = { 0,0,0,0,0,0,0,0,0,0,0,1,1,1,1,1 };
uint8_t bandMemTxLev[bandMemMax] = {50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50 };
uint8_t bandMemLPFltr[bandMemMax] = {32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32 };
uint8_t bandMemNFltr[bandMemMax] = { 32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32 };
uint8_t bandMemAnt[bandMemMax] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }; //holds ant selection byte for each band, 0xff uses one ant for all bands

uint32_t lastStableFreq = 0; //holds last stable freq of radio - must change and be stable for 10 seconds before it's added to prevFreq[]
uint8_t lastStableRMode = 255; //holds last stable RMode - same as lastStableFreq
uint8_t lastStableOMode = 255; //holds last stable OMode - same as lastStableFreq
uint32_t prevFreq[11]; //arrays to hold last 10 frequency/mode sets
uint8_t prevRMode[11];
uint8_t prevOMode[11];

const uint8_t pcCmdRxLen = 75;
uint8_t pcCmdRx[pcCmdRxLen]; //buffer for receiving commands on Serial (USB port) from PC - read/set freq and mode on HMI from PC program, keyboard control in terminal mode

String espRx = "";

String beaconList[18] = { "UN-NYC[4U1UN]", "Canada[VE8AT]", "Calif[W6WX]", "Hawaii[KH6RS]", "New Zealand[ZL6B]", "Australia[VK6RBP]", "Japan[JA2IGY]", "Siberia[RR9O]", "Hong Kong[VR2B]", "Sri Lanka[4S7B]", "South Africa[ZS6DN]", "Kenya[5Z4B]", "Israel[4X6TU]", "Finland[OH2B]", "Madeira[CS3B]", "Argentina[LU4AA]", "Peru[OA4B]", "Venezuela[YV5B]" };

String logADI[11]; //holds log txt from SaveLog btns
String logTxt[11]; //holds the raw log txt for the CTR2_LOG.TXT file - use in the Log page

int keyerQue[22] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }; //keyer sequence array - each element holds the time counter for that element - if positive, key down, if negative, key up (space) - dec until [0] gets to 0 then shift down one

const int logListMax = 200; //max # of entries to load
const int logListMaxLen = 63; //maxlen of log entry + null
char logList[logListMax][logListMaxLen];

#define NUM_DECODE_ELEMENTS 14
char codeBuff[NUM_DECODE_ELEMENTS];

//RTTY Arrays ********************************************************************************************************************
//arrays for RTTY mode - matches RTTY_ enumeration
float rttyFreq[2] = { 2125.0, 2295.0 };
float rttyBaud[4] = { 22.0, 20.0, 13.33, 10 }; //mS per bit for 45.45, 50, 75, and 100 baud
float rttyShift[5] = { 170.0, 225.0, 425.0, 450.0, 850.0 };
float rttyStop[3] = { 1.0, 1.5, 2.0 };

//values for RTTY_KEY amplitude to cause correct freq shift
//the first four values are for a 2125 hz cxr, the last for are for a 2295 hz cxr
float rttyFreqShift[5] = { .08, .1059, .2, .2118, .40 }; //these are keying levels for RTTY_KEY - they give the correct offset freq for 170, 225, 425, 450, and 850 hz

//rtty character tables - see https://en.wikipedia.org/wiki/Baudot_code
//figures have 0x20 added to code
//Note: Use '<' for LF, '~' for bell, '|' for CR, '^' for Figure set, and '_' for letter set
//Note: Can't use ` for chr because I use that in the hmi Tx routine to denote quotes for .txt variables
char rttyChr[65] = { 0, 'E', '<', 'A', ' ', 'S', 'I', 'U', '|', 'D', 'R', 'J', 'N', 'F', 'C', 'K', 'T', 'Z', 'L', 'W', 'H', 'Y', 'P', 'Q', 'O', 'B', 'G', '^', 'M', 'X', 'V', '_',
					 0, '3', '<', '-', ' ', '~', '8', '7', '|', '$', '4', '\'', ',', '!', ':', '(', '5', '"', ')', '2', '#', '6', '0', '1', '9', '?', '&', '^', '.', '/', ';', '_', 0};

bool rttyTxBusy = false; //goes true while transmitting rtty chr
char rttyTxChr = 0; //holds RTTY chr from hmi bTx buffer to tx using rtty

//PCR1000 Rx support ********************************************************************************************************************
//variables for PCR1000 radio support
//these are only collected when we're on the PCR page
uint8_t gPCREncoderChng = false; //holds encoder # that changed value
bool gPCRInit = false; // goes true after PCR1000 has been initialized the first time
bool gPRCPwrBtn = false; //follows gPwrBtn on PCR1000 page
bool gPCRAGC = false;
bool gPCRAtten = false;
bool gPCRNBlank = false;
bool gPCRDSP = false;
bool gPCRANch = false; //auto notch
bool gPCRHasDSP = false; //turn on if we get a GD01 from the GD? request
uint8_t gPCRBW = 0; //0=3k, 1=6k, 2=15k, 3=50k, 4=230k - hmi decodes this and displays on PCR.tBW.txt
uint8_t gPCRBWPrev = 0;
uint8_t gPCRVol = 20; //pcr volume - 0 to 0xff
uint8_t gPCRVolPrev = 20;
uint8_t gPCRSq = 20; //pcr squelch, same scaling as pcrVol
uint8_t gPCRSqPrev = 20;
uint8_t gPCRIF = 0x80; //pcr IF shift, 0x80 is center
uint8_t gPCRIFPrev = 0x80;
uint8_t gPCRDSPNR = 0; //pcr DSP noise reduction, 0 to 15
uint8_t gPCRDSPNRPrev = 0;

//ISR **********************************************************************************************************************************

//variables passed from DecodeMorse ISR

bool blockISR = false; //when true, ignore ISR (loading or saving files, recording or playing back audio files)
volatile uint8_t decodeWPM;
volatile uint8_t chr2HMICtr = 0; //counts # of elements in ch2HMI buffer
volatile char chr2HMI[32] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 }; //fifo buffer for decoded chrs from ChkDecode irq service routine
const float gMorseDetLev = .05; //adjust this level to make the Morse decoder more or less sensitive - .03 is minimum, .04 sets it to decode above the bottom gradical on the fft display

IntervalTimer decoderUpdateTmr; //called every 2 mS to time demodulators

IntervalTimer recordUpdateTmr; //called every 10 mS to update SD file if recording

//variable passed from KeyboardPress_ISR
volatile int keyboardChr;

//SD Card ******************************************************************************************************************************

File myFile;

//USB Host Port ************************************************************************************************************************
// see library examples - https://github.com/PaulStoffregen/USBHost_t36/blob/master/examples/USBHost_viewer/USBHost_viewer.ino#L79

USBHost myUsb;
USBHub hub1(myUsb);
USBHub hub2(myUsb);
USBHub hub3(myUsb);
KeyboardController keyboard1(myUsb);
KeyboardController keyboard2(myUsb);
USBHIDParser hid1(myUsb);
//USBHIDParser hid2(myUsb);
MouseController mouse(myUsb);

USBDriver *drivers[] = { &keyboard1, &keyboard2, &hid1 }; // , &hid2 };
#define CNT_DEVICES (sizeof(drivers)/sizeof(drivers[0]))

USBHIDInput *hiddrivers[] = {  &mouse };

//#define CNT_HIDDEVICES (sizeof(hiddrivers)/sizeof(hiddrivers[0]))
//const char * hid_driver_names[CNT_HIDDEVICES] = { "mouse" };
//bool driver_active[CNT_DEVICES] = { false, false, false }; // , false };

/*
BTHIDInput *bthiddrivers[] = { &mouse };
#define CNT_BTHIDDEVICES (sizeof(bthiddrivers)/sizeof(bthiddrivers[0]))
const char * bthid_driver_names[CNT_HIDDEVICES] = { "mouse" };
bool bthid_driver_active[CNT_HIDDEVICES] = { false };
*/

//WiFi Server =============================================================
	WiFiServer server(80);
	WiFiClient client; //make it global
	WiFiClient flexAPI; //use for flex


void SerialOut(String txt, bool lfcr)
{
	//if enabSerialOut is defined, send txt to Serial.print/println - use to turn off serial output to free port for external programs to use
	if (gComMode)
	{
		//Serial is being used as a virtual comm port by another app - there messages will interfere with that traffic
		return;
	}
#ifdef enabSerialOut
	if (!lfcr)
	{
		Serial.print(txt);
	}
	else
	{
		Serial.println(txt);
	}
#endif
}






void PrintHmiErrMsg()
{
	//hmiRx buffer is 1s based
	String txt = "";
	//print msg from HMI - ignore msg 1, command successful
	hmiInitialized = true;//first message is error 0x00 - allow other commands
	hmiNewMsg = 0;

	switch (hmiRx[1])
	{
	case 0x01:
		//successful reply
		txt = "--> Successful reply";
		return;
		break;
	case 0x02:
		txt = "--> Invalid Component ID";
		break;
	case 0x1b:
		txt = "--> Invalid variable";
		break;
	case 0x1c:
		txt = "--> Failed to assign attribute";
		break;
	case 0x1a:
		txt = "--> Invalid variable name or attibute";
		break;
	case 0x1e:
		txt = "--> Invalid number of parameters";
		break;
	case 0x23:
		txt = "--> Variable name too long";
		break;
	case 0x24:
		txt = "--> Serial Buffer Overflow";
		break;
	case 0x86:
		txt = "--> HMI has entered SLEEP mode - touch screen to wake up";
		break;
	case 0x87:
		txt = "--> HMI has returned from SLEEP mode";
		break;
	case 0x88:
		txt = "--> Nextion is powered up and ready to go...";
		break;
	case 0xfd:
		//transparent mode complete				
		hmiTransparentMode = 0xfd;		
		break;
	case 0xfe:
		//transparent mode started
		hmiTransparentMode = 0xfe;		
		break;
	default:
		txt = "--> Err " + String(hmiRx[1], HEX) + ": Last HMI Cmd=" + String(hmiWait4Reply) + " - See Nextion Instruction Set Section 7 for error description";
		break;
	}
#ifdef PRINT_ERRORS
	if (txt.length() > 0)
	{
		SerialOut(txt, true);
	}
#endif // PRINT_ERRORS
	
}








// END OF CODE BASE - LEAVE SETUP AT END OF CODE

