#!/usr/bin/python3
#
#
#
#  Program to test the LED's and Switches
# on the pi oven controller
#
#
# Jim Koehler, Comox, BC, January, 2018
#
###############################################

import RPi.GPIO as GPIO
import time

fan = 23
ON_led = 24
OFF_led = 5
ready = 6
start_sw = 17
stop_sw = 27
halt_sw = 22

def init_gpio():
    GPIO.setmode(GPIO.BCM)
    GPIO.setup(fan,GPIO.OUT) 
    GPIO.setup(ON_led,GPIO.OUT) 
    GPIO.setup(OFF_led,GPIO.OUT) 
    GPIO.setup(ready,GPIO.OUT) 
    GPIO.setup(start_sw, GPIO.IN, pull_up_down = GPIO.PUD_UP) 
    GPIO.setup(stop_sw, GPIO.IN, pull_up_down = GPIO.PUD_UP) 
    GPIO.setup(halt_sw, GPIO.IN, pull_up_down = GPIO.PUD_UP) 

def fan_on():
    GPIO.output(fan, True)
    
def fan_off():
    GPIO.output(fan, False)
    
def on_led_on():
    GPIO.output(ON_led, True)
    
def on_led_off():
    GPIO.output(ON_led, False)
    
def off_led_on():
    GPIO.output(OFF_led, True)
    
def off_led_off():
    GPIO.output(OFF_led, False)
    
def ready_on():
    GPIO.output(ready, True)
    
def ready_off():
    GPIO.output(ready, False)

def start_pressed():
    if (GPIO.input(start_sw) == False):
        return(True)
    else: return(False)
    
def stop_pressed():
    if (GPIO.input(stop_sw) == False):
        return(True)
    else: return(False)
    
def halt_pressed():
    if (GPIO.input(halt_sw) == False):
        return(True)
    else: return(False)
    

if __name__ == "__main__":

    init_gpio()    
#
#
#

    while True:
        if start_pressed():
            on_led_on()
        else: on_led_off()
    
        if stop_pressed():
            off_led_on()
        else: off_led_off()

        if halt_pressed():
            fan_on()
        else: fan_off()
    
        if (start_pressed() and stop_pressed()): break
        
   
    GPIO.cleanup()
