/******************************************************************************
 *
 * Default Linker Command file for the Texas Instruments TM4C1294NCPDT
 *
 * This is derived from revision 11167 of the TivaWare Library.
 *
 *****************************************************************************/

--retain=g_pfnVectors

// app::

#define APP_BASE_ADDRESS    0x00000000  // app base
#define APP_FLASH_ADDRESS    0x00000080	// rest of bootloader

#define RAM_BASE            0x20000000

MEMORY
{
    FLASH_VEC       (RX): origin = APP_BASE_ADDRESS,    length = 0x00000070 // 520B   Read, Execute
    FLASH           (RX): origin = APP_FLASH_ADDRESS,   length = 0x000BFF80 // 768K-0x210

    SRAM            (RWX):origin = RAM_BASE,            length = 0x00040000
}

/* The following command line options are set as part of the CCS project.    */
/* If you are building using the command line, or for some reason want to    */
/* define them here, you can uncomment and modify these lines as needed.     */
/* If you are using CCS for building, it is probably better to make any such */
/* modifications in your CCS project and leave this file alone.              */
/*                                                                           */
/* --heap_size=0                                                             */
/* --stack_size=256                                                          */
/* --library=rtsv7M4_T_le_eabi.lib                                           */

/* Section allocation in memory */

SECTIONS
{
    .intvecs:   > FLASH_VEC
    .text   :   > FLASH
    .const  :   > FLASH
    .cinit  :   > FLASH
    .pinit  :   > FLASH
    .init_array : > FLASH

    .vtable :   > RAM_BASE
    .data   :   > SRAM
    .bss    :   > SRAM
    .sysmem :   > SRAM
    .stack  :   > SRAM
}

__STACK_TOP = __stack + 512;
