/*  CCOR.C  */
#include<stdio.h>
#include"c:\turboc\ssb\ffts.c"   /*  laptop version  */
#include"c:\turboc\ssb\histr.c"  /*  laptop version  */
/*#define MAIN*/

void ccor(int n,float dat[],float w[],float xr[],float xi[])

/*  "Complex Correlation" t->f->t function             */

/*  int   n;             Must be a positive power of 2 */ 
/*  float dat[];         Input (time) waveform section */ 
/*  float w[];           Data Window (raised cosine)   */ 
/*  float xr[], xi[];    Real & Imag data vectors      */
{
   int idx;

/*  Windowed data -> real vector, zeros -> imag vector */
   for (idx = 0; idx < n; idx++)
   {
      xr[idx] = dat[idx]*w[idx];
      xi[idx] = 0.0;
   }
   fwfft(n,xr,xi);
/*  Now in scrambled-index frequency domain            */
/*  Form magnitudes at pos freqs, zeros elsewhere      */
/*  Scrambled pos freq <=> even-numbered index         */
   xr[0]=0.0; /* DC is still zero index when scrambled */
   xi[0]=0.0;
   xr[1]=0.0;
   xi[1]=0.0;
   for (idx = 2; idx < n; idx = idx + 2)
   {
      xr[idx]   = srss(xr[idx],xi[idx]);
      xi[idx]   = 0.0;
      xr[idx+1] = 0.0;
      xi[idx+1] = 0.0;
   }
   rvfft(n,xr,xi);
/*  Now xr & xi are "complex correlation"  */
}

#ifdef MAIN
int main()

/*  Timing test of complex correlation plus mistuning estimator.  */

{
   int n, idx, jdx, iter, niter;
   float pi=3.14159265358979, smprt=6400., peak, pitch, mstn;
   static float dat[2048], w[2048], xr[2048], xi[2048];
   
   for(idx=0;idx<2048;idx=idx+32)
   {
      for(jdx=0;jdx<32;jdx++)
	 dat[idx+jdx]=15-jdx;
   }
   n=1;
   while(n>0)
   {
      printf("\n  Enter fft size.  ");
      scanf("%d",&n);
      for(idx=0;idx<n;idx++)
	 w[idx]=1.-cos((2.*pi*idx)/n);
      printf("  Enter num ccor & est its.  ");
      scanf("%d",&niter);
      for(iter=0;iter<niter;iter++)
      {
	 ccor(n,dat,w,xr,xi);
	 est(n,xr,xi,smprt,&peak,&pitch,&mstn);
      }
      printf("  Done.");
      printf("\n  Pitch %4.4f, mistun %4.4f",pitch,mstn);
      printf("\n  Enter 0 to stop.");
      scanf("%d",&n);
   }
   return 0;
}
#endif
