.MODULE/RAM  Sin_Approximation;
{----------------------------------------------------------------------------}
{  Adapted from Analog Devices Handbook by Adrian Nash, G4ZHZ. 		     }
{  Further modified for ASP by Johan B. Forrer                               }
{									     }
{  Sine approximation y=sin(x) using fifth order Taylor series.		     }
{  Input:   ax0=x in scaled 1.15 format					     }
{  Output:  ar=y in 1.15 format.					     }
{  Modifies l4,m4,i4,mr,ar,af,ay0,mx1,my1,mf,cntr,sr			     }
{  Computation time: 25 cycles.						     }
{----------------------------------------------------------------------------}
.ENTRY sin;

.VAR/PM sin_coeff[5];
.INIT24   sin_coeff: 
 0x324000, 
 0x005300, 
 0xAACC00, 
 0x08B700, 
 0x1CCE00;

sin:
    i4=^sin_coeff;             { Pointer to coeff buffer }
    l4=0;
    m4=1;
    ay0=h#4000;
    ar=ax0, af=ax0 and ay0;    { Check 2nd or 4th quadrant }
    if ne ar=-ax0;             { If yes, negate input }
    ay0=h#7FFF;
    ar=ar and ay0;             { Remove sign bit }
    my1=ar;
    mf=ar*my1(rnd), mx1=pm(i4,m4);      { MF=x^2 }
    mr=mx1*my1(ss), mx1=pm(i4,m4);      { MR=c1x }
    cntr=3;
    do approx until ce;
	    mr=mr+mx1*mf(ss);
approx:     mf=ar*mf(rnd), mx1=pm(i4,m4);
    mr=mr+mx1*mf(ss);
    sr=ashift mr1 by 2 (hi);
    sr= sr or lshift mr0 by 2 (lo);   { Convert to 2.14 format }
    ar=pass sr1;
    if lt ar=pass ay0;      { saturate if needed }
    af=pass ax0;
    if lt ar=-ar;            { negate output if needed }
    rts;

{----------------------------------------------------------------------------}
.ENDMOD;
