{----------------------------------------------------------------------------}
{ DSP.INC                                                                    }
{ Standard definitions for ADSP-2181 memory and control registers            }
{ Author: Johan B. Forrer                                                    }
{ Date: 4/11/96                                                              }
{ Comments: Derived from examples that came with EZDSP package               }
{----------------------------------------------------------------------------}

{Memory mapped control registers}
.const	IDMA_Control=		0x3fe0;
.const	BDMA_Int_Address=	0x3fe1;
.const	BDMA_Ext_Address=	0x3fe2;
.const	BDMA_Control=		0x3fe3;
.const	BDMA_Word_Count=	0x3fe4;
.const	PFLAG_Data=	  	0x3fe5;
.const	PFLAG_Control=		0x3fe6;
.const  SPORT1_Autobuf=         0x3fef;
.const  SPORT1_RFSDIV=          0x3ff0;
.const  SPORT1_SCLKDIV=         0x3ff1;
.const  SPORT1_Control_Reg=     0x3ff2;
.const  SPORT0_Autobuf=         0x3ff3;
.const  SPORT0_RFSDIV=          0x3ff4;
.const  SPORT0_SCLKDIV=         0x3ff5;
.const  SPORT0_Control_Reg=     0x3ff6;
.const  SPORT0_TX_Channels0=    0x3ff7;
.const  SPORT0_TX_Channels1=    0x3ff8;
.const  SPORT0_RX_Channels0=    0x3ff9;
.const  SPORT0_RX_Channels1=    0x3ffa;
.const  TSCALE=                 0x3ffb;
.const  TCOUNT=                 0x3ffc;
.const  TPERIOD=                0x3ffd;
.const  DM_Wait_Reg=            0x3ffe;
.const  System_Control_Reg=     0x3fff;

{Serial Port/AD1847 definitions}
.const  BFRSIZ=6;               {Size of DMA buffer}   
.const  CTLHI=0;                {Control register; high byte}
.const  CTLLO=1;                {Control register; low byte}
.const  LDACHI=2;               {Left Dac Hi byte}
.const  LDACLO=3;               {Left Dac Lo byte}
.const  RDACHI=4;               {Right Dac Hi byte}
.const  RDACLO=5;               {Right Dac Lo byte}
.const  STATHI=0;               {Status Reg Hi byte}
.const  STATLO=1;               {Status Reg Lo byte}
.const  LADCHI=2;               {Left Adc Hi byte}
.const  LADCLO=3;               {Left Adc Lo byte}
.const  RADCHI=4;               {Right Adc Hi byte}
.const  RADCLO=5;               {Right Adc Lo byte}

{AD1847 Register definitions}
{Control Register; 16 bit} 
.const  CLOR=0x8000;            {Clear overrange}
.const  MCE=0x4000;             {Mode Change enable}
.const  RREQ=0x2000;            {Read Request}

{Status Word; 16 bit}
.const  ID=0x0f00;              {Revision ID}
.const  INIT=0x01;              {Serial Init In Progress}
.const  ACI=0x02;               {Autocal In Progress}
.const  ORL=0x0c;               {Left Overrange Bits}
.const  ORR=0x30;               {Right Overrange Bits}

{Subsidiary Register Addresses}
.const  LICR=0x0000;            {Left Input Control Register}
.const  RICR=0x0100;            {Right Input Control Register}
.const  LA1CR=0x200;            {Left Aux 1 Control Register}
.const  RA1CR=0x300;            {Right Aux 1 Control Register}
.const  LA2CR=0x400;            {Left Aux 2 Control Register}
.const  RA2CR=0x500;            {Right Aux 2 Control Register}
.const  LDAC=0x600;             {Left DAC Control Register}
.const  RDAC=0x700;             {Right DAC Control Register}
.const  FMT=0x800;              {Data Format Register}
.const  ICR=0x900;              {Interface Control Register}
.const  PCR=0xa00;              {Pin Control Register}
.const  MIR=0xc00;              {Miscellaneous Info Register}
.const  MIX=0xd00;              {Digital Mix Control Register}
{Note: Addresses b, e-f are not used at this time}

{8 bit Registers}
{Input Control Register}
.const  LINE1=0x00;             {Line 1 Source Selected}
.const  LINE2=0x80;             {Line 2 Source Selected}
.const  AUX1=0x40;              {Aux 1 Source Selected}
.const  LINE1PM=0xc0;           {Line 1 Post-Mixed Source}
.const  ICGAIN=0xf;             {Gain: 0-22.5dB in 1.5dB steps}

{Auxiliary Input Control Register}
.const  AMUTE=0x80;             {Mute Bit}
.const  AIGAIN=0x1f;            {Gain Mask}

{DAC Control Register}
.const  DMUTE=0x80;             {Mute Bit}
.const  DAGAIN=0x3f;            {Gain Mask}

{Data Format Register}
.const  STEREO=0x10;            {1-Stereo; 0-Mono}
.const  F8BIT=0x00;             {8 bit linear mode}
.const  F16BIT=0x40;            {16 bit linear mode}
.const  FULAW=0x20;             {U law companded}
.const  FALAW=0x60;             {A law companded}

{Interface Control Register}
.const  PEN=0x01;               {Playback Enable}
.const  ACAL=0x80;              {AutoCal Enable}

{Pin Control Register}
.const  CLKTS=0x20;             {Clock Out Three State Enable}
.const  XCTL0=0x40;             {External Control 0}
.const  XCTL1=0x80;             {External Control 1}

{Miscellaneous Info Register}
.const  TSSEL=0x40;             {Tx Time Slot Select; 0-3,4,5; 1-0,1,2}
.const  FRS=0x80;               {Frame Size; 0-32; 1-16}

{Digital Mix Control Register}
.const  DME=0x01;               {Digital Mix Enable}
.const  DMGAIN=0xfc;            {Gain Mask}


.const	CFS=(0001-1)*2;
.const	CSL=(0001-1);
.const	ROM=0001;
{-------------END DSP.INC----------------------------------------------------}

