REM  DISHFD2.BAS  ver 1.0
REM
REM  QBasic program to calculate the efficiency of a parabola as a
REM  function of the feed amplitude characteristics and the f/d of
REM  the dish.          Bob Larkin, W7PUA     20 Dec 95

DIM FEED#(20), IFEED#(180), ETC#(17), ETAS#(17), ETAI#(17), C#(4, 5)
DIM IN1#(180), IN2#(180)
PI# = 3.14159265359#

REM Files should have 19 entries on separate lines.  The values should be
REM in dB attenuation relative to the peak gain of the feed.  Thus, there
REM should be a 0.0 entry somewhere and no entries should be negative.

INPUT "Input file name, including path and extension, for feed data"; NAMEF$
OPEN NAMEF$ FOR INPUT AS #1
FOR I% = 1 TO 19
   INPUT #1, FEED#(I%)
   FEED#(I%) = 10# ^ (-FEED#(I%) / 20#)    'Convert to Voltage magnitude
NEXT I%
FEED#(0) = FEED#(2)    'Provides symmetry at the axis for interpolation
FEED#(20) = FEED#(18)  'This does it at 180 degrees as well

REM Next interpolate 18 times by fitting a cubic through adjacent 4 points
REM and interpolating the polynomial at each degree.
FOR I% = 1 TO 18   'Over all 10 degree sectors
    REM For numerical accuracy, we will always consider angle as (-10, 20)
    FOR J% = 1 TO 4   'Over 4 data points, set up equations
        C#(J%, 1) = 1
        FOR K% = 2 TO 4  '3 coefficients per equation
            C#(J%, K%) = (10# * (J% - 2)) ^ (K% - 1)
        NEXT K%
        C#(J%, 5) = FEED#(I% + J% - 2)
    NEXT J%

    REM Now solve 4 equations for 4 coefficients
    FOR J% = 1 TO 4
        FOR L% = J% TO 4
            IF ABS(C#(L%, J%)) > 1E-10 THEN GOTO NONZ
        NEXT L%
NONZ:   FOR K% = 1 TO 5
            CT# = C#(J%, K%)
            C#(J%, K%) = C#(L%, K%)
            C#(L%, K%) = CT#
        NEXT K%
        CT# = 1# / C#(J%, J%)
        FOR K% = 1 TO 5
            C#(J%, K%) = CT# * C#(J%, K%)
        NEXT K%
        FOR L% = 1 TO 4
            IF L% = J% THEN GOTO LUP
            CT# = -C#(L%, J%)
            FOR K% = 1 TO 5
                C#(L%, K%) = C#(L%, K%) + CT# * C#(J%, K%)
            NEXT K%
LUP:    NEXT L%
    NEXT J%
    REM  Now interpolate to each degree point
    FOR J% = 0 TO 10
        AJ# = J%    'Evaluate the polynomial
        V# = C#(1, 5) + C#(2, 5) * AJ# + C#(3, 5) * AJ# ^ 2
        V# = V# + C#(4, 5) * AJ# ^ 3
        IFEED#(10 * (I% - 1) + J%) = V#   'Save in deg by deg vector
    NEXT J%
NEXT I%

DOINT:
REM  Now integrate the interpolated curves to find the antenna efficiencies
REM  Collect integrands, U*tan(theta/2) and U^2 * sin(theta) in IN1(), IN2().
REM  Note that integration period 1 is 0 to 1 degrees, centered on 0.5 deg.
DENOM# = 0#
FOR I% = 1 TO 180
    U# = .5 * (IFEED#(I% - 1) + IFEED#(I%))
    THETA# = PI# * (I% - .5) / 180#
    HTHETA# = .5 * THETA#
    IN1#(I%) = U# * TAN(HTHETA#)
    IN2#(I%) = U# * U# * SIN(THETA#)
    DENOM# = DENOM# + IN2#(I%)
NEXT I%
DENOM# = PI# * DENOM# / 180#   'Scale to be an area
PRINT
PRINT "I. eff = Illumination efficiency, S. eff = Spillover efficiency"
FOR TH1% = 5 TO 90 STEP 5
    NUM# = 0#
    FOR I% = 1 TO TH1%          'TH% is half angle subtended by dish
        NUM# = NUM# + IN1#(I%)
    NEXT I%
    NUM# = PI# * NUM# / 180#
    DENI# = 0#
    FOR I% = 1 TO TH1%
        DENI# = DENI# + IN2#(I%)
    NEXT I%
    DENI# = PI# * DENI# / 180#
    K# = 2# / ((TAN(PI# * TH1% / 360#)) ^ 2)
    FOD# = 1# / (4 * TAN(PI# * TH1% / 360#))
    ETA# = K# * NUM# * NUM# / DENOM#
    EI# = K# * NUM# * NUM# / DENI#
    ES# = ETA# / EI#
    PRINT USING "Half Angle=## deg, F/D=#.### "; TH1%; FOD#;
    PRINT USING "Feed=###.##dB  "; 8.68589 * LOG(IFEED#(TH1%));
    PRINT USING "Eff=#.### I. eff=#.### S. eff=#.###"; ETA#; EI#; ES#
NEXT TH1%
INPUT "Enter to continue"; ZZ$
STOP



        


