﻿Imports System.Windows.Forms.DataVisualization.Charting

Public Class Frequency_response_form

    Public Filter_Frequency_Response As New Series()

    Private Sub fill_data_series()
        Dim i As Integer
        Dim start_index, end_index As Integer

        start_index = Plot_start_value / frequency_step
        end_index = Plot_end_value / frequency_step

        FileOpen(1, "c:\temp\response.dat", OpenMode.Output)   ' Open file for output.

        For i = start_index To end_index
            REM Frequency_response_graph.Series("Filter_Frequency_Response").Points.AddXY((i * frequency_step), frequency_response(i))
            PrintLine(1, (i * frequency_step), " ", frequency_response(i))
        Next
        FileClose(1)
        Shell("c:\gnuplot_4.2\gnuplot\bin\pgnuplot c:/temp/response.plt", AppWinStyle.NormalNoFocus, True)
    End Sub
    Private Sub Frequency_response_form_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        calculate_frequency_response()
        display_samples = (Plot_end_value - Plot_start_value) / frequency_step
        plot_x_interval = (Plot_end_value - Plot_start_value) / 10

        If ((plot_x_interval < 100) And ((Plot_end_value - Plot_start_value) > 500)) Then
            plot_x_interval = 100
        Else
            If ((plot_x_interval <= 200) And (plot_x_interval > 100)) Then
                plot_x_interval = 100
            Else
                If ((plot_x_interval <= 400) And (plot_x_interval > 200)) Then
                    plot_x_interval = 200
                Else
                    If ((plot_x_interval <= 1000) And (plot_x_interval > 400)) Then
                        plot_x_interval = 400
                    Else
                        plot_x_interval = 1000
                    End If
                End If
            End If
        End If


        FileOpen(1, "c:\temp\response.plt", OpenMode.Output)   ' Open file for output.
        PrintLine(1, "set angles radians")
        PrintLine(1, "unset xtics")
        PrintLine(1, "unset xrange")
        PrintLine(1, "unset yrange")
        PrintLine(1, "unset mxtics")
        PrintLine(1, "unset mytics")
        PrintLine(1, "unset ytics")
        PrintLine(1, "set xrange [", Plot_start_value, ":", Plot_end_value, "]")
        PrintLine(1, "set yrange [", Plot_min_dB_value, ":", Plot_max_dB_value, "]")
        PrintLine(1, "set grid xtics ytics  mxtics mytics")
        PrintLine(1, "set mxtics 2")
        PrintLine(1, "set mytics 5")
        PrintLine(1, "set samples", display_samples)
        PrintLine(1, "set xtics")
        PrintLine(1, "set ytics ", Plot_min_dB_value, ",", 10, ",", Plot_max_dB_value)
        PrintLine(1, "set xtics ", Plot_start_value, ", ", plot_x_interval, ", ", Plot_end_value)
        REM PrintLine(1, "set ytics",  -2, 0.1, 2")
        PrintLine(1, "set xlabel ""Frequency""")
        PrintLine(1, "set ylabel ""Filter Response""")
        PrintLine(1, "set grid linetype 13, linetype 13")
        PrintLine(1, "set grid mxtics")
        PrintLine(1, "set grid mytics")
        PrintLine(1, "plot ""c:/temp/response.dat"" smooth csplines")
        PrintLine(1, "pause mouse")
        FileClose(1)

        fill_data_series()
    End Sub

    Private Sub setup_chart()
        Frequency_response_graph.Titles.Add("Plot of Filter Coefficients")
        Frequency_response_graph.ChartAreas.Add("Filter_Frequency_Response")
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.MajorGrid.Interval = 200
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.LabelStyle.Interval = 200
        REM Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.LabelStyle.Format = "##.##"
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.MajorGrid.Interval = 200
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.MinorGrid.Interval = 20
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.MinorTickMark.Interval = 20
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisX.MajorTickMark.Interval = 200
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisY.MinorGrid.Interval = 2
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisY.MajorGrid.Interval = 10
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisY.LabelStyle.Interval = 10
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisY.Minimum = -60
        Frequency_response_graph.ChartAreas("Filter_Frequency_Response").AxisY.Maximum = 10
        Frequency_response_graph.Series.Add("Filter_Frequency_Response")
        Frequency_response_graph.Series("Filter_Frequency_Response").ChartType = SeriesChartType.Line

    End Sub
End Class