﻿Imports System.Char

Public Class Form1

    Private nonNumberEntered As Boolean = False
    Private Sub fill_data_series()
        Dim i As Integer
        Dim start_index, end_index As Integer

        start_index = Plot_start_value / frequency_step
        end_index = Plot_end_value / frequency_step

        FileOpen(1, "c:\temp\response.dat", OpenMode.Output)   ' Open file for output.

        For i = start_index To end_index
            REM Frequency_response_graph.Series("Filter_Frequency_Response").Points.AddXY((i * frequency_step), frequency_response(i))
            PrintLine(1, (i * frequency_step), " ", frequency_response(i))
        Next
        FileClose(1)
        Shell("c:\gnuplot_4.2\gnuplot\bin\pgnuplot c:/temp/response.plt", AppWinStyle.NormalNoFocus, True)
    End Sub
    Private Sub Frequency_response_display()

        calculate_frequency_response()
        display_samples = (Plot_end_value - Plot_start_value) / frequency_step
        plot_x_interval = (Plot_end_value - Plot_start_value) / 10

        If ((plot_x_interval < 100) And ((Plot_end_value - Plot_start_value) > 500)) Then
            plot_x_interval = 100
        Else
            If ((plot_x_interval <= 200) And (plot_x_interval > 100)) Then
                plot_x_interval = 100
            Else
                If ((plot_x_interval <= 400) And (plot_x_interval > 200)) Then
                    plot_x_interval = 200
                Else
                    If ((plot_x_interval <= 1000) And (plot_x_interval > 400)) Then
                        plot_x_interval = 400
                    Else
                        plot_x_interval = 1000
                    End If
                End If
            End If
        End If


        FileOpen(1, "c:\temp\response.plt", OpenMode.Output)   ' Open file for output.
        PrintLine(1, "set angles radians")
        PrintLine(1, "unset xtics")
        PrintLine(1, "unset xrange")
        PrintLine(1, "unset yrange")
        PrintLine(1, "unset mxtics")
        PrintLine(1, "unset mytics")
        PrintLine(1, "unset ytics")
        PrintLine(1, "set xrange [", Plot_start_value, ":", Plot_end_value, "]")
        PrintLine(1, "set yrange [", Plot_min_dB_value, ":", Plot_max_dB_value, "]")
        PrintLine(1, "set grid xtics ytics  mxtics mytics")
        PrintLine(1, "set mxtics 2")
        PrintLine(1, "set mytics 5")
        PrintLine(1, "set samples", display_samples)
        PrintLine(1, "set xtics")
        PrintLine(1, "set ytics ", Plot_min_dB_value, ",", 10, ",", Plot_max_dB_value)
        PrintLine(1, "set xtics ", Plot_start_value, ", ", plot_x_interval, ", ", Plot_end_value)
        REM PrintLine(1, "set ytics",  -2, 0.1, 2")
        PrintLine(1, "set xlabel ""Frequency""")
        PrintLine(1, "set ylabel ""Filter Response""")
        PrintLine(1, "set grid linetype 13, linetype 13")
        PrintLine(1, "set grid mxtics")
        PrintLine(1, "set grid mytics")
        PrintLine(1, "plot ""c:/temp/response.dat"" smooth csplines")
        PrintLine(1, "pause mouse")
        FileClose(1)

        fill_data_series()
    End Sub



    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click

        If ((ComboBox1.Text = "") Or (ComboBox2.Text = "") Or (CoefficientsTextBox.Text = "") Or (Rejection_Box.Text = "")) Then
            Exit Sub
        End If
        If (ComboBox2.Text = "Band Pass") Then
            If ((Low_Cutoff_box.Text = "") Or (High_Frequency_Box.Text = "")) Then
                Exit Sub
            End If
        Else
            If ((ComboBox2.Text = "Low Pass") And (Low_Cutoff_box.Text = "")) Then
                Exit Sub
            Else
                If ((ComboBox2.Text = "High Pass") And (High_Frequency_Box.Text = "")) Then
                    Exit Sub
                End If
            End If
        End If
        filter_calculation()
        Frequency_response_display()
    End Sub
    'simple line curve
    Private Sub DrawlineGraph()
    End Sub

    Private Sub ComboBox1_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox1.SelectedIndexChanged
        Dim sample_rate_text As String
        sample_rate_text = ComboBox1.Text
        sample_frequency = CInt(sample_rate_text)
        Plot_end_value = sample_frequency / 2
        Plot_End_frequency.Text = Plot_end_value

    End Sub


    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub CoefficientsTextBox_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles CoefficientsTextBox.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Back Then
                    ' A non-numerical keystroke was pressed. 
                    ' Set the flag to true and evaluate in KeyPress event.
                    nonNumberEntered = True
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub CoefficientsTextBox_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles CoefficientsTextBox.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'CoefficientsTextBox_KeyPress


    Private Sub CoefficientsTextBox_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles CoefficientsTextBox.TextChanged

        If (CoefficientsTextBox.Text <> "") Then
            coefficients = CInt(CoefficientsTextBox.Text)
        End If


    End Sub
    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub Low_Cutoff_box_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Low_Cutoff_box.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Back Then
                    ' A non-numerical keystroke was pressed. 
                    ' Set the flag to true and evaluate in KeyPress event.
                    nonNumberEntered = True
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub Low_Cutoff_box_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Low_Cutoff_box.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'Low_Cutoff_box_KeyPress


    Private Sub Low_Cutoff_box_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Low_Cutoff_box.TextChanged

        If ComboBox2.Text = "Band Pass" Then
            If (Low_Cutoff_box.Text = "") Then
                Exit Sub
            End If
            fl = CInt(Low_Cutoff_box.Text)
        Else
            If (Low_Cutoff_box.Text = "") Then
                Exit Sub
            End If
            fh = CInt(Low_Cutoff_box.Text)
            fl = 0
        End If

    End Sub

    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub High_Frequency_Box_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles High_Frequency_Box.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Back Then
                    ' A non-numerical keystroke was pressed. 
                    ' Set the flag to true and evaluate in KeyPress event.
                    nonNumberEntered = True
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub High_Frequency_Box_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles High_Frequency_Box.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'High_Frequency_Box_KeyPress


    Private Sub High_Frequency_Box_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles High_Frequency_Box.TextChanged


        If ComboBox2.Text = "Band Pass" Then
            If (High_Frequency_Box.Text = "") Then
                Exit Sub
            End If
            fh = CInt(High_Frequency_Box.Text)
        Else
            If (High_Frequency_Box.Text = "") Then
                Exit Sub
            End If
            fl = CInt(High_Frequency_Box.Text)
            fh = sample_frequency / 2
        End If

    End Sub

    Private Sub ComboBox2_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox2.SelectedIndexChanged
        Dim Filter_type_text As String
        Filter_type_text = ComboBox2.Text
        Low_Cutoff_box.Enabled = False
        High_Frequency_Box.Enabled = False
        If (Filter_type_text = "Low Pass") Then
            Low_Cutoff_box.Enabled = True
        End If
        If (Filter_type_text = "High Pass") Then
            High_Frequency_Box.Enabled = True
        End If
        If (Filter_type_text = "Band Pass") Then
            Low_Cutoff_box.Enabled = True
            High_Frequency_Box.Enabled = True
        End If

    End Sub

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        sample_frequency = 8000
        fl = 0
        fh = 1100
        stop_band = 40
        coefficients = 11
        Plot_end_value = 4000
        Plot_start_value = 0
        Plot_max_dB_value = 10
        Plot_min_dB_value = -60


    End Sub

    Private Sub Quit_button_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Quit_button.Click
        Frequency_response_form.Close()
        End
    End Sub

    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub Plot_start_frequency_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Plot_start_frequency.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Back Then
                    ' A non-numerical keystroke was pressed. 
                    ' Set the flag to true and evaluate in KeyPress event.
                    nonNumberEntered = True
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub Plot_start_frequency_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Plot_start_frequency.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'Plot_start_frequency_KeyPress



    Private Sub Plot_start_frequency_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Plot_start_frequency.TextChanged

        If (Plot_start_frequency.Text <> "") Then
            Plot_start_value = CInt(Plot_start_frequency.Text)
        End If
        If (Plot_start_value < 0) Then
            Plot_start_value = 0
        End If
        If (Plot_start_value > sample_frequency / 2) Then
            Plot_start_value = 0
        End If
        If (Plot_start_value > Plot_end_value) Then
            Plot_start_value = 0
        End If
    End Sub

    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub Plot_End_frequency_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles Plot_End_frequency.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Back Then
                    ' A non-numerical keystroke was pressed. 
                    ' Set the flag to true and evaluate in KeyPress event.
                    nonNumberEntered = True
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub Plot_End_frequency_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles Plot_End_frequency.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'Plot_End_frequency_KeyPress

    Private Sub Plot_End_frequency_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Plot_End_frequency.TextChanged

        If (Plot_End_frequency.Text <> "") Then
            Plot_end_value = CInt(Plot_End_frequency.Text)
        End If
        If (Plot_end_value < 0) Then
            Plot_end_value = sample_frequency / 2
        End If
        If (Plot_end_value > sample_frequency / 2) Then
            Plot_end_value = sample_frequency / 2
        End If
        If (Plot_end_value < Plot_start_value) Then
            Plot_end_value = sample_frequency / 2
        End If

    End Sub

    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub Plot_min_db_box_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles plot_min_db_box.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                If e.KeyCode <> Keys.Subtract Then
                    ' Determine whether the keystroke is a backspace.
                    If e.KeyCode <> Keys.Back Then
                        ' A non-numerical keystroke was pressed. 
                        ' Set the flag to true and evaluate in KeyPress event.
                        nonNumberEntered = True
                    End If
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub Plot_min_db_box_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles plot_min_db_box.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'Plot_min_db_box_KeyPress

    Private Sub plot_min_db_box_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles plot_min_db_box.TextChanged

        If (plot_min_db_box.Text = "-") Then
            Exit Sub
        End If
        If (plot_min_db_box.Text <> "") Then
            Plot_min_dB_value = CInt(plot_min_db_box.Text)
        End If
    End Sub

    ' Handle the KeyDown event to determine the type of character entered into the control.
    Private Sub Plot_max_db_box_KeyDown(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles plot_max_db_box.KeyDown
        ' Initialize the flag to false.
        nonNumberEntered = False

        ' Determine whether the keystroke is a number from the top of the keyboard.
        If e.KeyCode < Keys.D0 OrElse e.KeyCode > Keys.D9 Then
            ' Determine whether the keystroke is a number from the keypad.
            If e.KeyCode < Keys.NumPad0 OrElse e.KeyCode > Keys.NumPad9 Then
                ' Determine whether the keystroke is a backspace.
                If e.KeyCode <> Keys.Subtract Then
                    If e.KeyCode <> Keys.Back Then
                        ' A non-numerical keystroke was pressed. 
                        ' Set the flag to true and evaluate in KeyPress event.
                        nonNumberEntered = True
                    End If
                End If
            End If
        End If
        'If shift key was pressed, it's not a number.
        If Control.ModifierKeys = Keys.Shift Then
            nonNumberEntered = True
        End If
    End Sub 'textBox1_KeyDown


    ' This event occurs after the KeyDown event and can be used 
    ' to prevent characters from entering the control.
    Private Sub Plot_max_db_box_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles plot_max_db_box.KeyPress
        ' Check for the flag being set in the KeyDown event.
        If nonNumberEntered = True Then
            ' Stop the character from being entered into the control since it is non-numerical.
            e.Handled = True
        End If
    End Sub 'Plot_max_db_box_KeyPress

    Private Sub plot_max_db_box_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles plot_max_db_box.TextChanged
        If (plot_max_db_box.Text = "-") Then
            Exit Sub
        End If

        If (plot_max_db_box.Text <> "") Then
            Plot_max_dB_value = CInt(plot_max_db_box.Text)
        End If
    End Sub
End Class
