struct AudioDevice
{
  LPGUID guid;
  string description;
  string module;
  AudioDevice (){
    guid = NULL;
  }
  ~AudioDevice (){
    delete guid;
  }
};

typedef vector<AudioDevice*> AudioDevices;


extern AudioDevices input_audio_devices;
extern AudioDevices output_audio_devices;
extern const char* app_title;
extern int input_device, output_device;
extern HRESULT user_input(void);
extern HRESULT setup_output_buffer(void);
extern HRESULT setup_input_buffer(void);
extern HRESULT read_input_data(unsigned char buffer[], DWORD *bytes_read);
extern HRESULT write_output_data(unsigned char buffer[], DWORD bytes_read);
extern int phase_table[256];
extern int phase_increment;
extern DWORD top_of_buffer;
extern LPDIRECTSOUND p_output_object;
extern LPDIRECTSOUNDCAPTURE p_direct_capture_object;
extern int deviation;

extern LPDIRECTSOUNDCAPTUREBUFFER  p_input_buffer;
extern LPDIRECTSOUNDBUFFER p_direct_sound_buffer;


// This must be one of the native audio sample rates
#define DESIRED_SAMPLE_RATE 48000L
// This must be a power of 2
#define MAX_ACCUMULATOR     262144l
#define ACCUMULATOR_MASK    (MAX_ACCUMULATOR - 1)
// Number of bits for right shift phase accumulator to get an 8 bit result
#define PHASE_DIVISOR       10

