;


	list      p=16F676       ; list directive to define processor
	#include <p16f676.inc>    ; processor specific variable definitions



	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _INTRC_OSC_NOCLKOUT & _MCLRE_OFF & _CPD_OFF
;	__CONFIG  _CP_OFF & _WDT_OFF & _BODEN & _PWRTE_ON & _HS_OSC & _MCLRE_OFF & _CPD_OFF
; '__CONFIG' directive is used to embed configuration word within .asm file.
; The labels following the directive are located in the respective .inc file.
; See data sheet for additional information on configuration word settings.

;******************************************************************************
;Defines
;******************************************************************************

#define Bank0		0x00
#define	Bank1		0x80
#define	counter 	0x08

;*******************************************************************************
;LCD defines
;********************************************************************************
#define LCD			0x05			;pin RA5 connected to LCD data line
#define	LED1		0x05			;pin RC5 connected to LED1
#define LED2		0x04			;pin RC4 connected to LED2
#define	LCD_BKSPC	0x08			;move cursor left
#define	LCD_RT		0x09			;move cursor right
#define	LCD_LF		0x0A			;move cursor down 1 line
#define LCD_CLS		0x0C			;clear LCD (allow 5 ms delay to complete)
#define	LCD_CR		0x0D			;move position 0 of next line
#define	LCD_BL_ON	0x11			;backlight on
#define	LCD_BL_OFF	0x12			;backlight off
#define LCD_OFF		0x15			;LCD off
#define LCD_ON1		0x16			;LCD on, cursor off, blink off
#define LCD_ON2		0x17			;LCD on, cursor off, blink on
#define LCD_ON3		0x18			;LCD on, cursor on, blink off
#define	LCD_ON4		0x19			;LCD on, cursor on, blink on
#define LCD_LINE0	0x80			;move to line 1, column 0, add position to 0x80
#define LCD_LINE1	0x94			;move to line 2, column 0, add position to 0x94
#define LCD_LINE2	0xA8			;move to line 3, column 0, add position to 0xA8
#define LCD_LINE3	0xBC			;move to line 4, column 0, add position to 0xBC
;end LCD defines


;EEPROM defines
#define read		b'00000011'
#define	write		b'00000010'
#define	EEPROMWREN	b'00000110'
#define	CS			.0				;Chip Select at PORTC,0
#define SI			.3				;SI at PORTC,3
#define SO			.3				;SO at PORTA,3
#define clk			.2				;Clock at PORTC,2

;Menu defines
#define clock_menu	.11
#define clock_offset .16
#define running_menu .16
#define running_offset .0
#define start_menu	.11
#define start_offset .27
#define stop_menu	.10
#define	stop_offset .38
#define collect_menu .12
#define collect_offset .57
#define wait_menu	.9
#define	waiting_offset .48

;clock command defines
#define w_sec	b'10000000'
#define r_sec	b'10000001'
#define w_min	b'10000010'
#define r_min	b'10000011'
#define w_hr	b'10000100'
#define	r_hr	b'10000101'
#define	w_cmd	b'10001110'
#define	w_trick	b'10010000'
#define	rst		.1					;RC1, DS1302 chip select
#define i_o		.4					;RC4, I/O pin
;#define	clk		.2					;RC2, clock (shared with EEPOROM)


;button defines
#define menu_btn .1
#define	hr_btn	.2
#define	exe_btn .3
#define TX_PDN	.4		;PORTA, 4 TX Power Down Line 
;******************************************************************************

;******************************************************************************
;General Purpose Registers (GPR's) 
;******************************************************************************

	cblock	0x20
	;EEPROM 24-bit memory address bytes
	eememl			;EEPROM 24-bit memory bytes - low
	eememm			;middle
	eememh			;high
	eememl_max
	eememm_max
	eememh_max
	readbyte		;used in rtc
	writebyte
	cmdbyte
	databyte
	loopcounter		;used in rtc
	offset			;used in the menu display
	send_count

	start_hour
	start_minute
	stop_hour
	stop_minute
	hr				;used to hold real time
	min				;holds 10's hr/min/sec in high nibble	
	sec				;holds 1's hr/min/sec in low nibble
	t_10_hr
	t_1_hr
	t_10_min
	t_1_min
	tog_temp		;used in the collection routine
	flag
	count
	msd				;used in binary to bcd
	lsd				;used in binary to bcd
	tempa
	delay_count
	bitcounter
	byte_to_send
	text_counter

	;********************************
	;used by Binary to BCD Converter
	countBCD
	temp
	h_byte
	h_byte_temp
	l_byte
	l_byte_temp
	r0
	r1
	r2
	;********************************
	endc


;******************************************************************************
;Reset Vector 
;******************************************************************************
	ORG     0x000         	; processor reset vector
	nop						; required by in circuit debugger  
	goto    Init            ; go to beginning of program

;******************************************************************************
;Interrupt Vector     
;******************************************************************************
	ORG	0x004
	btfss	PORTA, menu_btn	;deboune button, this read clears change on RA1
	goto	$-1
	bcf		INTCON, RAIF	;clear port change interrupt flag
	goto	menu			;return to main without enabling global interrupts
	return			; interrupt trap - returns without re-enabling
;******************************************************************************
;Initialization
;******************************************************************************
Init
	BANKSEL	Bank1
	movlw	0x64		;if factory setting is lost, use this line with the 
						;appropriate calibration value and comment out the
						;next line.
;	call    0x3FF      	;retrieve factory calibration value
	movwf	OSCCAL
	BANKSEL	Bank0		;select bank0

	clrf	PORTA		;clear port bus
	movlw	b'00000111'	;non inverted, comp with output
	movwf	CMCON		;/
	movlw	b'00001000'	;globals disabled, interrupt on change enabled
	movwf	INTCON
	movlw	b'10000001'	;right justified,Vdd ref RA0 has ADC, ADC Stop, ADC on
	movwf	ADCON0
	BANKSEL	Bank1		; BANK1
	movlw	b'00000000'	;load w reg with timer0 values 
	movwf	OPTION_REG	;put w reg into option register
	movlw	b'00010000'	;Fosc/8
	movwf	ADCON1
	movlw	b'00000110' ;weak pull up on RA1, RA2, RA4
	movwf	WPUA
	movlw	b'00000010'	;interrupt on change enabled for RA1
	movwf	IOCA
	movlw	b'00001111'		;pin 0,1,2,3 input 
	movwf	TRISA		;program PORTA
	movlw	b'00010000'		;pin 4 input now, change to input later
	movwf	TRISC		;program PORTC
	movlw	b'00000001'	;RA0 ADC
	movwf	ANSEL		
	BANKSEL	Bank0		;back to bank0
	bcf		PORTA, TX_PDN	;turn off transmitter
	
;*****************************************************************************
;Initialize the LCD display
;*****************************************************************************
	bsf		PORTA,LCD			;set to high for resting state
	bsf		PORTC,0				;set to high for resting TX state
	call	wait1sec		;to allow LCD to inialize
	movlw	LCD_CLS
	call	LCDOutput
;	call	wait50mS
	call	delay5mS		;to allow LCD to complete clear
;end LCD initialization
;****************************************************************************
;Initialize rtc
;****************************************************************************
	bcf		PORTC, rst
	bcf		PORTC, clk	
	movlw	w_cmd
	movwf	cmdbyte
	clrf	databyte
	call	w_rtc
	movlw	w_trick
	movwf	cmdbyte
	call	w_rtc
	movlw	w_sec
	movwf	cmdbyte
	call	w_rtc
;*****************************************************************************
;end pic initialization

;*****************************************************************************
menu

menu_set_clock
	movlw	clock_menu				;load lenght of string
	movwf	text_counter
	movlw	clock_offset			;load offset
	movwf	offset
	call	display_menu			;displays 'clock'
	btfss	PORTA, exe_btn			;if exe btn not pressed, skip next
	goto	set_time
	btfsc	PORTA, menu_btn			;if menu btn not pressed, go back
	goto	$-3
	btfss	PORTA, menu_btn			;deboune button
	goto	$-1
menu_start_time
	movlw	start_menu				;load lenght of string
	movwf	text_counter
	movlw	start_offset			;load offset
	movwf	offset
	call	display_menu			;displays 'start'
	btfss	PORTA, exe_btn
	goto	set_start_time
	btfsc	PORTA, menu_btn
	goto	$-3
	btfss	PORTA, menu_btn			;deboune button
	goto	$-1
menu_stop_time
	movlw	stop_menu				;load lenght of string
	movwf	text_counter
	movlw	stop_offset				;load offset
	movwf	offset
	call	display_menu			;displays 'stop'
	btfss	PORTA, exe_btn
	goto	set_stop_time
	btfsc	PORTA, menu_btn
	goto	$-3
	btfss	PORTA, menu_btn			;deboune button
	goto	$-1	
menu_start_collection
	movlw	wait_menu				;load lenght of string
	movwf	text_counter
	movlw	waiting_offset			;load offset
	movwf	offset
	call	display_menu			;displays 'waiting'
	btfss	PORTA, exe_btn
	goto	start_collecting
	btfsc	PORTA, menu_btn
	goto	$-3
	btfss	PORTA, menu_btn			;deboune button
	goto	$-1

menu_running
	movlw	running_menu			;load lenght of string
	movwf	text_counter
	movlw	running_offset			;load offset
	movwf	offset
	call	display_menu			;displays "Time....ADC'
	movf	PORTA, f				;clear condition
	movlw	b'10001000'				;clear RAIF, enable change interrupts
	movwf	INTCON		
selfloop
	call 	get_time
	call	get_ADC
	call	display_DEC
	goto	selfloop

	goto	menu

;**********************************************************************
;Use this routine to get the current time from the RTC and then display
;that time at line 1, position zero.
;**********************************************************************
get_time
	movlw	LCD_LINE1
	call	LCDOutput
	movlw	r_sec
	movwf	cmdbyte
	call	r_rtc
	movfw	readbyte
	movwf	sec
	movlw	r_min
	movwf	cmdbyte
	call	r_rtc
	movfw	readbyte
	movwf	min
	movlw	r_hr
	movwf	cmdbyte
	call	wait100mS
	call	r_rtc
	movfw	readbyte
	movwf	hr
	call	delay5mS
	call	display_time
	call	wait50mS
	return
;***********************************************************************

senddata

	movlw	'U'
	call	tx_output
	movlw	'U'
	call	tx_output
	movlw	'U'
	call	tx_output
	movlw	'U'
	call	tx_output
	movlw	.13
	call	tx_output
	movlw	'D'
	call	tx_output
	movlw	'A'
	call	tx_output
	movlw	'T'
	call	tx_output
	movlw	'A'
	call	tx_output
	movlw	','
	call	tx_output

send_loop
	call	tx_DEC
	call	delay5mS
	movlw	.13
	call	tx_output
	call	delay5mS
	
	return


;*****************************************************************************
;clear_eemem
;A call to this routine will reset the EEPROM memory address to
;0x00,0x00,0xff.  The first increment of the low byte of the address will then
;start the memory address at zero
;
;*****************************************************************************
clear_eemem
	clrf	eememh
	clrf	eememm
	clrf	eememl
	return

;*****************************************************************************
;*******************************************************************************
;Increment EEPROM memory address
;The start of EEPROM memory should be set prior to call of this routine.
;*******************************************************************************
inc_mem
	incf	eememl		;increment low byte of EEPROM memory address
	btfss	STATUS,Z	;check if there was a carry in low byte
	return				;if no carry then return
	incf	eememm		;if carry then increment middle byte of address
	btfss	STATUS,Z	;check if there was a carry in middle byte
	return				;if no carry then return
	incf	eememh		;if carry then increment high byte of address
	btfss	STATUS,Z	;check if there was a carry in high byte
	return
	clrf	eememl		;if the high byte carried then start at zero
	clrf	eememm
	return

;******************************************************************************	

;*****************************************************************************
;readingdata
;before calling this routine for the first time, make sure you reset the 
;EEPROM memory address (to zero).
;A call to this routine will return one byte stored in memory to readbyte.
;The move the contents of readbyte into another location for further manipulation
;like h_byte or l_byte for conversion.
;
;******************************************************************************
readingdata
	bcf		PORTC,CS			;start read
	movlw	read
	call	byte_to_eeprom
	call	inc_mem
	movfw	eememh
	call	byte_to_eeprom
	movfw	eememm
	call	byte_to_eeprom
	movfw	eememl
	call	byte_to_eeprom

	movlw	.8
	movwf	bitcounter
	clrf	readbyte
reading
	rlf		readbyte,f			;rotate bit left into readbyte
	bcf		readbyte,0			;assume 0 bit
	bsf		PORTC,clk			;toggle clock high
	btfsc	PORTA,SO			;read SO line while clock high
	bsf		readbyte,0			;if SO high then set bit
	bcf		PORTC,clk			;toggle clock low
	decfsz	bitcounter
	goto reading
	bsf		PORTC,CS

	return
;*****************************************************************************

;*****************************************************************************
;writing data
;before calling this routine for the first time make sure to sent the EEPROM
;memory address to zero.
;Before the call, put the data to be stored into writebyte variable.
;
;*****************************************************************************	

writingdata
	bcf		PORTC,CS			;start send
	movlw	EEPROMWREN			;sending write enable command
	call	byte_to_eeprom	
	bsf		PORTC,CS

	bcf		PORTC,CS
	movlw	write				;send write command
	call	byte_to_eeprom
	call	inc_mem
	movfw	eememh
	call	byte_to_eeprom
	movfw	eememm
	call	byte_to_eeprom
	movfw	eememl
	call	byte_to_eeprom
	movfw	writebyte				;byte to store
	call	byte_to_eeprom
	bsf		PORTC,CS			;complete write
	call	delay5mS
	return
;*****************************************************************************

;******************************************************************************
;Put a byte into EEPROM
;The byte to place should be in the Wreg before this routine is called.
;******************************************************************************
byte_to_eeprom
	movwf	byte_to_send	;store byte to send in memory location
	movlw	.8				;load bit counter with 8 bits
	movwf	bitcounter
bit_send
	bcf		PORTC,SI			;assume bit to load is clear
	bcf		STATUS,C
	rlf		byte_to_send,f	;rotate MSB bit into carry
	btfsc	STATUS,C		;check if bit is clear, if so, skip
	bsf		PORTC,SI			;if set, set bit to load
	bsf		PORTC,clk		
	bcf		PORTC,clk			;toggle clock
	decfsz	bitcounter
	goto	bit_send
	return

;******************************************************************************
	
;*****************************************************************************
;Get ADC
;The routine will access the ADC and return the 10-bit value with high byte in
;h_byte and the low byte in l_byte.
;The ADC is connected to RA0
;*****************************************************************************
get_ADC
	bsf		ADCON0,GO
wait_ADC
	btfsc	ADCON0,GO
	goto	wait_ADC
	movfw	ADRESH
	movwf	h_byte
	BANKSEL	Bank1
	movfw	ADRESL
	BANKSEL	Bank0
	movwf	l_byte
	return

;******************************************************************************

;*****************************************************************************
;
;Display 10-bit decimal number (from ADC)
;put high byte in h_byte
;put low byte in l_byte
;call display_DEC
;
;*****************************************************************************
display_DEC
	movlw	LCD_LINE1+.12
	call	LCDOutput
	call	b2_BCD
	swapf	r1,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	r1
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	swapf	r2,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	r2
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	return
;end display_DEC
;*******************************************************************************
tx_DEC
	call	b2_BCD
	swapf	r1,w
	andlw	b'00001111'
	addlw	.48
	call	tx_output
	movfw	r1
	andlw	b'00001111'
	addlw	.48
	call	tx_output
	swapf	r2,w
	andlw	b'00001111'
	addlw	.48
	call	tx_output
	movfw	r2
	andlw	b'00001111'
	addlw	.48
	call	tx_output
	return
;******************************************************************************
;use this routine to input time digits that are used to set time varibles
;******************************************************************************

setting_times
	btfss	PORTA, exe_btn	;debounce button
	goto	$-1
	clrf	t_10_hr
	clrf	t_1_hr
	clrf	t_10_min
	clrf	t_1_min
	clrf	hr
	clrf	min
	clrf	sec
	call	display_time	
	movlw	LCD_ON3			;turn on blinking cursor
	call	LCDOutput

wait_hr10
	movlw	LCD_LINE1		;move to start of time
	call 	LCDOutput

	movlw	b'00001100'
	xorwf	PORTA, w
	btfsc	STATUS, Z
	goto	wait_hr10
	btfss	PORTA, hr_btn
	goto	hr_btn_press
	btfss	PORTA, exe_btn
	goto	exe_btn_press
	goto	wait_hr10

hr_btn_press
	btfss	PORTA, hr_btn	;debounce hr button
	goto	$-1
	incf	t_10_hr			;add 1 to 10's hr
	movlw	b'00000011'		;3
	xorwf	t_10_hr,w			;check to see if it is 3
	btfsc	STATUS, Z
	clrf	t_10_hr				;if 3, reset to 0
	movfw	t_10_hr
	addlw	.48				;convert to ACSII for display
	call	LCDOutput
	goto	wait_hr10
exe_btn_press
	btfss	PORTA, exe_btn
	goto	$-1
	movfw	t_10_hr
	swapf	t_10_hr, w			;put 10's hr in upper nibble
	andlw	b'11110000'		;clear lower nibble
	movwf	hr
wait_hr1
	movlw	LCD_LINE1+1		;move to start of time
	call 	LCDOutput
	movlw	b'00001100'
	xorwf	PORTA, w
	btfsc	STATUS, Z
	goto	wait_hr1
	btfss	PORTA, hr_btn
	goto	hr1_btn_press
	btfss	PORTA, exe_btn
	goto	exe1_btn_press
	goto	wait_hr1
hr1_btn_press
	btfss	PORTA, hr_btn
	goto	$-1
	incf	t_1_hr
	movlw	b'00001010'		;9
	xorwf	t_1_hr, w
	btfsc	STATUS, Z
	clrf	t_1_hr
	movfw	t_1_hr
	addlw	.48
	call	LCDOutput
	goto	wait_hr1
exe1_btn_press
	btfss	PORTA, exe_btn
	goto	$-1
	movfw	t_1_hr
	andlw	b'00001111'
	addwf	hr
	movlw	0x24
	subwf	hr,w
	btfsc	STATUS, C
	goto	wait_hr10

wait_min10
	movlw	LCD_LINE1+3		;move to start of minute
	call 	LCDOutput
	movlw	b'00011000'
	xorwf	PORTA, w
	btfsc	STATUS, Z
	goto	wait_min10
	btfss	PORTA, hr_btn
	goto	min_btn_press
	btfss	PORTA, exe_btn
	goto	exe_btn_press_min
	goto	wait_min10
min_btn_press
	btfss	PORTA, hr_btn	;debounce hr button
	goto	$-1
	incf	t_10_min			;add 1 to 10's hr
	movlw	b'00000110'		;6
	xorwf	t_10_min,w			;check to see if it is 6
	btfsc	STATUS, Z
	clrf	t_10_min				;if 6, reset to 0
	movfw	t_10_min
	addlw	.48				;convert to ACSII for display
	call	LCDOutput
	goto	wait_min10
exe_btn_press_min
	btfss	PORTA, exe_btn
	goto	$-1
	movfw	t_10_min
	swapf	t_10_min, w			;put 10's hr in upper nibble
	andlw	b'11110000'		;clear lower nibble
	movwf	min	
wait_min1
	movlw	LCD_LINE1+4		;move to start of time
	call 	LCDOutput
	movlw	b'00011000'
	xorwf	PORTA, w
	btfsc	STATUS, Z
	goto	wait_hr1
	btfss	PORTA, hr_btn
	goto	min1_btn_press
	btfss	PORTA, exe_btn
	goto	exe1_btn_press_min
	goto	wait_min1
min1_btn_press
	btfss	PORTA, hr_btn
	goto	$-1
	incf	t_1_min
	movlw	b'00001010'		;9
	xorwf	t_1_min, w
	btfsc	STATUS, Z
	clrf	t_1_min
	movfw	t_1_min
	addlw	.48
	call	LCDOutput
	goto	wait_min1
exe1_btn_press_min
	btfss	PORTA, exe_btn
	goto	$-1
	movfw	t_1_min
	andlw	b'00001111'
	addwf	min
	movlw	LCD_ON1
	call	LCDOutput
	return
;******************************************************************************

;******************************************************************************
;Use this routine to set the time in the RTC.  This routine calls other relevant 
;routines.
;******************************************************************************
set_time
	btfss	PORTA, exe_btn	;debounce button
	goto	$-1
	movf	PORTA, f		;clear condition
	movlw	b'10001000'		;clear RAIF, enable change interrupts
	movwf	INTCON
	call	setting_times	;this call gets the time digits from user
	call	load_rtc		;this call puts time digits into rtc
	goto	menu_start_time
;******************************************************************************

;******************************************************************************
;Use this routine to set the start collection time.  This routine calls other
;relevant routines.
;******************************************************************************
set_start_time
	btfss	PORTA, exe_btn	;debounce button
	goto	$-1
	movf	PORTA, f		;clear condition
	movlw	b'10001000'		;clear RAIF, enable change interrupts
	movwf	INTCON
	call	setting_times
	movfw	hr
	movwf	start_hour
	movfw	min
	movwf	start_minute
	goto	menu_stop_time
;******************************************************************************

;******************************************************************************
;Use this routine to set the stop collection time.  This routine calls other 
;relevant routines.
;******************************************************************************
set_stop_time
	btfss	PORTA, exe_btn	;debounce button
	goto	$-1
	movf	PORTA, f		;clear condition
	movlw	b'10001000'		;clear RAIF, enable change interrupts
	movwf	INTCON
	call	setting_times
	movfw	hr
	movwf	stop_hour
	movfw	min
	movwf	stop_minute
	goto 	menu_start_collection
;******************************************************************************
	
;******************************************************************************
;Use this routine to load the time into the RTC.  Preload hour, minute, second
;into the varibles hr, min, sec and then call this routine.
;******************************************************************************
load_rtc
	movlw	w_hr
	movwf	cmdbyte
	movfw	hr
	movwf	databyte
	call	w_rtc
	movlw	w_min
	movwf	cmdbyte
	movfw	min
	movwf	databyte
	call	w_rtc
	movlw	w_sec
	movwf	cmdbyte
	clrf	databyte
	call	w_rtc
	movlw	LCD_ON1
	call 	LCDOutput
	return
;******************************************************************************
;Use this routine to wait and begin collecting ADC data a storing it in EEPROM.
;******************************************************************************

start_collecting
	btfss	PORTA, exe_btn	;debounce button
	goto	$-1 
	movf	PORTA, f		;clear condition
	movlw	b'10001000'		;clear RAIF, enable change interrupts
	movwf	INTCON
	call	clear_eemem		;start at the beginning of eemem
;	call	waiting_collection
awaiting_collection
	call 	get_time		;put time in hr, min, and sec
	call	get_ADC
	call	display_DEC
	movfw	start_hour		;retrieve start hour
	xorwf	hr,w			;check it against current hour
	btfss	STATUS, Z		;if not the same then continue
	goto	awaiting_collection
	movfw	start_minute	;retrieve start minute
	xorwf	min,w			;check it against current minute
	btfss	STATUS, Z		;if not the same then continue
	goto	awaiting_collection
	movf	sec				;check if the value of sec is zero
	btfss	STATUS, Z		;if not zero then continue
	goto	awaiting_collection

;begin collecting
	movlw	collect_menu
	movwf	text_counter
	movlw	collect_offset
	movwf	offset
	call	display_menu	;displays 'collecting'

	bcf		flag, 0			;set flag for collecting zero sec

awaiting_end_collection
	call 	get_time		;put time in hr, min, and sec
	call	get_ADC
	call	display_DEC
	movfw	stop_hour
	xorwf	hr,w
	btfss	STATUS, Z		;if not the same then continue
	goto	continue_collect
	movfw	stop_minute
	xorwf	min, w
	btfss	STATUS, Z		;if not the same then continue

;	end of collection routine goes here
	goto	continue_collect
	goto	readdata
;this is where the dump data routine would go then return to waiting after data dump

;after data dump
	movlw	wait_menu
	movwf	text_counter
	movlw	waiting_offset
	movwf	offset
	call	display_menu	;displays 'waiting'
	goto	awaiting_collection

continue_collect
	movfw	sec
	movwf	tog_temp
	movlw	b'00001111'		;mask 10's sec
	andwf	tog_temp, f
	
	btfss	flag, 0			;check if 0 or 5 sec data point is next
						;1 for 5 sec, 0 for zero sec
	goto	zero_tog		;skip if 5 sec

;get 5 sec data point
	movlw	0x05			;load 5 into low nibble
	xorwf	tog_temp, w		;check if tog_temp is 0x05
	btfss	STATUS, Z		;Z flag set if equal
	goto	awaiting_end_collection
	bcf		flag, 0			;it is equal so zero sec data is next
	goto	tog_RA4			
	

zero_tog
	movf	tog_temp		;check if zero
	btfss	STATUS, Z		;skip if zero
	goto	awaiting_end_collection
;get zero sec data point
	bsf		flag, 0			;it is equal so 5 sec data is next
	goto	tog_RA4
	

tog_RA4

	call	store			;collect data point and store in eemem
	goto	awaiting_end_collection	
;******************************************************************************

;******************************************************************************
;
;******************************************************************************
store

store_loop

	call	get_time
	call	get_ADC
	movfw	h_byte
	movwf	writebyte
	call	writingdata			;send data to eemem
	movfw	l_byte
	movwf	writebyte
	call	writingdata
	call	display_DEC
	movfw	eememl				;update and store the max eemem location
	movwf	eememl_max
	movfw	eememm
	movwf	eememm_max
	movfw	eememh
	movwf	eememh_max
	return

readdata
	bsf		PORTA, TX_PDN		;turn on transmitter
	call	clear_eemem			;start at the beginning

read_loop
	call	readingdata
	movfw	readbyte
	movwf	h_byte
	call	readingdata
	movfw	readbyte
	movwf	l_byte
;	call	display_DEC
	call	senddata

	movfw	eememh_max
	xorwf	eememh,w
	btfss	STATUS, Z
	goto	read_loop
	movfw	eememm_max
	xorwf	eememm,w
	btfss	STATUS, Z
	goto	read_loop
	movfw	eememl_max
	xorwf	eememl,w
	btfss	STATUS, Z
	goto	read_loop

next_collection
	bcf		PORTA, TX_PDN		;turn off transmitter
	movlw	wait_menu
	movwf	text_counter
	movlw	waiting_offset
	movwf	offset
	call	display_menu

	call	clear_eemem
	goto	awaiting_collection
;******************************************************************************

;******************************************************************************
;Use this routine to send the time data to the real time clock DS1302 device
;Hour in varible hr, minutes in varible min, seconds will be set to 00 by
;default.  DS1302 RST pin on RC1 (rst), I/O pin on RC4 (i_o), clock pin on RC2
;(clk).  clk low before rst goes high.  Data in on rising clock, out on falling
;clock.  Data sent LSB first.  Set rst high, send bits, rst low.
;Put data byte into databyte, command byte into cmdbyte before call.
;******************************************************************************
w_rtc
	BANKSEL	Bank1
	bcf		TRISC, i_o		;make I/O pin an output pin
	BANKSEL	Bank0
	movlw	.8
	movwf	loopcounter		;set bit count
	bsf		PORTC, rst		;set rst high to start write
	movfw	cmdbyte
	movwf	writebyte
	call	w_loop
	movlw	.8
	movwf	loopcounter		;set bit count
	movfw	databyte
	movwf	writebyte
	call	w_loop
	bcf		PORTC, rst		;complete rtc write
	BANKSEL	Bank1
	bsf		TRISC, i_o		;make I/O pin an input pin
	BANKSEL	Bank0
	return

w_loop
	bcf		PORTC, i_o		;assume bit is low
	rrf		writebyte, f	;rotate bit right (LSB) into carry bit
	btfsc	STATUS, C		;if C low, skip next
	bsf		PORTC, i_o		;set bit high
	bsf		PORTC, clk		
	bcf		PORTC, clk		;clock in bit on rising edge
	decfsz	loopcounter
	goto	w_loop
	return

;******************************************************************************
;Use this routine to read the time from the DS1302 real time clock.  After 
;setting the rst line high, make the I/O pin an output to send the command
;byte.  Make the I/O pin an input to receive the data byte from the rtc, LSB
;first.  Put the command byte into cmdbyte, the output will be placed in
;readbyte.  Move readbyte into hr, min, or sec as appropriate.  Data is clocked
;out on the falling edge of the clk line, data is clocked in on the rising edge
;of clk.
;*******************************************************************************
r_rtc
	BANKSEL	Bank1
	bcf		TRISC, i_o		;make I/O pin an output pin
	BANKSEL	Bank0
	movlw	.8
	movwf	loopcounter		;set bit count
	bsf		PORTC, rst		;set rst high to start write
	movfw	cmdbyte
	movwf	writebyte
	call	w_loop

	BANKSEL	Bank1
	bsf		TRISC, i_o		;make I/O pin an input pin
	BANKSEL	Bank0
	movlw	.8
	movwf	loopcounter		;set bit count

r_loop
	bcf		STATUS,	C		;assume bit is low
	btfsc	PORTC, i_o
	bsf		STATUS, C		;set bit high
	rrf		readbyte, f		;rotate right the carry bit
	bsf		PORTC, clk
	bcf		PORTC, clk
	decfsz	loopcounter
	goto	r_loop

	bcf		PORTC, rst
	return
	
;******************************************************************************
;real time is loaded into hr, min, and sec with the 10's digit in the high
;nibble, and the 1's digit is the low nibble
;******************************************************************************
display_time
	movlw	LCD_LINE1		;goto line 1, space 0
	call	LCDOutput
	swapf	hr,w			;put 10's hr digit into low nibble of w-reg
	andlw	b'00001111'		;mask the 1's digit of hr
	addlw	.48				;convert to ASCII
	call	LCDOutput		;display digit
	movfw	hr				;put hr into w-register
	andlw	b'00001111'		;mask 10's digit
	addlw	.48				;convert to ASCII
	call	LCDOutput		;display
	movlw	':'				;display colon separator
	call	LCDOutput
	swapf	min,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	min
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movlw	':'				;display colon separator
	call	LCDOutput
	swapf	sec,w
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput
	movfw	sec
	andlw	b'00001111'
	addlw	.48
	call	LCDOutput

	return
;*******************************************************************************

;*****************************************************************************
;
;LCD Output
;put the desired value into the w register and call LCDOutput
;
;*****************************************************************************
LCDOutput

	movwf	byte_to_send
	movlw .8
	movwf bitcounter	;set up to send 8 bits
	bcf		PORTA,LCD			;send start bit
	call	bitdelay
nextbit
	rrf		byte_to_send,f	;sending lsb first
	btfss	STATUS,C
	bcf		PORTA,LCD
	btfsc	STATUS,C
	bsf		PORTA,LCD
	call	bitdelay
	decfsz	bitcounter,f
	goto	nextbit
	bsf		PORTA,LCD		;set to high for resting state
	call	delay5mS
	call	delay5mS
	return
;end LCDOutput
;*******************************************************************************
tx_output
;	byte to send is put into W reg before calling the subroutine
	movwf	byte_to_send
	movlw 	.8
	movwf 	bitcounter	;set up to send 8 bits
	bcf		PORTC,5			;send start bit
	call	txbitdelay
nextTXbit
	rrf		byte_to_send,f	;sending msb first
	btfss	STATUS,C
	bcf		PORTC,5
	btfsc	STATUS,C
	bsf		PORTC,5
	call	txbitdelay
	decfsz	bitcounter,f
	goto	nextTXbit
	bsf		PORTC,5		;set to high for resting state
	call	delay5mS
;	call	delay5mS
	return
;end LCDOutput

;******************************************************************************
;
;Binary to BCD converter
;Put binary value to be converted into h_byte and l_byte
;then call b2_BCD.  Decimal converstion is returned in r0, r1, and r2
;with MSB in lower nibble of r0.
;
;******************************************************************************
b2_BCD
	movfw	h_byte
	movwf	h_byte_temp
	movfw	l_byte
	movwf	l_byte_temp
	bcf		STATUS,C
	movlw	.16
	movwf	countBCD
	clrf	r0
	clrf	r1
	clrf	r2
loop16
	rlf		l_byte_temp,f
	rlf		h_byte_temp,f
	rlf		r2,f
	rlf		r1,f
	rlf		r0,f
	
	decfsz	countBCD,f
	goto	adjDEC
	retlw	0

adjDEC
	movlw	r2
	movwf	FSR
	call	adjBCD
	
	movlw	r1
	movwf	FSR
	call	adjBCD

	movlw	r0
	movwf	FSR
	call	adjBCD

	goto	loop16

adjBCD
	movlw	3
	addwf	0,w
	movwf	temp
	btfsc	temp,3
	movwf	0
	movlw	30
	addwf	0,w
	movwf	temp
	btfsc	temp,7
	movwf	0
	retlw	0
;end Binary to BCD Converter
;******************************************************************************	

;******************************************************************************
;Delay Routines
;******************************************************************************
wait1sec
		call	wait300mS
		call	wait300mS
		call	wait300mS
		goto	wait100mS
wait300mS
        call    delay50mS
wait250mS
        call    delay50mS
        call    delay50mS
        call    delay50mS
wait100mS
        call    delay50mS
wait50mS
        call    delay50mS
		return
;delay1ms, is a very accurate 1mS delay for a 4Mhz clock.
delay1mS
        movlw   .198
        movwf   count
        nop
        goto    $+1
        goto    $+1
dly1mS        
        goto    $+1
        decfsz  count, F
        goto    dly1mS
        return
;delay5mS uses delay1mS to get a very accurate 5 mS delay
delay5mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        call    delay1mS
        movlw   .4
        movwf   count
tweek5mS
        decfsz  count, F
        goto    tweek5mS
        return
;delay50mS uses delay1mS to get a very accurate 50mS delay
delay50mS
        movlw   .50
        movwf   tempa
dly50mS
        call    delay1mS
        decfsz  tempa, F
        goto    dly50mS
        movlw   .14
        movwf   count
tweek50mS
        decfsz  count, F
        goto    tweek50mS
        return

txbitdelay
		movlw	.134			;this number works for 2400 baud required for RF transmission
								;data
		goto 	continue_tx

bitdelay
		movlw	.28				;this number works if the user uses the calbrated
								;value for the internal clock. This routine, including
								;the goto and nop statements below allow the user to develop
								;an anticipated delay of 100uS for the bits at 9600 Baud.
								;This delay can be verified by using the stop watch function
								;of MPLab Simulator 
continue_tx
		movwf	count
		goto    $+1				;these goto statements allow you tweek the time of the
		goto	$+1				;delay.  Goto statements like this take 2 clock cycles
		nop						;while the nop statement takes 1 clock cycle to complete


bit
		decfsz	count, f
		goto	bit
		return
;end delay rountines


;*********************************************************************************************
;Menu display subroutines
;
;**********************************************************************************************
;**********************************************************************************************
;Use this routine to display menu items.  Load the offset and the lenght of the menu item into
;the varible offset and text_counter before calling this subroutine.
;
;use this routine to call the static text that is contained in table.
;the programming technique avoids a problem with using the program counter
;to jump across memory pages.  The PCL is only 8 bits so any offset that goes
;beyond 255 will cause problems because of a jump across a memory page.  This 
;code checks if the PCL+offset goes over 255 by checking the carry bit.  If the
;carry bit is set, 1 is added to the high byte of the program counter PCLATH to jump
;the next page.
;
;*****************************************************************************

;**********************************************************************************************
display_menu

menu_loop
	movlw	LOW menu_table			;get low byte of table's location
	addwf	offset,w				;add the offset to the low byte
	movlw	HIGH menu_table			;get the high byte of table's location
	btfsc	STATUS,C			;check to see if a page has been crossed
	addlw	1					;if so, add 1 to the high byte
	movwf	PCLATH				;put the adjusted high byte into counter
;	movfw	offset				;put offset in the w register
	call	menu_display			;jump into the table
	call	LCDOutput			;this call puts the character on the LCD
	incf	offset
	decfsz	text_counter			;decrement the table counter, continue if not zero
	goto	menu_loop
	return						;from text_display


;******************************************************************************
;
;data
;
;*****************************************************************************

menu_display
	movfw 	offset		;put the table offset into w
	addwf	PCL,f		;add the offset to the program counter to jump to character
menu_table	dt	LCD_CLS,'T', 'i', 'm', 'e', ' ',' ',' ',' ',' ',' ',' ',' ','A','D','C'
	dt	LCD_CLS,'S', 'E', 'T', ' ','C', 'L', 'O', 'C', 'K', LCD_LINE1
	dt	LCD_CLS, 'S', 'E', 'T', ' ', 'S', 'T', 'A', 'R', 'T', LCD_LINE1
	dt	LCD_CLS,'S', 'E', 'T', ' ','S', 'T', 'O', 'P', LCD_LINE1
	dt	LCD_CLS, 'W', 'A', 'I', 'T', 'I', 'N', 'G', LCD_LINE1
	dt	LCD_CLS, 'C', 'O', 'L', 'L', 'E', 'C', 'T', 'I', 'N', 'G', LCD_LINE1


	end
