; mainkey.asm
; assembler file for mainline code
;=========Have your QSK and QRO it too ============================================================
;	for modifying keying pulse from TEN-TEC OMNI VI+
;	transciever for driving a new QSK keying circuit in HEATH SB-220
;	linear amplifier
;	program by Roger Monroe K7NTW
; 		low going transmitt pulse fron transciever is input to PIC 
;	on pin 2 (GP5); Pin 3 (GP4) is brought high program waits 
;	for input to rise 
;		pot 1 value is loaded into delay routine which delays
;	output going high for a short period, pot 2 value is loaded
;	for count down to stretch output pulse after input goes high
;		provide for external reset (MCLR)
;	revision May 5,2008 incorporate PTT on pin 5 (GP2)
;==================================================================================================
;	20 May 2007
;	orginally coded 12C672 migrated to FLASH device 6 June 2007
;===================================================================================================
		list	p=12F675, mm=ON
	
		__config	_MCLRE_ON & _CP_OFF & _CPD_OFF & _PWRTE_ON & _WDT_OFF & _INTRC_OSC_NOCLKOUT
		processor	12F675
		include	p12F675.inc
		
		extern  stretch
		extern	delay
		extern	del_20
		extern 	POT_1,POT_2
		extern	RELAY
		extern	del_200

		radix	hex
		errorlevel 1, -302
;-----------------------------------------------------------------------------------------------

STARTUP		code
		
			goto	Start
			code
Start

		bsf     STATUS,RP0        ; set file register bank to 1 
		call    0x3FF             ; retrieve factory calibration value
		movwf   OSCCAL            ; update register with factory cal value 
		bcf		STATUS,RP0	;select bank 0

; PIN 7 IS AN0 (POT_1)   PIN6 IS AN1 (POT_2)  PIN2 IS GP5 INPUT
; PIN 3 IS GP4 OUTPUT rev 5/08 pin 5 (GP2) PTT input
; initilize port for 2 data input 1 data output and 2
; analog inputs 
		clrf	GPIO
		movlw	07h
		movwf	CMCON
		bsf		STATUS,RP0	; select bank 1
		clrf	ANSEL
		movlw	b'00101111'	;AN0,1,MCLR-inputs GP5-INPUT GP4-OUTPUT
		movwf	TRISIO
		movlw	b'01010011'	; conv clk /16 pin 6,7 analog 5,3 digital
		movwf	ANSEL
		bcf		STATUS,RP0	;select bank 0
		bcf		RELAY,GP4	; 
		movf	RELAY,W		; clear relay in RAM 
		movwf	GPIO		; turn off QSK relays
		bcf		INTCON,GIE	;disable all interrupts

;----get analog readings from stretch and delay pots--------------------------------------------
rdpot1		movlw	b'00000001'	;Left justified sel AN0,internal rc osc
			movwf	ADCON0
			call	del_20		;20 microsecond
			bsf		ADCON0,GO	;start conversion
			btfsc	ADCON0,GO	; wait till A/D complete
			goto	$-1			;loop untill busy flag cleared
			movf	ADRESH,W	;retreve 8 MS bits A/D data
			movwf	POT_1		;save pot position
rdpot2		movlw	b'00000101'	;Left justified config a/d sel AN1
			movwf	ADCON0		;and repeat 
			call	del_20		
			bsf		ADCON0,GO
			btfsc	ADCON0,GO
			goto	$-1
			movf	ADRESH,W	;retreve 8 MS bits A/D data
			movwf	POT_2		;save pot position
;-----------------------------------------------------------------------------------
omnirelay	btfss	GPIO,GP2	; is PTT relay closed?
			goto	ptt			; yes 
			nop
; ----------------------------------------------------------------		
main
			btfsc	GPIO,GP5	; key line loop
			goto	$-1			; wait for OMNI TX OUT to go LO
			call	delay		; then hold for POT 2 setting
			btfsc	GPIO,GP5	; see if pulse is too short to be valid
			goto	main		; too fast a pulse ignore it
			bsf		GPIO,GP4	; set relay on in RAM
			nop					; let port settle
			nop 
			btfss	GPIO,GP5	; wait for OMNI TX OUT to go HI
			goto	$-1			; still in transmitt
holdoff		call	stretch		; RF still flowing so hold off
			bcf		GPIO,GP4	; RF has stopped flowing
			goto	rdpot1		; go wait next transmit request
; -----------------------------------------------------------------
ptt			
			bsf		GPIO,GP4	; set relay on in RAM
			nop
			call	del_200
			btfss	GPIO,GP2	; is PTT relay off?
			goto	$-1			; no wait for it
			goto 	holdoff	

;			org		0x3ff
;			retlw	0x80		;return code for debug only
;								comment out before programming
	
			end
