REM     FIR FILTER DESIGN      firdsn3.bas
REM     Bandpass, Kaiser Window
REM     RSL  27 Dec 98

DIM g(150), w(150), b(301)

pi = 3.14159265359#
PRINT
PRINT "FIR Filter Design, Low-pass, Band-pass or High-pass"
INPUT "Number of FIR coefficients? ", nf
INPUT "Sample rate, Hz? ", fs
PRINT
PRINT "The following two entries define the pass band of the filter."
PRINT "The first number is the start of the pass-band.  If it is 0 the filter"
PRINT "is low-pass.  The second number (upper cutoff frequency) is the"
PRINT "top of the pass-band.  If it is set to half of the sampling frequency"
PRINT "the filter is high-pass."
PRINT
INPUT "Lower Cutoff Frequency, Hz, between 0 and half of sample rate? ", f1
INPUT "Upper Cutoff Frequency, Hz, between 0 and half of sample rate? ", f2
INPUT "Stop-band Attenuation, dB (eg 55.0)? ", db
PRINT

f1 = f1 / fs
f2 = f2 / fs
n = INT((nf + 1) / 2)

REM The variable odd=1 when nf is an odd number, otherwise odd=0.
odd = 0
IF 2 * INT(n + .1) - 1 = nf THEN odd = 1

REM Calculate the FIR coefficients g(j) based on the Fourier transform of
REM a rectangular frequency response.
c1 = f2 - f1
IF odd = 1 THEN
    g(1) = 2! * c1
    j0 = 2
ELSE
    j0 = 1
END IF
FOR j = j0 TO n
    xn = j - 1
    IF odd = 0 THEN xn = xn + .5
    c = pi * xn
    c3 = c * c1
    g(j) = SIN(c3) / c
    g(j) = g(j) * 2! * COS(c * (f1 + f2))
NEXT j

REM Find beta, a parameter that determines the out-of-band attenuation.
IF db > 50 THEN
    beta = .1102 * (db - 8.7)
ELSEIF (db > 20.96 AND db <= 50!) THEN
    beta = .58417 * (db - 20.96) ^ .4 + .07886 * (db - 20.96)
ELSE
    beta = 0!
END IF

REM Find Kaiser window factors w(j) that limit the out-of-band response.
x = beta
GOSUB Bessi0
bes = in0
xind = (nf - 1) * (nf - 1)
FOR j = 1 TO n
    xi = j - 1
    IF odd = 0 THEN xi = xi + .5
    xi = 4! * xi * xi
    x = beta * SQR(1! - xi / xind)
    GOSUB Bessi0
    w(j) = in0 / bes
NEXT j

REM Window the ideal filter response:
FOR j = 1 TO n
    g(j) = g(j) * w(j)
NEXT j

REM Rearrange to be causal filter coefficients:
FOR j = 1 TO n
    b(j) = g(n + 1 - j)
NEXT j
FOR j = n + 1 TO nf
    IF odd = 1 THEN
        b(j) = g(j - n + 1)
    ELSE
        b(j) = g(j - n)
    END IF
NEXT j

FOR j = 1 TO nf
    PRINT "Coefficient "; j; " = "; b(j)
NEXT j

INPUT "Hit Enter to continue", Z$
STOP

REM  Bessi0  -  Returns in0, Modified Bessel function Io(x) for any real x.
REM  From Press, et. al., Numerical Recepies in C, 2nd Ed. p237.
Bessi0:
ax = ABS(x)
IF ax < 3.75 THEN
    y = x / 3.75
    y = y * y
    exp0 = .2659732# + y * (.0360768 + y * .0045813)
    in0 = 1! + y * (3.5156229# + y * (3.0899424# + y * (1.2067492# + y * exp0)))
ELSE
    y = 3.75 / ax
    exp0 = y * (-.01647633# + y * 3.92377E-03)
    exp1 = y * (-.02057706# + y * (.02635537# + exp0))
    exp2 = y * (2.25319E-03 + y * (-1.57565E-03 + y * (9.16281E-03 + exp1)))
    in0 = (EXP(ax) / SQR(ax)) * (.39894228# + y * (.01328592# + exp2))
    END IF
RETURN

END

