#! /usr/bin/octave -qf
#
# Print header

printf("\n\n     *** TRANSMISSION LINE CALCULATIONS ***\n");

# Specify transmission line data

f = 7.01;   #   FREQUENCY IN MHz

# 75 ohm line

d1 = 40;
a1 = 0.75;
v1 = 83;
Zo1 = 75;

# 600 ohm line

d2 = 200;
a2 = 0.05;
v2 = 92;
Zo2 = 600;

# Specify source (transmitter) and load (antenna)

VS = 2.0;
RS = 50;
Rt = 50;
Xt = 0;

# Convert inputs as required

#75 ohm line

a1 = a1 ./ 1e2;  # convert dB per 100 feet to dB per foot
a1 = 0.1151 .* a1;  # convert dB to nepers
c = 9.836e8;  # speed of light in feet per second
lambda = c ./ (1e6 .* f);  # wavelength of signal in vacuum
lambda1 = (v1 ./ 1e2) .* lambda; # adjust lambda for velocity
B1 = (2 .* pi) ./ lambda1; # calculate Beta

#600 ohm line

a2 = a2 ./ 1e2;  # convert dB per 100 feet to dB per foot
a2 = 0.1151 .* a2;  # convert dB to nepers
lambda2 = (v2 ./ 1e2) .* lambda; # adjust lambda for velocity
B2 = (2 .* pi) ./ lambda2; # calculate Beta


ZL = Rt .+ j .* Xt;  # calculate complex terminating impedance

# Calculate elements of T-equivalent network

# ZA = input series element
# ZB = output series element
# ZC = shunt element

ZA1 = Zo1 .* tanh((a1 .+ j .*B1) .* d1 ./ 2.);
ZB1 = ZA1;
ZC1 = Zo1 ./ sinh((a1 .+ j .*B1) .* d1);


ZA2 = Zo2 .* tanh((a2 .+ j .*B2) .* d2 ./ 2.);
ZB2 = ZA2;
ZC2 = Zo2 ./ sinh((a2 .+ j .*B2) .* d2);


# Prepare matrices for solution of currents

right_side = [RS .+ ZA1 .+ ZC1, -ZC1, 0; -ZC1, ZC1 ...
   .+ ZB1 .+ ZA2 .+ ZC2, -ZC2; 0, -ZC2, ZB2 .+ ZC2 .+ ZL];
left_side = [VS; 0; 0];

# Solve for currents

denom = det(right_side);
for m = 1: rows(right_side)
   numerator = right_side;
   for n = 1: rows(right_side)
      numerator(n, m) = left_side(n);
   endfor
   current(m) = det(numerator) / denom;
endfor

# Print out currents

for m = 1:rows(right_side)
   if imag(current(m)) < 0
      printf("\n\n  LOOP %d CURRENT = %8.5g - j%-8.5g\n", ...
      m, real(current(m)), -imag(current(m)));
   else
      printf("\n\n  LOOP %d CURRENT = %8.5g + j%-8.5g\n", ...
      m, real(current(m)), imag(current(m)));
   endif
printf("\n\n  LOOP %d CURRENT MAGNITUDE = %8.5g\n", ...
m, abs(current(m)));
endfor
# end program




 
