#! /usr/bin/octave -qf

# Print header

printf("\n\n     *** TRANSMISSION LINE CALCULATIONS ***\n");

# Enter input data from keyboard

f = input("\n                               FREQUENCY IN MHz: ");
d = input("\n                         LENGTH OF LINE IN FEET: ");
a = input("\n                 ATTENUATION IN dB PER 100 FEET: ");
v = input("\n                VELOCITY FACTOR AS A PERCENTAGE: ");
Zo = input("\n               CHARACTERISTIC IMPEDANCE IN OHMS: ");
Rt = input("\n     REAL PART OF TERMINATING IMPEDANCE IN OHMS: ");
Xt = input("\nIMAGINARY PART OF TERMINATING IMPEDANCE IN OHMS: ");

# Convert inputs as required

a = a ./ 1e2;  # convert dB per 100 feet to dB per foot
a = 0.1151 .* a;  # convert dB to nepers
c = 9.836e8;  # speed of light in feet per second
lambda = c ./ (1e6 .* f);  # wavelength of signal in vacuum
lambda = (v ./ 1e2) .* lambda; # adjust lambda for velocity
B = (2 .* pi) ./ lambda; # calculate Beta
Zt = Rt .+ j .* Xt;  # calculate complex terminating impedance

# Calculate elements of T-equivalent network

# ZA = input series element
# ZB = output series element
# ZC = shunt element

ZA = Zo .* tanh((a .+ j .*B) .* d ./ 2.);
ZB = ZA;
ZC = Zo ./ sinh((a .+ j .*B) .* d);

# Calculate input impedance

#Zd = Zo .* tanh((a .+ j .* B) .* d .+ atanh(Zt ./ Zo));

#Zd = Zo .* ((Zt .* cosh((a .+ j .*B) .* d) .+ Zo .* ...
#sinh((a .+ j .*B) .* d)) ./ (Zt .* sinh((a .+ j .*B) .* d) ...
#.+ Zo .* cosh((a .+ j .*B) .* d)));

Zd = ZA .+ (ZC .* (ZB + Zt)) ./ (ZC .+ ZB .+ Zt);

# Print results

for k = 1:columns(Zd)
   if imag(Zd(k)) < 0
      printf("\n\n  INPUT IMPEDANCE = %8.5g - j%-8.5g\n\n", ...
      real(Zd(k)), abs(imag(Zd(k))));
   else
      printf("\n\n  INPUT IMPEDANCE = %8.5g + j%-8.5g\n\n", ...
      real(Zd(k)), imag(Zd(k)));
   endif
endfor

# End input impedance program
