
#define UART_0				UBRR0
#define UART_1				UBRR1


#if 	defined(__AVR_ATmega8__) 	|| \
		defined(__AVR_ATmega16__)	|| \
      defined(__AVR_ATmega32__)   
	#define NUM_OF_BAUDREGS	2
	#define SIGNAL_RXCOMPLETE SIG_UART_RECV
	#define SIGNAL_TXCOMPLETE SIG_UART_DATA
	#define BAUD0H_REG		UBRRH
	#define BAUD0L_REG		UBRRL
   #define NUM_OF_UARTS    1
	#define RXTXEN0_REG		UCSRB
	#define STAT0RXTX_REG 	UCSRA
   #define UDR0				UDR
   #define RX0EN				RXEN
   #define TX0EN				TXEN
   #define RX0C				RXC
   #define UDR0E				UDRE

#elif	defined(__AVR_AT90S4433__)
	#define NUM_OF_BAUDREGS	1
	#define SIGNAL_RXCOMPLETE SIG_UART_RECV
	#define SIGNAL_TXCOMPLETE SIG_UART_DAT
	#define BAUD0L_REG		UBRR
   #define NUM_OF_UARTS    1
	#define RXTXEN0_REG		UCSRB
	#define STAT0RXTX_REG 	UCSRA
   #define UDR0				UDR
   #define RX0EN				RXEN
   #define TX0EN				TXEN
   #define RX0C				RXC
   #define UDR0E				UDRE

#elif defined(__AVR_AT90S8515__) || \
		defined(__AVR_AT90S2313__) || \
      defined(__AVR_AT90S8535__) || \
      defined(__AVR_ATmega103__)
	#define BAUDREGS			1
	#define SIGNAL_RXCOMPLETE SIG_UART_RECV
	#define SIGNAL_TXCOMPLETE SIG_UART_DAT
	#define BAUD0L_REG		UBRR
   #define NUM_OF_UARTS    1
	#define RXTXEN0_REG		UCR
	#define STAT0RXTX_REG 	USR
   #define UDR0				UDR
   #define RX0EN				RXEN
   #define TX0EN				TXEN
   #define RX0C				RXC
   #define UDR0E				UDRE

//if chip is AtMega128
#elif 	defined(__AVR_ATmega128__) || \
		defined(__AVR_ATmega64__)
	#define NUM_OF_BAUDREGS	2
	#define SIGNAL_RXCOMPLETE SIG_UART0_RECV
	#define SIGNAL_TXCOMPLETE SIG_UART0_DATA
	
	#define BAUD0H_REG		UBRR0H
	#define BAUD0L_REG		UBRR0L
   #define NUM_OF_UARTS    2
	#define RXTXEN0_REG		UCSR0B
	#define STAT0RXTX_REG 	UCSR0A
	
//  #define UDR0				UDR0 don't need to redefine it
   #define RXC0IEN			RXCIE0
   #define TXC0IEN			TXCIE0
   #define RX0EN				RXEN0
   #define TX0EN				TXEN0
   #define RX0C				RXC0
   #define UDR0E				UDRE0

	#define BAUD1H_REG		UBRR1H
	#define BAUD1L_REG		UBRR1L
	#define RXTXEN1_REG		UCSR1B
	#define STAT1RXTX_REG 	UCSR1A
//  #define UDR1				UDR1 don't need to redefine it
   #define RX1EN				RXEN1
   #define TX1EN				TXEN1
   #define RX1C				RXC1
   #define UDR1E				UDRE1

#else
	#error "No supported chip type in use for UART.C"
#endif




int UART_putchar(char c);
int UART_getchar(void);
void UART_first_init(void);
void OutStr(uint8_t *str);		// sends 'str' out to serial port

