/*
 * Decompiled with CFR 0.152.
 */
package processing.app.syntax.im;

import java.awt.Rectangle;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import processing.app.syntax.JEditTextArea;
import processing.app.syntax.im.CompositionTextManager;

public class InputMethodSupport
implements InputMethodRequests,
InputMethodListener {
    private int committed_count = 0;
    private CompositionTextManager textManager;

    public InputMethodSupport(JEditTextArea textArea) {
        this.textManager = new CompositionTextManager(textArea);
        textArea.enableInputMethods(true);
        textArea.addInputMethodListener(this);
    }

    public Rectangle getTextLocation(TextHitInfo offset) {
        return this.textManager.getTextLocation();
    }

    public TextHitInfo getLocationOffset(int x, int y) {
        return null;
    }

    public int getInsertPositionOffset() {
        return this.textManager.getInsertPositionOffset();
    }

    public AttributedCharacterIterator getCommittedText(int beginIndex, int endIndex, AttributedCharacterIterator.Attribute[] attributes) {
        return this.textManager.getCommittedText(beginIndex, endIndex);
    }

    public int getCommittedTextLength() {
        return this.committed_count;
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributes) {
        return null;
    }

    public void inputMethodTextChanged(InputMethodEvent event) {
        AttributedCharacterIterator text = event.getText();
        this.committed_count = event.getCommittedCharacterCount();
        if (this.isBeginInputProcess(text, this.textManager)) {
            this.textManager.beginCompositionText(text, this.committed_count);
            this.caretPositionChanged(event);
            return;
        }
        if (this.isInputProcess(text)) {
            this.textManager.processCompositionText(text, this.committed_count);
            this.caretPositionChanged(event);
            return;
        }
        this.textManager.endCompositionText(text, this.committed_count);
        this.caretPositionChanged(event);
    }

    private boolean isBeginInputProcess(AttributedCharacterIterator text, CompositionTextManager textManager) {
        if (text == null) {
            return false;
        }
        return this.isInputProcess(text) && !textManager.getIsInputProcess();
    }

    private boolean isInputProcess(AttributedCharacterIterator text) {
        if (text == null) {
            return false;
        }
        return text.getEndIndex() - (text.getBeginIndex() + this.committed_count) > 0;
    }

    public void caretPositionChanged(InputMethodEvent event) {
        event.consume();
    }
}

